# (nowrap)

# 	kThinkClass			= FOUR_CHAR_CODE('KAHL'),
# 	kModifiedEvtID			= FOUR_CHAR_CODE('MOD '),
# 	kGetTextEvtID 			= FOUR_CHAR_CODE('GTTX'),
# 	kGetDebugEvtID			= FOUR_CHAR_CODE('GTDS'),
# 	kPutDebugEvtID			= FOUR_CHAR_CODE('PTDS'),
# 	kWindowSearchEvtID		= FOUR_CHAR_CODE('SRCH'),
# 	kMarkerUpdateEvtID		= FOUR_CHAR_CODE('MKUP'),
# 	kMakeLineOffStEvtID		= FOUR_CHAR_CODE('OFST'),
# 	kFailedFINFEvtID		= FOUR_CHAR_CODE('NONF'),
# 	kOpenProjEvtID			= FOUR_CHAR_CODE('OPRJ'),
# 	kCloseProjEvtID			= FOUR_CHAR_CODE('CPRJ')

alpha::menu thinkMenu 1.0.6 "C C++ Java Pasc" "300" {
    set THINK "THINK Project Manager"
    #set THINK "AEvent Display 1.3"

    tclAE::installEventHandler "KAHL" "OPRJ" think::handleOpenProject
    tclAE::installEventHandler "KAHL" "CPRJ" think::handleCloseProject
    tclAE::installEventHandler "KAHL" "NONF" think::handleFailedFINF
    tclAE::installEventHandler "KAHL" "MOD " think::handleModified
    tclAE::installEventHandler "KAHL" "GTTX" think::handleGetText
    tclAE::installEventHandler "KAHL" "SRCH" think::handleWindowSearch

} thinkMenu {} uninstall {this-file} preinit {
    fileset::registerNewType think "list"
} help {
    This menu is for interaction with the Symantec IDE.
}

proc thinkMenu {} {}

Menu -n $thinkMenu {
    "/S<O<Uthink"
    "openHeader"
    "Menu -n thinkFlags {}"
    "thinkCreateFileset"
    "(-"
    "/K<O<Ucompile"
    "checkSyntax"
    "/T<O<UsearchNextFile"
    "(-"
    "add"
    "addAndCompile"
    "(-"
    "disassemble"
    "preprocess"
    "precompile"
    "(-"
    "bringUpToDate"
    "/\\<O<Umake"
    "(-"
    "/I<O<Udebug"
    "/R<O<Urun"
}

namespace eval think {}

# The following flags affect Think's "Run" command.
# THINK will crash if you set the debugger flag and your 
# project does not have debugging information. 
if {![info exists thinkdebugger]} 	{set thinkdebugger 	0}
if {![info exists thinkgo]} 		{set thinkgo 		1}
if {![info exists thinksaveDirty]} 	{set thinksaveDirty	1}
if {![info exists thinkupdate]} 	{set thinkupdate 	1}

Menu -n thinkFlags -p thinkFlagsProc {"debugger" "go" "saveDirty" "update"}
markMenuItem thinkFlags debugger 	$thinkdebugger
markMenuItem thinkFlags go	 		$thinkgo
markMenuItem thinkFlags saveDirty	$thinksaveDirty
markMenuItem thinkFlags update	 	$thinkupdate

proc thinkFlagsProc {menu item} {
    global think$item
    
    set think$item [expr {1-[set think$item]}]
    markMenuItem thinkFlags $item [set think$item]
    prefs::modified think$item
}

proc thinkNumFiles {} {
    global THINK
    set str [AEBuild -r $THINK "core" "cnte" "----" {obj{want:type('PDOC'), from:'null'(), form:'indx', seld:1}} "kocl" "type('SFIL')"]
    if {[regexp {[0-9]+} $str mtch]} {
	return $mtch
    } else {
	error "Bad numfiles"
    }
}



# Get list of files in current project.
proc projectFileList args {
    global SymCompSig
    watchCursor
    app::launchBack $SymCompSig
    set num [thinkNumFiles]
    set files {}
    
    for {set i 1} {$i<=$num} {incr i} {
	set f [thinkFileName $i]
	if {[getFileType $f] == "TEXT"} {
	    lappend files $f
	}
    }
    
    return $files
}




#================================================================================


proc think {} {
    global SymCompSig
    app::launchFore $SymCompSig
}

proc searchNextFile {} {
    thinkFinf
}



#===========================================================================
# Add fileset.
#===========================================================================

namespace eval fileset::think {}

proc thinkCreateFileset {} {
    fileset::think::create
}

proc fileset::think::createTagFile {} { return [alphaCreateTagFile] }

proc fileset::think::selected {fset menu item} {
    if {$fset != ""} {set m $fset} else { set m $menu}
    filesetBasicOpen $m $item
}

proc fileset::think::create {} {
    global gfileSets gfileSetsType
    
    set name [prompt "Fileset name? " "THINK"]
    set gfileSets($name) [lsort -command sortByTail [projectFileList]]
    set gfileSetsType($name) think
    
    return $name
}

proc fileset::think::updateContents {args} {
    eval [list fileset::fromDirectory::updateContents] $args
}


#================================================================================

proc compile {} {
    sendCompileEvent CMPL "-r"
}

proc checkSyntax {} {
    sendCompileEvent SNTX "-q"
}

proc disassemble {} {
    global THINK ALPHA SymCompSig
    app::getSig "Please locate $THINK" SymCompSig
    set tname [file tail [app::launchFore $SymCompSig]]
    set name [win::Current]
    set res [AEBuild -t 7200 -r $tname KAHL DASM CFLG long(32) "----" [fileObject $name]]
    switchTo $ALPHA
    new -n "* [file root [file tail $name]].asm *"
    regexp {.*} $res text
    insertText [string trim $text {}]
    setWinInfo dirty 0
    goto [minPos]
}

proc preprocess {} {
    global THINK ALPHA SymCompSig
    app::getSig "Please locate $THINK" SymCompSig
    set tname [file tail [app::launchFore $SymCompSig]]
    set name [win::Current]
    set res [AEBuild -r $tname KAHL PRCS CFLG long(32) "----" [fileObject $name]]
    switchTo $ALPHA
    new -n "* Preprocessed '[file tail $name]' *"
    regexp {.*} $res text
    insertText [string trim $text {}]
}


proc sendCompileEvent {event arg} {
    global THINK ALPHA SymCompSig
    
    app::getSig "Please locate $THINK" SymCompSig
    set tname [file tail [app::launchFore $SymCompSig]]
    set name [win::Current]
    if {[string length $arg]} {
	set err [catch {AEBuild -t 7200 $arg $tname KAHL  $event "----" [fileObject $name]} res]
    } else {
	set err [catch {AEBuild -t 7200 $tname KAHL  $event "----" [fileObject $name]} res]
    }
    if (!$err) {
	set err [catch {switchTo $ALPHA} res]
    }
    if ($err) {
	message $res
    } else {
	return $res
    }
}


proc add {} {
    global THINK
    set fname [win::Current]
    AEBuild $THINK core crel "data" [makeAlis $fname] "kocl" "type('SFIL')"
}

proc addAndCompile {} {
    add
    compile
}


proc precompile {} {
    sendCompileEvent PCMP ""
}

proc bringUpToDate {} {
    global THINK ALPHA SymCompSig
    app::getSig "Please locate $THINK" SymCompSig
    set name [file tail [app::launchFore $SymCompSig]]
    set res [AEBuild -q $name KAHL CMPL SLCT MAKE "CFLG" "long(2)" "----" {obj{want:type('PDOC'), from:'null'(), form:'indx', seld:1}}] 
    switchTo $ALPHA
    return $res
}

proc make {} {
    global THINK ALPHA SymCompSig
    app::getSig "Please locate $THINK" SymCompSig
    set name [file tail [app::launchFore $SymCompSig]]
    set res [AEBuild -q $name KAHL CMPL SLCT MAKE "CFLG" "long(2)" "----" {obj{want:type('PDOC'), from:'null'(), form:'indx', seld:1}}] 
}

proc run {} {
    global THINK thinkdebugger thinkgo thinksaveDirty thinkupdate SymCompSig
    
    set dbug [expr {$thinkdebugger ? "bool(01)" : "bool(00)"}]
    set go [expr {$thinkgo ? "bool(01)" : "bool(00)"}]
    set update [expr {$thinkupdate ? "'yes '" : "'no  '"}]
    set dirty [expr {$thinksaveDirty ? "'yes '" : "'no  '"}]
    app::getSig "Please locate $THINK" SymCompSig
    set name [file tail [app::launchFore $SymCompSig]]
    if {[catch {AEBuild -q $name KAHL "RUN " "DBUG" $dbug  "GO  " $go "UPDT" $update "savo" $dirty} res]} {
	message $res
    }
}

proc debug {} {
    global THINK 
    switchTo 'LSD'
    set fname [win::Current]
    set row [expr [lindex [posToRowCol [getPos]] 0] - 1]
    if {[catch {AEBuild $THINK KAHL DBGF "----" [makeAlis $fname] LNNO "short($row)" } res]} {
	message $res
    }
}

proc cnt {} {
    global THINK
    AEBuild -t 6000 -r $THINK core cnte "----" {obj{want:type('PDOC'), from:'null'(), form:'indx', seld:1}} "kocl" "type('sfil')"
}

proc thinkFileName {arg} {
    global THINK
    set event [join [concat {obj\ \{want:type('prop'),\ from:obj\ \{want:type('SFIL'),\ from:'null'(),\ form:'indx',\ seld:} $arg {\},\ form:'prop',\ seld:type('FSS\ ')\}}] ""]
    set blah [AEBuild -r $THINK "core" "getd"  "----" $event]
    regexp {.*} $blah blah
    return [specToPathName [string trim $blah {}]]
}

proc thinkInclude {name} {
    global THINK thinkpaths
    if {[info exists thinkpaths]} {unset thinkpaths}
    set event [join [concat {obj\ \{want:type('prop'),\ from:obj\ \{want:type('SFIL'),\ from:'null'(),\ form:'name', seld:} [file tail $name] {\},\ form:'prop',\ seld:type('INCL')\}}] ""]
    set blah [AEBuild -r $THINK "core" "getd"  "----" $event]
    if {![regexp {} $blah]} {return {{(No includes}}}
    regsub -all {[^]*} $blah { } raw
    regsub {[^]*} $raw {} raw
    regsub {.*} $raw {} raw
    foreach f $raw {
	set path [specToPathName $f]
	set tl [file tail $path]
	set thinkpaths($tl) $path
	lappend names $tl
    }
    return [lsort -ignore $names]
}

# Called by Alpha to get list of include files for popup.
proc thinkGetIncludeFiles {} {
    if {[catch {thinkInclude [lindex [winNames] 0]} ret]} {
	return {{(* THINK not running *}}
    }
    return $ret
}

# Called by Alpha to edit result of popup
proc thinkEditIncludeFile {name} {
    global thinkpaths
    
    edit $thinkpaths($name)
}

proc openHeader {} {
    global thinkpaths
    
    set name [lindex [winNames] 0]
    if {![string length $name]} return
    if {[catch {thinkInclude $name} names]} {
	message "Think not running!" 
	beep
	return
    }
    if {![string length $name] || [string match {(*} [lindex $names 0]]} {
	message "No headers."
	beep
	return
    }
    set res [listpick -p {Include File?} $names]
    if {[string length $res]} {edit $thinkpaths($res)}
}
		

#================================================================================
		
proc handleThinkReply { reply } {
    global ALPHA
    switchTo $ALPHA

    browse::Start "* Compiler Errors *" "%d errors (<cr> to go to error)\r-----"
    foreach err $reply {
	eval browse::Add [lrange $err 0 2]
    }
    browse::Complete
    browse::Down
}


# Tell think that the file has been modified, and when (now).
# 'pModified'.
proc modified {args} {

#     how to do this?
# typedef struct  {
# 	FSSpec 	fss;	//	the file spec
# 	long	when;	//	the modified time
# 	short	saved;	//	is the file being saved?  0 == no.
# } modT
    
# 	mod.fss = win->spec;
# 	mod.when = win->modified;
# 	mod.saved = TRUE;
    

#     tclAE::send 'KAHL' "KAHL" "MOD " ---- list
}

proc think::AEInit {} {
    global THINK
    
    if {[catch {tclAE::send $THINK "KAHL" "UI  "}]} {
	message "Someting wrong! Are you sure to have THINK Project Manager"
	beep
    }
}

think::AEInit

## 
 # -------------------------------------------------------------------------
 # 
 # "think::handleOpenProject" --
 # 
 #  THINK sends the OpenProject event to notify the editor that a
 #  project has just been opened and/or closed.  (The direct
 #  parameter gives the details.)
 # 
 #  If a project was closed, the user should be asked what to do with
 #  any open sourcefiles that are related to the project: save and
 #  close, discard changes and close, or leave them open.  If some of
 #  the project's sourcefiles were indeed open, the user should also
 #  be advised to perform a Use Disk the next time he opens the
 #  project.
 # 
 #  If a project was opened, and the editor already has one of the
 #  project's sourcefiles open, it may need to read in the file's
 #  marker data now.  If so, and the file has already been modified,
 #  the marker data will be out of sync; the best we can do is revert
 #  to the previous saved version.
 # -------------------------------------------------------------------------
 ##
proc think::handleOpenProject {theAESubDesc theReplyAE} {
    set code [tclAE::subdesc::getKeyData $theAESubDesc ----]
    
    if (code) {
        switchTo 'ALFA'
    }
    
    if (expr {code & 0x0002}) {
        # a project was closed
    }
    
    if (expr {code & 0x0001}) {
        # a project was opened
    }
    
    # The C code apparently once closed all open windows. Why?
}



## 
 # -------------------------------------------------------------------------
 # 
 # "think::handleCloseProject" --
 # 
 #  THINK sends the CloseProject event to notify the editor that the
 #  current project is being closed.  The keyDirectObject parameter
 #  indicates whether the related sourcefiles should be saved and
 #  closed (kAEYes) or closed but not saved (kAENo).  If the direct
 #  object is kAEAsk, the user should be asked what to do with any
 #  open sourcefiles (an option should be provided to cancel the
 #  project close, also.)
 # -------------------------------------------------------------------------
 ##
proc think::handleCloseProject {theAESubDesc theReplyAE} {
    global THINK
    
    tclAE::send $THINK "KAHL" "CPRJ"
}

## 
 # -------------------------------------------------------------------------
 # 
 # "think::handleFailedFINF" --
 # 
 #  THINK sends the Failed Find In Next File event to tell the editor that 
 #  its last FINF or Goto request has failed.
 # -------------------------------------------------------------------------
 ##
proc think::handleFailedFINF {theAESubDesc theReplyAE} {
    alertnote "Unable to find string."
}

proc think::parseCompileErrors {theErrorListDesc} {
# typedef struct {
# 	short	errorCode;
# 	short 	line;
# 	FSSpec	fsSpec;
# 	char	errorStr[256];
# } compErrData  
    
    # extract {error.errorStr error.errorStr error.line}
    # handleThinkReply list
}



# 	HandleMarkerUpdate
# 	
# 	THINK sends the MarkerUpdate event when it needs the editor to ensure that the 
# 	debugger state information is up-to-date.  We need to return the marker information
# 	for EACH open file.


# 	HandleMakeLineOffsets
# 	
# 	THINK sends the MakeLineOffsets event when it needs the editor to create a new
# 	lineOffsets array for EACH open file.



# 	HandleGetDebugState
# 	
# 	THINK sends the GetDebugState event when it needs to get the current Debugger state
# 	info for the file (when debugging).  



# 	HandlePutDebugState
# 	
# 	THINK sends the PutDebugState event when it needs to replace the Debugger state
# 	info for the file (when the THINK Debugger saves its current state).  To respond
# 	to this event, the editor returns pointers to its Debugger state info Handles 
# 	(among other things) in the fssPlus struct (see below).



# 	HandleModified
# 	
# 	THINK sends the Modified event when it needs to know which files have been modified
# 	and when they've been modified.  Send back a list of fssMod structs in the reply
# 	event, as follows:

# 	struct {
# 		FSSpec 	fss;	//	the file spec
# 		long	when;	//	the time the file was last modified
# 		short	saved;	//	is the file being saved now (set to zero in this handler)
# 	} fssMod;


proc think::handleModified {theAESubDesc theReplyAE} {
    message "Think Modified event was never implemented"
}



# 	HandleGetText
# 	
# 	THINK sends the GetText event when it needs to get a current copy of the file
# 	(for compilation or debugging.)	

# 	typedef struct {
# 		int			fontNum;		/*  resource ID of font  */
# 		int			fontSize;		/*  point size of font  */
# 		int			spaceWidth;		/*  # pixels per space  */
# 		int			tabStops;		/*  # spaces per tab  */
# 	} FTRec;

# 	struct {
# 		FSSpec fss;		//	the file THINK is looking for
# 		Handle textH;	//	where to return the file's text
# 		FTRec *ftp;		//	where to return the font/tabs info (ftp == 0 if compiling)
# 		long *modified;	//	where to return the time-modified of the file
# 	} fssPlus;

proc think::handleGetText {theAESubDesc theReplyAE} {
    message "Tell somebody to figure out how to handle Think Get Text"
}



# 	HandleWindowSearch
# 	
# 	THINK sends the WindowSearch event whenever it needs to know whether the editor
# 	has a specific file open for editing.  If the file is open, send back the file's
# 	modified time;  otherwise, return fnfErr (file not found).

# 	struct {
# 		FSSpec fss;
# 		long *modified;
# 	} fssPlus;


proc think::handleWindowSearch {theAESubDesc theReplyAE} {
    message "Tell somebody to figure out how to handle Think Window Search"
}


