#================================================================================
# THINK Ref
#================================================================================

alpha::menu thinkRefMenu 1.0.1 "C C++ Java Pasc" "265" {
} thinkRefMenu {} help {
    This menu provides access to the Think Reference application.
}

proc thinkRefMenu {} {}

Menu -n $thinkRefMenu {
	"gotoReference"
	"(-"
	"displayTrapTemplate"
	"insertTrapTemplate"
	"/L<O<UlookupTrap"
}



set lastTrap {}

proc insertTrapTemplate {} {
    global lastTrap
    
    app::launchFore DanR
    set text [getSelect]
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    } else {
	deleteText [getPos] [selEnd]
    }
    set lastTrap $text
    set res [AEBuild -r {'DanR'} DanR {TMPL} "----" "$text"]
    regexp {.*} $res one
    insertText [string trim $one {}]
}

proc displayTrapTemplate {} {
    global lastTrap
    
    app::launchFore DanR
    set text {}
    catch {set text [getSelect]}
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    }
    set lastTrap $text
    
    set res [AEBuild -r {'DanR'} DanR {TMPL} "----" "$text"]
    regexp {.*} $res one
    alertnote [string trim $one {}]
}

proc lookupTrap {} {
    global lastTrap
    
    app::launchFore DanR
    set text {}
    catch {set text [getSelect]}
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    }
    set lastTrap $text
    set num 0
    AEBuild {'DanR'} DanR {REF } "----" "$text"
}

proc gotoReference {} {
    app::launchFore DanR
}


