#================================================================================
# QuickView Toolbox Assistant Help
#================================================================================

alpha::menu toolboxRefMenu 1.0.3 "C C++" "400" {
    newPref sig toolboxRefSig ALTV
} {
    toolboxRefMenu
} {} uninstall {this-file} help {
    This menu provides access to the QuickView
    Toolbox Assistant.
}

proc toolboxRefMenu {} {}

namespace eval toolboxref {}

proc toolboxref::menuProc {menu item} {
    menu::generalProc toolboxref $item
}

Menu -n $toolboxRefMenu -p toolboxref::menuProc {
    gotoReference
    "(-"
    displayTrapTemplate
    insertTrapTemplate
    "/L<O<UlookupTrap"
}

set lastTrap {}

proc toolboxref::insertTrapTemplate {} {
    global lastTrap toolboxRefSig
    
    app::ensureRunning $toolboxRefSig
    set text [getSelect]
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    } else {
	deleteText [getPos] [selEnd]
    }
    set lastTrap $text
    set res [AEBuild -r '$toolboxRefSig' DanR {TMPL} "----" "$text"]
    regexp {.*} $res one
    insertText [string trim $one {}]
}

proc toolboxref::displayTrapTemplate {} {
    global lastTrap toolboxRefSig

    app::ensureRunning $toolboxRefSig
    set text {}
    catch {set text [getSelect]}
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    }
    set lastTrap $text
    
    set res [AEBuild -r '$toolboxRefSig' DanR {TMPL} "----" "$text"]
    regexp {.*} $res one
    alertnote [string trim $one {}]
}

proc toolboxref::lookupTrap {} {
    global lastTrap toolboxRefSig

    app::ensureRunning $toolboxRefSig
    set text {}
    catch {set text [getSelect]}
    if {![string length $text]} {
	if {[catch {prompt "Trap name:" $lastTrap} text]} return
    }
    set lastTrap $text
    AEBuild '$toolboxRefSig' DanR {REF } "----" "$text"
}

proc toolboxref::gotoReference {} {
    global toolboxRefSig
    switchTo [app::ensureRunning $toolboxRefSig]
}


