
alpha::mode Ada 1.0.3 dummyAda {*.ada *.ads *.adb *.ADS *.ADB *_.a *.a } {
    electricBraces electricSemicolon electricTab
} {} help {
    The programming language Ada is named after Lady Ada Lovelace,
    daughter of famed poet Lord Byron and assistant to mathematician
    Charles Babbage, who invented the Analytical Machine.  Lady Ada is
    often considered to be the world's first programmer.

    A descendent of Pascal, Ada is object-oriented, and offers
    interfaces to the languages C, FORTRAN and COBOL. For more
    information about Ada, see <http://www.adahome.com>.

    Ada Mode provides keyword coloring and procedure marking with the
    Marks Menu.  Alpha includes an "Ada Example.ada" syntax file that
    demonstrates the mode.  In Alpha's Ada mode, The key-binding F9
    will switch between the Ada spec & body, assuming they're in the
    same directory and use either GNAT or VAX Ada naming conventions.
    Other conventions can be supported fairly easily.
}

#===============================================================================
# From Raymond Waldrop <rwaldrop@cs.tamu.edu>
#===============================================================================

newPref v leftFillColumn {3} Ada
newPref v prefixString {-- } Ada 
newPref v wordBreak {[a-zA-Z0-9_]+} Ada
newPref f wordWrap {0} Ada
newPref v funcExpr {^[ \t]*(procedure|function)[ \t]+([A-Za-z][A-Za-z0-9_]*)} Ada
newPref v parseExpr {^[ \t]*[^ \t]+[ \t]+([A-Za-z][A-Za-z0-9_]*)} Ada
newPref v wordBreakPreface {[^a-zA-Z0-9_]} Ada

# Don't get used!
#set adaCommentRegexp	{/\*(([^*]/)|[^*]|\r)*\*/}
#set adaPreRegexp		{^\#[\t ]*[a-z]*}
set adaKeyWords		{
    abort abs accept access all and array at begin body case constant
    declare delay delta digits do else elsif end entry exception exit
    for function generic goto others if in is limited loop mod new not
    null of or subtype out package pragma private procedure raise range
    record rem renames return reverse select separate task terminate
    then type use when while with xor = /=  := > < abstract aliased 
    protected requeue tagged until
}
regModeKeywords -e {--} -c red -k blue  \
  -i ")" -i "(" -i ":" -i ";" -i "," -i "." \
  -I green Ada $adaKeyWords
unset adaKeyWords

proc dummyAda {} {}

#===============================================================================
# From Tom Konantz
#===============================================================================

Bind f9 Ada::otherPart Ada

proc Ada::MarkFile {} {
    global AdamodeVars
    set pos [minPos]
    
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $AdamodeVars(funcExpr) $pos} res]} {
	set start [lindex $res 0]
	set end [pos::math [lindex $res 1] + 1]
	set text [getText $start $end]
	
	if {[regexp -nocase -indices {(procedure|function)[ \t]+([a-zA-Z0-9_]+)} $text dummy dummy0 pname]} {
	    set	i1 [expr [lindex $pname	0] + $start]
	    set	i2 [expr [lindex $pname 1] + $start + 1]
	    set	word [getText $i1 $i2]
	    set	tmp [concat $i1 $i2]
	    
	    if {[info exists cnts($word)]} {
		# This section handles duplicate. i.e., overloaded names
		set cnts($word) [expr $cnts($word) + 1]
		set ol_word [ join [concat $word "#" $cnts($word)] ""]
		set inds($ol_word) $tmp
	    } else {
		set cnts($word) 1
		set inds($word) $tmp
	    }
	}
	
	
	set pos $end
    }
    if {[info exists inds]} {
	foreach f [lsort -ignore [array names inds]] {
	    set res $inds($f)
	    setNamedMark $f [lineStart [lindex $res 0]] [lindex $res 0] [lindex $res 1]
	}
    }
}

# the following will switch between the Ada spec & body,
# assuming they're in the same directory
# and use either GNAT or VAX Ada naming conventions.
# other conventions can be supported fairly easily.
proc Ada::otherPart {} {
    set curname [win::Current]
    if {[regsub  "(.*)\.ads" $curname {\1.adb} tgtname]}  {
	file::openQuietly $tgtname
    } elseif  {[regsub  "(.*)\.adb" $curname {\1.ads} tgtname]}  {
	file::openQuietly $tgtname
	# Next clause must precede the one after it!
    } elseif  {[regsub  {(.*)_\.a$} $curname {\1.a} tgtname]}  {
	file::openQuietly $tgtname
    } elseif  {[regsub  {(.*)\.a$} $curname {\1_.a} tgtname]}  {
	file::openQuietly $tgtname
    } else {
	error "NoMatch"
    }
}


