## -*-Tcl-*- (install) (nowrap)
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "cMode.tcl"
 #					created: 01-03-09 13.58.49	
 #				 last update: 2001-11-24 19:47:27	
 #	Author:	Vince Darley
 #	E-mail:	<vince@santafe.edu>
 #	  mail:	317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #	   www:	<http://www.santafe.edu/~vince/>
 #	
 # 
 #  modified   by  rev reason
 #  ---------- --- --- -----------
 #  2000-12-07 DWH 1.0 added help text
 #  2001-11-22 BD  1.4 added ObjC support <bdesgraupes@easyconnect.fr>
 # ###################################################################
 ##

alpha::mode C 1.4.0 dummyC {*.c *.C *.r } \
  {electricTab electricReturn electricBraces electricSemicolon} {} help {
    C and C++ modes function nearly indentically in Alpha.  C Mode
    provides keyword coloring and procedure marking with the Marks Menu;
    supports cmd-dbl-click for opening files or (sends the word to app
    sig "DanR"); automatically handles indentation and formatting. 
    Support for Think and CodeWarrior.  

    Click on this "C++ Example.c" link for an example syntax file.
}

alpha::mode C++ 1.4.0 dummyC++ \
  {*.H *.h *.cc *.cp *.cpp *.CPP *.pch *.pch++ *.icc *.exp *.c++} \
  {electricTab  electricReturn electricBraces electricSemicolon} {} help {
    C and C++ modes function nearly indentically in Alpha.  C Mode
    provides keyword coloring and procedure marking with the Marks Menu;
    supports cmd-dbl-click for opening files or (sends the word to app
    sig "DanR"); automatically handles indentation and formatting. 
    Support for Think and CodeWarrior.  

    Click on this "C++ Example.c" link for an example syntax file.
}

alpha::mode Objc 1.4.0 dummyObjc {*.m *.i} \
  {electricTab  electricReturn electricBraces electricSemicolon} {} help {
    This mode implements specific support for Objective C. Many features
    are identical to C mode. The mode adds coloring for the ObjC specific
    keywords, special file marking for @interface, @implementation and
    @protocol declarations.

    See ObjCMarkTester.h and ObjCMarkTester.m in the Tests folder for examples.
}

# # Not really required any more.
# # The CW menu registers a proc to call cw IDE.
# hook::register saveHook modified "C" "C++"

# Dummy procs
proc dummyC {} {}
proc dummyC++ {} {}
proc dummyObjc {} {}


# Preferences
# ===========

# C Preferences
# -------------
newPref v leftFillColumn {3} C
newPref v prefixString {// } C
newPref f elecElse {1} C
newPref f wordWrap {0} C
newPref v funcExpr {^[^ \t\(#\r/@].*\(.*\)$} C
if {[info tclversion] < 8.0} {
    newPref v parseExpr {\b(([_\w]+::~?)*[_\w]+)\s*\(} C
} else {
    newPref v parseExpr {\m(([_\w]+::~?)*[_\w]+)\s*\(} C
}
newPref v wordBreak {[_\w]+} C
newPref v wordBreakPreface {[^_\w]} C
newPref f autoMark 0 C
newPref color stringColor green C
newPref color commentColor red C
newPref color funcColor magenta C
newPref color keywordColor blue C
newPref f includeMenu {1} C
newPref f launchIDEifRequired {1} C
newPref v sourceSuffices { .c .C } C
newPref v headerSuffices { .h .H } C
newPref v indentComments "code 0" C "" indentationTypes varitem
newPref v indentMacros "fixed 0" C "" indentationTypes varitem
newPref v IDE 0 C "" [list "CodeWarrior" "Symantec" "none"] index
newPref f useFasterButWorseIndentation 0 C

# C++ Preferences
# ---------------
newPref v leftFillColumn {3} C++
newPref v prefixString {// } C++
newPref v wordBreak {[\w_]+} C++
newPref v wordBreakPreface {[^_\w]} C++
newPref f elecElse {1} C++
newPref f wordWrap {0} C++
newPref v funcExpr {^([^ \t\(#[\r\n]/@].*[ \t]+)?\*?([A-Za-z0-9~_]+(<[^>]*>)?::[-A-Za-z0-9~_+= <>\|\*/]+|[A-Za-z0-9~_]+)[ \t\r\n]*\(} C++
if {[info tclversion] < 8.0} {
    newPref v parseExpr {\b(([_\w]+::~?)*[_\w]+)\s*\(} C++
} else {
    newPref v parseExpr {\m(([_\w]+::~?)*[_\w]+)\s*\(} C++
}
newPref f autoMark 0 C++
newPref color stringColor green C++
newPref color commentColor red C++
newPref color keywordColor blue C++
newPref color funcColor yellow C++
newPref f includeMenu {1} C++
newPref f launchIDEifRequired {1} C++
newPref v sourceSuffices {.cc .cp .cpp .CC .CP .CPP .icc } C++
newPref v headerSuffices { .h .hh .H .HH} C++
# These three are pairs:
newPref v indentComments "code 0" C++ "" indentationTypes varitem
newPref v indentC++Comments "code 0" C++ "" indentationTypes varitem
newPref v indentMacros "fixed 0" C++ "" indentationTypes varitem
newPref v IDE 0 C++ "" [list "CodeWarrior" "Symantec" "none"] index
newPref f useFasterButWorseIndentation 0 C++
newPref folder universalHeadersFolder "" C++

# ObjC Preferences
# ----------------
newPref v leftFillColumn {3} Objc
newPref v prefixString {// } Objc
newPref f elecElse {1} Objc
newPref f wordWrap {0} Objc
newPref v funcExpr {^-[ \t]*\([A-Za-z0-9~_]+\)[ \t\n\r]*[A-Za-z0-9]+:?} Objc
if {[info tclversion] < 8.0} {
    newPref v parseExpr {\b(([_\w]+::~?)*[_\w]+)\s*\(} Objc
} else {
    newPref v parseExpr {\m(([_\w]+::~?)*[_\w]+)\s*\(} Objc
}
newPref v wordBreak {[_\w]+} Objc
newPref v wordBreakPreface {[^_\w]} Objc
newPref f autoMark 0 Objc
newPref color stringColor green Objc
newPref color commentColor red Objc
newPref color funcColor magenta Objc
newPref color keywordColor blue Objc
newPref f includeMenu {1} Objc
newPref f launchIDEifRequired {1} Objc
newPref v sourceSuffices { .m .c .C } Objc
newPref v headerSuffices { .i .h .H } Objc
newPref v indentComments "code 0" Objc "" indentationTypes varitem
newPref v indentMacros "fixed 0" Objc "" indentationTypes varitem
newPref v IDE 0 Objc "" [list "CodeWarrior" "Symantec" "none"] index
newPref f useFasterButWorseIndentation 0 Objc


# Initialization of variables
# ===========================
# C mode initialisations:
set C::escapeChar "\\"
set C::quotedstringChar "\""
set C::lineContinuationChar "\\"

set C::commentCharacters(General) "//" ;# accepted by most compilers nowadays...
set C::commentCharacters(Paragraph) [list "/* " " */" " * "]
set C::commentCharacters(Box) [list "/*" 2 "*/" 2 "*" 3]

# C++ mode initialisations:
set C++::escapeChar "\\"
set C++::quotedstringChar "\""
set C++::lineContinuationChar "\\"

set C++::commentCharacters(General) "//" ;# no asterisk!
set C++::commentCharacters(Paragraph) [list "/* " " */" " * "]
set C++::commentCharacters(Box) [list "/*" 2 "*/" 2 "*" 3]

# ObjC mode initialisations:
set Objc::escapeChar "\\"
set Objc::quotedstringChar "\""
set Objc::lineContinuationChar "\\"

set Objc::commentCharacters(General) "//"
set Objc::commentCharacters(Paragraph) [list "/* " " */" " * "]
set Objc::commentCharacters(Box) [list "/*" 2 "*/" 2 "*" 3]


# Syntax Coloring
# ===============
# C mode
# ------
set cKeyWords {
    void break register short enum extern int for if while struct static 
    long continue switch case char unsigned double float return else 
    default goto do pascal Boolean typedef volatile union auto sizeof 
    size_t
}

if {[info exists Cwords]} {set cKeyWords [concat $cKeyWords $Cwords]}

regModeKeywords -e {//} -b {/*} {*/} -c $CmodeVars(commentColor) \
  -f $CmodeVars(funcColor) -k $CmodeVars(keywordColor) \
  -s $CmodeVars(stringColor) -m {#} C $cKeyWords

# C++ mode
# --------
set {c++KeyWords} {
    new delete explicit class friend protected private public template try 
    catch throw operator const mutable virtual asm inline this and and_eq 
    bitand bitor compl not or or_eq xor xor_eq not_eq wchar_t bool true 
    false bool inline mutable static_cast dynamic_cast reinterpret_cast 
    typeid using namespace inherited
}

if {[info exists {C++words}]} {
    set {c++KeyWords} [concat ${c++KeyWords} ${C++words} $cKeyWords]
} else {
    set {c++KeyWords} [concat ${c++KeyWords} $cKeyWords]
}

regModeKeywords -e {//} -b {/*} {*/} -c [set C++modeVars(commentColor)] \
  -f [set C++modeVars(funcColor)] -k [set C++modeVars(keywordColor)] \
  -s [set C++modeVars(stringColor)] -m {#} {C++} ${c++KeyWords}

# ObjC mode
# ---------
set objcKeyWords {
@class @defs @encode @end @implementation @interface @private @protected @protocol @public 
@selector ARITH_SHIFT BOOL bycopy byref CACHE_BUCKET_IMP CACHE_BUCKET_NAME CACHE_BUCKET_VALID class
CLS_CLASS CLS_FLUSH_CACHE CLS_GETINFO CLS_GROW_CACHE CLS_INITIALIZED CLS_JAVA_CLASS CLS_JAVA_HYBRID
CLS_MAPPED CLS_META CLS_METHOD_ARRAY CLS_NEED_BIND CLS_POSING CLS_SETINFO defs encode end
id IMP implementation in inout interface ISSELECTOR IV marg_adjustedOffset marg_free marg_getRef
marg_getValue marg_malloc marg_prearg_size marg_setValue NAMEOF Nil nil NO objc_cache objc_category
objc_class OBJC_EXPORT OBJC_IMPORT objc_ivar_list objc_method_list objc_module OBJC_NEXT_METHOD_LIST
objc_protocol_list objc_super objc_symtab oneway out SEL selector self SELNAME SELUID super YES 
}

if {[info exists {Objcwords}]} {
    set {objcKeyWords} [concat $objcKeyWords $Objcwords $cKeyWords]
} else {
    set {objcKeyWords} [concat $objcKeyWords $cKeyWords]
}

regModeKeywords -e {//} -b {/*} {*/} -c $ObjcmodeVars(commentColor) \
  -f $ObjcmodeVars(funcColor) -k $ObjcmodeVars(keywordColor) \
  -s $ObjcmodeVars(stringColor) -m {#} Objc $objcKeyWords


unset cKeyWords
unset {c++KeyWords}
unset objcKeyWords


#================================================================================

proc C++::openUniversalHeader {} {
    global universalHeadersFolder tabSize
    if {![file exists $universalHeadersFolder]} {
	alertnote "Please set your 'Universal Headers Folder' preference first.\
	  It's set to '$universalHeadersFolder' which doesn't exist."
	return
    }
    set filename [prompt::statusLineComplete "Open which header" \
      [list file::completeFromDir $universalHeadersFolder] -nocache \
      -tryuppercase]
    set old $tabSize
    set tabSize 4
    file::openQuietly [file join $universalHeadersFolder $filename]
    set tabSize $old
}

Bind 'q' <o> C++::openUniversalHeader C++


proc C++::DblClick {from to shift option control} {	
    if {[regexp {#include.*("|<)(.*)("|>)} [getText \
      [lineStart [getPos]] [nextLineStart [getPos]]] "" "" inc]} {
	return [file::tryToOpen $inc]
    }
    
    select $from $to
    set text [getSelect]
    
    global tagFile
    set lines [grep "^$text'" $tagFile]
    if {[regexp {'(.*)'(.*[^\t])(\t)+} $lines "" one two]} {
	file::openQuietly $one
	set inds [search -s -f 1 -r 0 "$two" [minPos]]
	display [lindex $inds 0]
	eval select $inds
    } else {
	app::launchFore DanR
	AEBuild {'DanR'} DanR {REF } "----" "$text"
    }
}

# for C mode
proc C::DblClick {args} { eval C++::DblClick $args }

# for Objc mode
proc Objc::DblClick {args} { eval C++::DblClick $args }



#############################################################################
#									    #
# Stuff above this point has only minor modifications from the original	    #
# "cMode.tcl", stuff below is largely or totally new.			    #
#									    #
#############################################################################

#  File marking  #

## 
 # -------------------------------------------------------------------------
 #	 
 # "C++::MarkFile" --
 #	
 #	Improved version which handles templates, operators	etc.
 #	Makes use of the new mark menu in Alpha	6.5 which can handle
 #	more weird characters.  Handles most 'operator =+-*...' functions
 #  for C++
 #  
 #  Better marking of templates recently added.
 # Last modification : 2001-06-08 08:50:52
 # Author : Bernard Desgraupes <berdesg@easynet.fr>
 # -------------------------------------------------------------------------
 ##

proc C++::MarkFile {} {
    global C++modeVars
    set ext [file extension [win::Current]]
    if {$ext == ".exp"} { return }
    # Do we have a header file (1) or a source file (0) :
    set isHeader [expr {[lsearch -exact [set C++modeVars(headerSuffices)] $ext]==-1 ? 0 : 1}]
    if {$isHeader} {
	# Marking various types of declarations
	foreach type [list class struct union template typedef operator] {
	    C++::otherMarks $type
	} 
    }
    C++::doFuncsMarking $isHeader
}

proc C::MarkFile {} {
    global CmodeVars
    set ext [file extension [win::Current]]
    if {$ext == ".r"} {
	C::MarkRezFile
	return 
    }    
    # This is just in case a user has set C mode manually in a header file
    # (otherwise a file with extension .h is opened in C++ mode by default):
    set isHeader [expr {[lsearch -exact [set CmodeVars(headerSuffices)] $ext]==-1 ? 0 : 1}]
    if {$isHeader} {
	# Marking various types of declarations
	foreach type [list struct union typedef] {
	    C++::otherMarks $type
	} 
    }
    C::doFuncsMarking $isHeader
}

proc C++::doFuncsMarking {isHeader} {
    set pos [minPos]
    set markExpr "^(\[A-Za-z0-9~_\]+\[ \t\n\r\]*\\(|(\[^ \t\(#\n\r/@:\*\]\[^=\(\r\n\]*\[ \t\]+\\*?)?"
    set subMarkExpr "(\[A-Za-z0-9~_\]+(<\[^>\]*>)?(::)?\[-A-Za-z0-9~_+ <>\|\\*/\]+|\[A-Za-z0-9~_\]+)"
    append markExpr $subMarkExpr
    append markExpr "\[ \n\t\r\]*\\()"
    append subMarkExpr "\[ \t\]*\\("
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markExpr" $pos} res]} {
	set pos [lindex $res 1]
	# The regexp above also catches some typedefs and operator declarations. 
	# Let's get ridd of them here (they are handled separately).
	if {[regexp "^typedef" [getText [lindex $res 0] $pos]]} {continue} 
	if {[regexp "operator" [getText [lindex $res 0] $pos]]} {continue} 
	# If we have a source file, we don't want to mark prototypes :
	if {!$isHeader} {
	    # If there is semi-colon after the matching closing parenthese (and possibly
	    # spaces inbetween), we have a prototype. 'catch' this in case 'matchIt' fails.
	    if {![catch {set loco [pos::math [matchIt "\(" [lindex $res 1]] +1]}]} {
		while {[is::Whitespace [lookAt $loco]]} {
		    set loco [pos::math $loco +1]
		}
		if {[lookAt $loco]==";"} {
		    continue
		}
	    }
	} 
	# Looking back for the identifier
	if {[catch {search -s -f 0 -r 1 -m 0 -l [lindex $res 0] -i 0 \
	  {[ \t*][a-zA-Z]} [set pos [pos::math [lindex $res 1] -1]]} start]} {
	    set start [lindex $res 0]
	    if {[regexp "^\[A-Za-z0-9:~_\]+\[ \t\r\n\]*\\(" \
	      [getText $start [nextLineStart $start]] thistext]} {
		# nothing
	    } else {
		# Found no valid name. Skip the end of the while loop.
		continue
	    }
	} else {
	    set start [lindex $start 0]
	    set thistext [getText $start [lindex $res 1]]
	}
	# If the open paren was the last character on the line, the selected text included the last 
	# carriage return as well. Trim this off now that it is changed into a space.
	regsub -all "\[\r\n\t\]" [string trimright $thistext] " " thistext
	if {[regexp -- $subMarkExpr $thistext dummy word]} {
	    # Take care of constructors, destructors and other methods.
	    if {[string first "::" $word] != -1} {
		regsub {(<\w+>)?::} $word " " item
		set l [lindex $item 0]
		if {$l == [lindex $item 1]} {
		    # We have a constructor. If there are several, they are numbered
		    # with #1, #2 etc. In case there is only one, it is not numbered.
		    if {[info exists cnts($l)]} {
			set cnts($l) [expr $cnts($l) + 1]
			set word " Constructor '$l' #$cnts($l)"
			if {$cnts($l)==2} {
			    set word0 " Constructor '$l'"
			    set word1 " Constructor '$l' #1"
			    set inds($word1) $inds($word0)
			    unset inds($word0)
			} 
		    } else {
			set cnts($l) 1
			set word " Constructor '$l'"
		    }
		} elseif {"~$l" == [lindex $item 1]} {
		    # We have a destructor.
		    set word " Destructor '~$l'"
		} else {
		    # We have an ordinary method. Let's take care of overloaded functions.
		    set l $word
		    if {[info exists cnts($l)]} {
			set cnts($l) [expr $cnts($l) + 1]
			set word "$l #$cnts($l)"
			if {$cnts($l)==2} {
			    set word0 $l
			    set word1 "$l #1"
			    set inds($word1) $inds($word0)
			    unset inds($word0)
			} 
		    } else {
			set cnts($l) 1
			set word $l
		    }
		    
		}
	    }
	    set inds($word) [lineStart [pos::math $start - 1]]
	}
    }
    # Make the marks
    if {[info exists inds]} {
	if {$isHeader} {
	    setNamedMark "PROTOTYPES:" [minPos] [minPos] [minPos]
	} else {
	    setNamedMark "FUNCTIONS:" [minPos] [minPos] [minPos]
	}
	foreach f [lsort -ignore [array names inds]] {
	    set next [lineStart $inds($f)]
	    set qualifier ""
	    set indent "" 
	    if {[string first "::" $f] != -1} {
		set indent "    "
		regexp "(\[A-Za-z0-9~_\]+)::" $f dum nmsp
		if {$nmsp==$qualifier} {
		} else {
		    setNamedMark " Namespace $nmsp" "$inds($f)" $next $next
		    set qualifier $nmsp
		}
		regsub "\[A-Za-z0-9~_\]+" $f "" item
	    } else {
		set item $f
	    }
	    regsub "_ANSI_ARGS_" $item "" item
	    if {[string length $item] > 57} { set item "[string range $item 0 53]..." }
	    setNamedMark "$indent$item" "$inds($f)" $next $next
	}
    }
}

proc C::doFuncsMarking {isHeader} {
    set pos [minPos]
    set markExpr "^(\[A-Za-z0-9~_\]+\[ \t\n\r\]*\\(|(\[^ \t\(#\n\r/@\*\]\[^=\r\n\]*\[ \t\]+\\*?)?"
    set subMarkExpr "(\[A-Za-z0-9~_\]+\[-A-Za-z0-9~_+ <>\|\\*/\]+|\[A-Za-z0-9~_\]+)"
    append markExpr $subMarkExpr
    append markExpr "\[ \n\t\r\]*\\()"
    append subMarkExpr "\[ \t\]*\\("
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markExpr" $pos} res]} {
	set pos [lindex $res 1]
	# We do not want to mark typedefs :
	if {[regexp "^typedef" [getText [lindex $res 0] $pos]]} {continue} 
	# if we have a source file, we don't want to mark prototypes :
	if {!$isHeader} {
	    # If there is semi-colon after the matching closing parenthese (and possibly
	    # spaces inbetween), we have a prototype. 'catch' this in case 'matchIt' fails.
	    if {![catch {set loco [pos::math [matchIt "\(" [lindex $res 1]] +1]}]} {
		while {[is::Whitespace [lookAt $loco]]} {
		    set loco [pos::math $loco +1]
		}
		if {[lookAt $loco]==";"} {
		    continue
		}
	    }
	} 
	# Looking back for the identifier
	if {[catch {search -s -f 0 -r 1 -m 0 -l [lindex $res 0] -i 0 \
	  {[ \t*][a-zA-Z]} [set pos [pos::math [lindex $res 1] -1]]} start]} {
	    set start [lindex $res 0]
	    if {[regexp "^\[A-Za-z0-9:~_\]+\[ \t\r\n\]*\\(" \
	      [getText $start [nextLineStart $start]] thistext]} {
	    } else {
		continue
	    }
	} else {
	    set start [lindex $start 0]
	    set thistext [getText $start [lindex $res 1]]
	}
	# Trim carriage return off now that it is changed into a space.
	regsub -all "\[\r\n\t\]" [string trimright $thistext] " " thistext
	if {[regexp -- $subMarkExpr $thistext dummy word]} {
	    set inds($word) [lineStart [pos::math $start - 1]]
	}
    }
    if {[info exists inds]} {
	if {$isHeader} {
	    setNamedMark "PROTOTYPES:" [minPos] [minPos] [minPos]
	} else {
	    setNamedMark "FUNCTIONS:" [minPos] [minPos] [minPos]
	}
	foreach f [lsort -ignore [array names inds]] {
	    set next [lineStart $inds($f)]
	    regsub "_ANSI_ARGS_" $f "" item
	    if {[string length $item] > 57} { set item "[string range $item 0 53]..." }
	    setNamedMark "  $item" "$inds($f)" $next $next
	}
    }
}

proc C++::otherMarks {type} {
    set pos [minPos]
    switch $type {
	"class" {
	    set markExpr "^($type\[ \t\n\r\]*\[A-Za-z0-9~_\]+"
	    append markExpr "\[ \t\n\r\]*(\[A-Za-z0-9~_<>\]+)?\[ \t\n\r\]*"
	    append markExpr "(:\[^\{\]*)?\{)"
	    set subMarkExpr "$type +(\[A-Za-z0-9~_\]+)"
	}
	"struct" - "union" {
	    set markExpr1 "typedef +$type\[ \t\]*\{\[^\}\]*\}\[ \t\]*\[A-Za-z0-9~_\]+;"
	    set markExpr2 "($type\[ \t\n\r\]*\[A-Za-z0-9~_\]+"
	    append markExpr2 "\[ \t\n\r\]*(\[A-Za-z0-9~_<>\]+)?\[ \t\n\r\]*\{)"
	    set markExpr "($markExpr1|$markExpr2)"
	    set subMarkExpr "(\[A-Za-z0-9~_\]+) *(;|\{)$"
	}
	"template" {
	    set markExpr "^($type\[ \t\n\r\]*<\[^>\]*>"
	    append markExpr "\[ \t\n\r\]*\[A-Za-z0-9~_\]+\[ \t\n\r\]+\[A-Za-z0-9~_\]+\[ \t\n\r\]*\{)"
	    set subMarkExpr "(\[A-Za-z0-9~_\]+) *\{"
	}
	"typedef" {
	    set markExpr "$type\[^;\{\]*;"
	    set subMarkExpr "(\[A-Za-z0-9~_\]+) *;$"
	}
	"define" {
	    set markExpr "\#$type\[ \t\]+(\[^ \(\n\r]*)\[^\r\n\]*$"
	    set subMarkExpr $markExpr
	}
	"operator" {
	    set markExpr "$type\[ \t\]*(\[^ \t\n\r]*)\[ \t\]*\\("
	    set subMarkExpr $markExpr
	}
    }      
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markExpr" $pos} res]} {
	set pos [lindex $res 1]
	set start [lindex $res 0]
	set thistext [getText $start $pos]
	regsub -all "\[\r\n\t\]" [string trimright $thistext] " " thistext
	if {[regexp $subMarkExpr $thistext dummy word]} {
	    if {$type!="typedef" || [lsearch -exact [getNamedMarks -n] "  $word"]=="-1"} {
		set inds($word) $start
	    } 
	}
    }
    if {[info exists inds]} {
	setNamedMark "[string toupper $type]:" [minPos] [minPos] [minPos]
	foreach f [lsort -ignore [array names inds]] {
	    set next [lineStart $inds($f)]
	    set item $f
	    if {[string length $item] > 57} { set item "[string range $item 0 53]..." }
	    setNamedMark "  ${item}" "$inds($f)" $next $next
	}
	# This is a trick to have a separator line after _each_ category (only the dash is
	# marked, not $type; thus we have different marks producing a separator line) :
	setNamedMark "-$type" [minPos] [minPos] [minPos]
    }
}

proc C::MarkRezFile {} {
    # Mark 'type' statements
    set markExpr "^\[ \t\]*type\[ \t\]+'(\[a-zA-Z0-9 _\#\*\]+)'\[ \t\r\n\]+(\\\{|as)"
    set end [maxPos]
    set pos [minPos]
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $markExpr $pos} res]} {
	set start [lindex $res 0]
	set end [lindex $res 1]
	set txt [getText  $start $end]
	regexp $markExpr $txt "" rezname
	set pos [nextLineStart $start]
	set inds($rezname) [lineStart [pos::math $start - 1]]
    }
    if {[info exists inds]} {
	setNamedMark "TYPE:" [minPos] [minPos] [minPos]
	foreach f [lsort -ignore [array names inds]] {
	    set next [nextLineStart $inds($f)]
	    setNamedMark "  $f" $inds($f) $next $next
	}
	setNamedMark "-type" [minPos] [minPos] [minPos]
	unset inds
    }
    # Mark 'resource' and 'data' statements
    set markExpr "^\[ \t\]*(resource|data)\[ \t\]+'(\[a-zA-Z0-9 _\#\*\]+)'"
    append markExpr "\[ \t\r\n\]+\\\( *(\[-a-zA-Z0-9 _\#\*\]+)"
    set end [maxPos]
    set pos [minPos]
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $markExpr $pos} res]} {
	set start [lindex $res 0]
	set end [lindex $res 1]
	set txt [getText  $start $end]
	regexp $markExpr $txt "" type rezname reznum
	set pos [nextLineStart $start]
	set inds(${rezname}$reznum) [lineStart [pos::math $start - 1]]
    }
    if {[info exists inds]} {
	setNamedMark "RESOURCE/DATA:" [minPos] [minPos] [minPos]
	foreach f [lsort -ignore [array names inds]] {
	    set next [nextLineStart $inds($f)]
	    setNamedMark "  [string range $f 0 3] [string range $f 4 end]" $inds($f) $next $next
	}
	unset inds
    }
}

# ObjectiveC Marking
# ------------------
# In Objc source files :
# 	mark the implementations and their methods. Mark C functions.
# In Objc header files :
# 	mark the interfaces and their methods. Mark the protocols.

proc Objc::MarkFile {} {
    global ObjcmodeVars
    set ext [file extension [win::Current]]
    # Do we have a header file (1) or a source file (0) :
    set isHeader [expr {[lsearch -exact [set ObjcmodeVars(headerSuffices)] $ext]==-1 ? 0 : 1}]
    if {$isHeader} {
	# Marking various types of declarations
	foreach type [list interface protocol] {
	    Objc::doFuncsMarking $type
	} 
	foreach type [list struct union] {
	    C++::otherMarks $type
	} 
    } else {
	Objc::doFuncsMarking implementation
	C::doFuncsMarking 0
    }
}

# class-method-declaration:
#     + [ method-type ] method-selector ;
# instance-method-declaration:
#      [ method-type ] method-selector ;
proc Objc::doFuncsMarking {type} {
    set bega [minPos]
    set markBegExpr "^@$type\[ \t\n\r\]*(\[A-Za-z0-9~_\]+)\[ \t\n\r\]*(\\(\[A-Za-z0-9~_\]+\\))?"
    set markEndExpr "^@end"
    set methodExpr "^(-|\\+)(\[ \t\]*\\(\[A-Za-z0-9~_\\* \]+\\)\[ \t\n\r\]*\[A-Za-z0-9 \]+\[: \]*)+"
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markBegExpr" $bega} resa]} {
	set category ""
	set enda [lindex $resa 1]
	set bega [lindex $resa 0]
	set thistext [getText $bega $enda]
	if {[regexp $markBegExpr $thistext dummy class category]} {
	    if {$category!=""} {
		regsub -all {[()]} $category "" category
	        set class "${class}_$category"
	    } 
	    set inds($class) $bega
	}
	if {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markEndExpr" $enda} resb]} {
	    set begb [lindex $resb 0]
	    set endb [lindex $resb 1]
	    set bega $endb
	    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 -l $begb "$methodExpr" $enda} resc]} {
		set begc [lindex $resc 0]
		set enda [lindex $resc 1]
		set thistext [getText $begc $enda]
		if {[regexp $methodExpr $thistext word prefix dumm]} {
		    regsub -all ":\\(\[^\)\]+\\)\[ \t\n\r\]*\[A-Za-z0-9~_\]+ *" $word ":" word
		    regsub -- "(-|\\+)\[ \t\]*\\(\[^\)\]+\\)" $word "" word
		    set word [string trim $word]
		    eval "set inds$class\($prefix$word\) $begc"
		}
	    }
	} else {
	    alertnote "Runaway declaration: missing @end."
	    return
	}
    }
    if {[info exists inds]} {
	setNamedMark "[string toupper $type]S:" [minPos] [minPos] [minPos]
	foreach cl [lsort -ignore [array names inds]] {
	    set next [lineStart $inds($cl)]
	    if {[regsub -all "_" $cl "  (" itm]} {
	        append itm )
	    } 
	    setNamedMark "$itm" "$inds($cl)" $next $next
	    if {[info exists inds$cl]} {
		foreach m [lsort -ignore [array names inds$cl]] {
		    eval set next [lineStart [set inds$cl\($m\)]]
		    set item $m
		    if {[string length $item] > 57} { set item "[string range $item 0 53]..." }
		    setNamedMark "  $item" [set inds$cl\($m\)] $next $next
		}
	    }
	}
	# This is a trick to have a separator line after _each_ category (only the dash is
	# marked, not $type; thus we have different marks producing a separator line) :
	setNamedMark "-$type" [minPos] [minPos] [minPos]
    }
}


proc C::parseFuncs {} {
    set result ""
    # Marking the #define's
    set definelist [C++::parseSome define]
    # Marking the #include's
    set includelist [C++::parseSome include]
    # Building the result
    if {$definelist!=""} {
	set result $definelist
    }
    if {$includelist!=""} {
	if {$result!=""} {
	    set result [concat $result "\(- 0" $includelist]
	} else {
	    set result $includelist
	}
    }
    return $result
}

proc C++::parseFuncs {} {
    set result [C::parseFuncs]
    # Marking the methods in each class
    set methodlist [C++::parseMethods]
    # Building the result
    if {$methodlist!=""} {
	if {$result!=""} {
	    set result [concat $result "\(- 0" $methodlist]
	} else {
	    set result $methodlist
	}
    }
    return $result
}

proc C++::parseSome {what} {
    set pos [minPos]
    set title [string toupper $what]
    set thesection [list $title $title]
    set thelist ""
    set markExpr "\#$what\[ \t\]+(\[^ \(\t\n\r]*)\[^\r\n\]*$"
    while {[set res [search -s -f 1 -r 1 -i 0 -n $markExpr $pos]] != ""} {
	if {[regexp -- $markExpr [eval getText $res] "" word]} {
	    regsub -all \[<>\"\] $word "" word
	    lappend thelist [list "  $word" [lindex $res 0]]
	}
	set pos [lindex $res 1]
    } 
    if {[llength $thelist]} {
	foreach pair [lsort -ignore [set thelist]] {
	    eval lappend thesection $pair
	}
	return $thesection
    } else {
	return ""
    }
}

proc C++::parseMethods {} {
    set thelist ""
    set pos [minPos]
    # Regexp to find class definitions
    set classExpr "^(class\[ \t\]+\[A-Za-z0-9~_\]+"
    append classExpr "\[ \t\n\r\]*(\[A-Za-z0-9~_<>\]+)?\[ \t\n\r\]*"
    append classExpr "(:\[^\{\]*)?\{)"
    set subClassExpr "class\[ \t\]+(\[A-Za-z0-9~_\]+)"
    # Regexp to find method declarations	
    set methodExpr "^\[ \t\]*(\[A-Za-z0-9~_\]+\[ \t\n\r\]*\\(|(\[^ \t\(#\n\r/@\*\]\[^=\r\n\]*\[ \t\]+\\*?)?"
    append methodExpr "(\[A-Za-z0-9~_\]+\[-A-Za-z0-9~_+ <>\|\\*/\]+|\[A-Za-z0-9~_\]+)"
    append methodExpr "\[ \n\t\r\]*\\()"
    set subMethodExpr "(\[A-Za-z0-9~\&_-\]+)\[ \t\]*\\("
    # Looking for a class definition
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$classExpr" $pos} res]} {
	set pos [lindex $res 1]
	set start [lindex $res 0]
	set thistext [getText $start $pos]
	regexp $subClassExpr $thistext dummy classname
	eval lappend thelist [list "CLASS '$classname'" [lindex $res 0]]
	# Find the closing brace of the class definition
	if {[catch {set closepos [matchIt "\{" [lindex $res 1]]}]} {
	    alertnote "Missing close brace"
	    return ""
	}
	# Inside this class, find the methods
	set currpos $pos
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 -l $closepos "$methodExpr" $currpos} res]} {
	    set currpos [lindex $res 1]
	    set currstart [lindex $res 0]
	    set thistext [getText $currstart $currpos]
	    regsub -all "\[\r\n\t\]" [string trimright $thistext] " " thistext
	    if {[regexp $subMethodExpr $thistext dummy method]} {
		eval lappend thelist [list "  $method" [lindex $res 0]]
	    }
	}
    }
    return $thelist
}

proc Objc::parseFuncs {} {
    set result ""
    # Marking the #define's
    set definelist [C++::parseSome define]
    # Marking the #import's
    set importlist [C++::parseSome import]
    # Building the result
    if {$definelist!=""} {
	set result $definelist
    }
    if {$importlist!=""} {
	if {$result!=""} {
	    set result [concat $result "\(- 0" $importlist]
	} else {
	    set result $importlist
	}
    }
    return $result
}


#  Indentation routines  #

proc C::indentLine {} {C++::indentLine}
proc Objc::indentLine {} {C++::indentLine}

 ## 
  # -------------------------------------------------------------------------
  #	 
  #	"C++indentLine" --
  #	
  #  More sophisticated version of Pete's.  Handles things like '(...)'
  #  expressions split over multiple lines, if/elseif/else both with
  #  and without curly braces, multiple line stream manipulation with
  #  '<<' or '>>', C and C++ style comments, ...  Assumes indentation
  #  is '4' but any tab-size may be used.
  #	 
  #  Current bugs: multi-line ',' separated lists are poorly indented.
  #
  #  Problems:
  #   matchIt's limit doesn't seem to work, so if there is no match and we're
  #   in a large file, we wait up to seconds sometimes.  Alpha bug.
  #		   
  #  Currently checking whether we're in a /*...*/ comment is quite
  #  time consuming.  It would be nice if Alpha supplied a hook to do
  #  this for us.
  #   
  # Results: 
  #  Indents the current line correctly ;-) for C, C++ coding
  #	 
  # --Version--Author------------------Changes-------------------------------  
  #	  1.0	  Pete Keleher			  original
  #    2.0     <vince@santafe.edu> updated as described above.
  #    2.1     <vince@santafe.edu> faster, better, uses positions not strings
  #    2.2     <vince@santafe.edu> uses 'correctIndentation' sub proc
  # -------------------------------------------------------------------------
  ##
proc C++::indentLine {} {
    # preliminaries
    set beg [lineStart [set p [getPos]]]
    # are we in a C comment /*...*/ if so indent specially and return
    # we really need to work out how to put this in 'correctIndentation'
    if {![catch {C_inCComment $beg} comment]} {
	set fChar [search -s -f 1 -r 1 "\[^ \t\r\n\]" $beg]
	if { [lookAt [lindex $fChar 0]] == "*" } {
	    return [eval C_indentCommentLine [list $beg] $comment]
	}
    }
    set text [getText $beg [nextLineStart $beg]]
    if {[regexp "^\[ \t\]*" $text white]} {
	set len [string length $white]
	set rest [string range $text $len end]
    } else {
	set white ""
	set rest ""
	set len 0
    }
    # get indentation level	
    set lwhite [text::indentOf [C++::correctIndentation [getPos] [string trim $rest]]]
    if {$white != $lwhite} {
	replaceText $beg [pos::math $beg + $len] $lwhite
    }
    goto [pos::math $beg + [string length $lwhite]] 
    # To keep relative position.
    #goto [pos::math $p + [string length $lwhite] - $len]
}


proc C::correctIndentation {args} {eval C++::correctIndentation $args}
proc Objc::correctIndentation {args} {eval C++::correctIndentation $args}

## 
 # -------------------------------------------------------------------------
 # 
 # "C++::correctIndentation" --
 # 
 #  Known bugs:
 #  
 #  Lines which contain a URL with :// embedded tend to be considered
 #  a ':' followed by a comment, and are indented as if they were
 #  part of a 'case://comment' statement which is wrong.
 # -------------------------------------------------------------------------
 ##
proc C++::correctIndentation {pos {nextword ""}} {
    # preliminaries
    set beg [lineStart $pos]
    set nextCh [string range $nextword 0 3]
    set nextC [string index $nextCh 0]
    set nextP [string range $nextCh 0 1]
    # check for forced indentation of C, C++ comments and '#' macros
    set ind "code 0"
    switch -- $nextC {
	"\#" {
	    global indentMacros
	    set ignore_trailers ""
	    set ind $indentMacros
	}
	"/" {
	    global indentComments indentC++Comments
	    set ignore_trailers ""
	    if {$nextP == "/*"} {set ind $indentComments}
	    if {$nextP == "//"} {set ind ${indentC++Comments}}
	}
    }
    if {[lindex $ind 0] == "fixed" } {
	# force indentation to given level
	return [lindex $ind 1]
    }
    
    # (1) first we get the indent of the last line:
    # this may involve looking back a fair way
    set lst [C_prevCodeIndent [pos::math $beg - 1]]
    
    if {[pos::compare [set pstart [lindex $lst 0]] == [minPos]]} {
	return 0
    }
    set lwhite [posX [pos::math [lindex $lst 1] - 1]]	
    # have we just finished an if-elseif-else with no '{}'?
    if {$nextCh == "else"} {set iselse 1} else { set iselse 0}
    if {![C_isLineNBI $pstart]} {
	incr lwhite [C_recurseNoBraceIndent $pstart 0 $iselse]
    }
    if { [set multi [C_isLineMulti $pstart]] != "-1" } {
	set lwhite $multi
    }
    
    # (2) now we indent this line accordingly
    
    set pbeg [prevLineStart $beg]
    set backpos [nextLineStart [lindex $lst 0]]
    # is there a comment at the end of the line? if so scan back to the character we want
    if {![catch {search -s -f 0 -r 1 -l $pbeg "//\[^\r\n\]*\[\n\r\]" $backpos} compos]} {
	set compos [lindex $compos 0]
	if {[pos::compare $compos > $pbeg]} {
	    set backpos [pos::math $compos + 1]
	}	
    }
    global indentationAmount
    if {[pos::compare [set backpos [pos::math $backpos - 2]] > [minPos]]} {
	set lst [search -s -f 0 -r 1 -m 0 "\[^ \t\r\n\]" $backpos]
	switch -- [lookAt [lindex $lst 0]] {
	    "\{" {
		incr lwhite $indentationAmount
	    } 
	    ":" {
		if { [lookAt [pos::math [lindex $lst 0] - 1]] != ":" } {
		    # expression is better for odd indentationAmounts
		    incr lwhite [expr {$indentationAmount - $indentationAmount/2}]
		}
	    } 
	    "\)" {
		# see if we're in a if-elseif-else with no '{}' and indent
		if {[C_isLineNBI $pstart]} {
		    incr lwhite $indentationAmount
		}
	    }
	    "e" {
		if { [getText [pos::math [lindex $lst 0] - 3] \
		  [pos::math [lindex $lst 0] + 1]] == "else" } {
		    if {[C_isLineNBI $pstart]} {
			incr lwhite $indentationAmount
		    }
		}
		
	    }
	}
    }
    
    switch -- $nextC {
	"\}" {
	    incr lwhite [expr -$indentationAmount]
	}
	"<" -
	">" {			
	    # indent for '<<' and '>>' in multi-line C++ stream manipulation
	    if {$nextP == "<<" || $nextP == ">>"} {
		set strm [search -s -f 1 -r 1 "^\[^${nextC}\]+${nextP}" $pbeg]
		set lwhite [posX [pos::math [lindex $strm 1] - 2]]
	    }
	}
    }
    # Check if we're in a multi-line '(.....)' if so align to start
    global useFasterButWorseIndentation
    if {!$useFasterButWorseIndentation && ![catch {matchIt ")" $beg 200} paren]} {
	set lwhite [posX [pos::math $paren + 1]]
    }

    if {[regexp "^(case\[ \t\].*|\[a-zA-Z\]+):(\[^:\]|\$)" $nextword] && $lwhite > 3 \
      && ![info exists ignore_trailers]} {
	incr lwhite [expr -$indentationAmount/2]
    }
    # get indentation level	
    return [incr lwhite [lindex $ind 1]]
}

## 
 # -------------------------------------------------------------------------
 # 
 # "C++::electricLeft" --
 # 
 #  For those who like to place left braces after 'for', 'else' etc. on 
 #  their own line, this will ensure the left brace is correctly placed.
 # -------------------------------------------------------------------------
 ##
proc C++::electricLeft {} {
    if {[string trim [getText [lineStart [getPos]] [getPos]]] == ""} {
	if {[C_isLineNBI [prevLineStart [getPos]]]} {
	    set p [lineStart [getPos]]
	    insertText "\{\r"
	    goto $p
	    shiftLeft
	    goto [nextLineStart $p]
	    bind::IndentLine
	    return
	}
    }
    ::electricLeft
}

proc C::electricLeft {} {C++::electricLeft}
proc Objc::electricLeft {} {C++::electricLeft}

## 
 # -------------------------------------------------------------------------
 #	 
 # "recurseNoBraceIndent" --
 #	
 # Scans back until we no longer have a 'no brace indent'.  A 'no brace
 # indent' is a 'for', 'if' etc which didn't use '{ ...  }'
 # -------------------------------------------------------------------------
 ##
proc C_recurseNoBraceIndent {pos offset {iselse 0}} {
    set pos [prevLineStart $pos]
    if {[C_isLineNBI $pos]} {
	global indentationAmount
	if {$iselse} {
	    set p [text::firstNonWsPos $pos]
	    set t [getText $p [pos::math $p + 10]]
	    if {[regexp  "(else\[ \t\]+)?if.*" $t]} {
		return [expr {$offset -$indentationAmount}]
	    }
	}
	return [C_recurseNoBraceIndent $pos [incr offset [expr -$indentationAmount]] $iselse]
    }
    return $offset
    
}

if {${alpha::platform} == "alpha"} {
    set C_recNBI "^\[ \t\]*((\}?\[ \t\]*(if|else\[ \t\]+if)|for)\[ \t\]*\\(.*\\)|\}?\[ \t\]*else)\[ \t\]*(//\[^\r\n\]*)?\[ \t\r\n\]*"
} else {
    set C_recNBI {^[[:blank:]]*((\}?[[:blank:]]*(if|else[[:blank:]]+if)|for)[[:blank:]]*\([^()]*\)|\}?[[:blank:]]*else)[[:blank:]]*(//[^\r\n]*)?\s*}
}

## 
 # -------------------------------------------------------------------------
 #	 
 # "isLineNBI" --
 #	
 #  Tests if the given line is a 'no brace indent'.  'pos' is the beginning
 #  of the line in question, else this proc will fail.
 # -------------------------------------------------------------------------
 ##
proc C_isLineNBI {pos} {
    global C_recNBI
    if {![catch {search -s -f 1 -r 1 -l [nextLineStart [nextLineStart $pos]] $C_recNBI $pos} ifelse] } {
	if {[pos::compare $pos == [lindex $ifelse 0]]} {
	    if {[pos::compare [lindex $ifelse 1] == [maxPos]] || ([lookAt [lindex $ifelse 1]] != "\{")} {
		return 1 
	    }
	}
    }
    return 0
}

# use 'catch' to call this proc: error = no, otherwise returns st,end pos
proc C_inCComment {pos} {
    set cS [search -s -f 0 -r 0 -l [pos::math $pos - 1000] "/*" $pos]
    set cE [search -s -f 1 -r 0 -l [pos::math $pos + 1000] "*/" [lindex $cS 1]]
    if {[pos::compare $pos >= [lindex $cE 1]] } {
	error "No"
    } else {
	return [list [lindex $cS 0] [lindex $cE 1]]
    }
}

# look for '<<' and '(...)' multi lines.
proc C_isLineMulti {pos} {
    # look for multi-line '(...)'
    if { ![catch {search -s -f 0 -r 1 -l $pos {\).*$} [nextLineStart $pos]} paren] \
      && [pos::compare [nextLineStart $pos] == [pos::math [lindex $paren 1] + 1 ]] } {
	if {[catch {matchIt "\)" [pos::math [lindex $paren 0] - 1] 200} realStart]} {
	    return -1
	}
	if {[pos::compare [lineStart $realStart] != [lineStart [lindex $paren 0]]] } {
	    set lst [search -s -f 0 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $realStart]
	    return [posX [pos::math [lindex $lst 1] - 1]]
	}
    }
    # look for multi-line '<<' or '>>'
    set p $pos
    while {![catch {search -s -f 1 -r 1 -l [nextLineStart $p] "^\[ \t\]*(<<|>>)" $p} strm] } {
	set p [prevLineStart $p]
    }
    if { $p != $pos } {
	set lst [search -s -f 1 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $p]
	return [posX [pos::math [lindex $lst 1] - 1]]
    }
    
    return -1
    
}

## 
 # -------------------------------------------------------------------------
 #   
 # "C_indentCommentLine" --
 #  
 #  Indents a line within a multi-line /* ... */ comment correctly.
 # -------------------------------------------------------------------------
 ##
proc C_indentCommentLine {beg cS cE} {
    # Turn all extraneous leading characters into spaces.
    regsub -all "\[^ \t\r\n\]" [getText [lineStart $cS] $cS] " " lwhite
    set lwhite [text::minSpaceForm $lwhite]
    if {[pos::compare $beg != [lineStart [lindex $cE 0]]] \
      || [text::firstNonWs [pos::math $beg - 1]] == "*" } {
	append lwhite " "	
    }
    
    set text [getText $beg [nextLineStart $beg]]
    regexp "^\[ \t\]*" $text white
    set len [string length $white]
    if {$white != $lwhite} {
	replaceText $beg [pos::math $beg + $len] $lwhite
    }
    goto [pos::math $beg + [expr {[string length $lwhite] +1}]]
}


## 
 # -------------------------------------------------------------------------
 #   
 # "C_prevCodeIndent" --
 #  
 #  Find the indent of the previous line
 #  -  If it's the start of the file, return 0 0 (special case)
 #  else
 #  -  if it's a C++ comment, keep looking backwards (so you can offset
 #     C++ comments if you so desire)
 #  -  if it's a C comment, get the indentation of the '/*' not some
 #     intermediate point.
 # -------------------------------------------------------------------------
 ##
proc C_prevCodeIndent {pos} { 
    while {1} {
	if {[pos::compare $pos == [minPos]] \
	  || ([catch {search -s -m 0 -f 0 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $pos} p]) \
	  || $p == "[minPos] [minPos]" } {
	    return [list [minPos] [pos::math [minPos] + 1]]
	} else {
	    set pp [doubleLookAt [pos::math [lindex $p 1] - 1]]
	    if { $pp == "//" } {
		set pos [pos::math [lindex $p 0] - 1]
	    } elseif { [string index $pp 0] == "#" } {
		global indentMacros
		if {$indentMacros == "code 0"} {
		    break
		}
		set pos [pos::math [lindex $p 0] - 1]
	    } elseif { $pp == "*/" } {
		set pos [lindex [search -s -f 0 -r 0 "/*" \
		  [pos::math [lindex $p 0] - 1]] 0]
	    } elseif { ![catch {set comment [C_inCComment [lindex $p 0]]} ] } {
		set pos [pos::math [lineStart [lindex $comment 0]] - 1]
		#return [text::indentation [lindex $comment 0]] (old style)
	    } else {
		break
	    }
	}
    }
    return $p
}


#  Electric routines  #

proc C::carriageReturn {} {C++::carriageReturn}
proc Objc::carriageReturn {} {C++::carriageReturn}

proc C::OptionTitlebar {} {C++::OptionTitlebar}
proc Objc::OptionTitlebar {} {C++::OptionTitlebar}

proc C::OptionTitlebarSelect {item} {C++::OptionTitlebarSelect $item}
proc Objc::OptionTitlebarSelect {item} {C++::OptionTitlebar}

## 
 # -------------------------------------------------------------------------
 #	 
 # "C++::carriageReturn" --
 #	
 #	Called by the general routine 'carriageReturn'.	We know	no selection 
 #	exists, and we are not inside a block comment.
 # -------------------------------------------------------------------------
 ##
proc C++::carriageReturn {} {
    if {[lookAt [pos::math [getPos] - 1]] == ":"} {
	if {[regexp {[\r\n]} [lookAt [getPos]]]} {
	    bind::IndentLine
	    endOfLine
	    insertText "\r"
	} else {
	    set pos [getPos]
	    endOfLine
	    set t [getText $pos [getPos]]
	    replaceText $pos [getPos] ""
	    bind::IndentLine
	    endOfLine
	    insertText "\r"
	    insertText $t
	}
    } else {
	insertText "\r"
    }
    catch {bind::IndentLine}
}

proc C++::OptionTitlebar {} {
    if {![catch {C++::tryIDEget} ret]
    &&  ![regexp {^\(} [lindex $ret 0]]} {
	return $ret
    }
    # else just scan through, provided the scan will function
    set cid [scancontext create]
    set lines {}
    scanmatch $cid {#.*include.*(<|")(.*)(>|")}  {
	lappend lines $matchInfo(submatch1)
    }
    set fid [alphaOpen [win::StripCount [win::Current]] "r"]
    scanfile $cid $fid
    close $fid
    scancontext delete $cid
    set lines [lsort -ignore $lines]
    if {[regexp {^\(} [lindex $ret 0]]} {
	if {[llength $lines] > 0} {
	    set lines [linsert $lines 0 "-"]
	} 
	set lines [eval linsert [list $lines] 0 $ret]
    }
    return $lines
}

proc C++::OptionTitlebarSelect {fname} {
    C++::tryIDEedit $fname
}

proc C++::tryIDEget {} {
    global IDE
    switch -- $IDE {
	1 {thinkGetIncludeFiles}
	0 {cw::getIncludeFiles}
	2 {error "No IDE at all!"}
    }
}

proc C++::tryIDEedit {fname} {
    global IDE
    switch -- $IDE {
	1 {thinkEditIncludeFile $fname}
	0 {cw::editIncludeFile $fname}
	2 {error "No IDE at all!"}
    }
}

