#################################################################################
# change log mode.
# 
# You should not remove this file.  Alpha may not function very well
# without it.
#================================================================================

alpha::mode Chng 0.1.5 source {Change*} {
} {} help {
    Chng mode is used for Alpha's "Changes" files, recording recent
    changes made to the application or its Tcl libraries.  The help file
    "Changes - AlphaTcl" is an example of such a file.  This mode has
    its own marking scheme, and will colorize all lines with "=" red.

    This mode is not particularly intended for text editing.
}

newPref f wordWrap {1} Chng
# '=' starts a comment, bullets are specially coloured,
# and strings are green.
regModeKeywords -e "=" -i "" -I blue -s green Chng {}

namespace eval Chng {}

newPref f autoMark {0} Chng

proc Chng::MarkFile {} {
    message "Marking"
    set pos  [minPos]
    set markExpr {^(= )*[0-9]+}

    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $markExpr $pos} match]} {
	set start [lindex $match 0]
	set end   [nextLineStart $start]
	regsub    {= } [getText $start $end] {} text
	regsub    {(- )?released} $text {                   } text
	set text  [string trimright [string range $text 0 20]]
	setNamedMark $text $start $start $start
	set pos $end
    }
    message ""
}
