## -*-Tcl-*-
 # ###################################################################
 #  JavaScript mode - tools for editing JavaScript documents
 # 
 #  FILE: "javaScriptMode.tcl"
 #                                    created: 97-02-09 13.00.54 
 #                                last update: 01-11-17 11.34.31 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 1.1.3
 # 
 # Copyright 1997-2001 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

alpha::mode JScr 1.1.3 JScrDummy {*.js *.JS} {
	electricBraces electricColon electricSemicolon electricTab electricReturn} {
} uninstall this-file maintainer {
	"Johan Linde" <alpha_www_tools@go.to> <http://go.to/alpha_www_tools>
} help {file "HTML Help"}

catch {unset JScrmodeVars(elecRBrace)}
catch {unset JScrmodeVars(elecLBrace)}
catch {unset JScrmodeVars(electricSemi)}
catch {unset JScrmodeVars(electricTab)}
catch {unset JScrmodeVars(electricColon)}

newPref v prefixString {//}  JScr
newPref f wordWrap 0 JScr
newPref v funcExpr {^[ \t]*function *([+-a-zA-Z0-9]+)} JScr
newPref v parseExpr {^[ \t]*function *([+-a-zA-Z0-9]+)} JScr
newPref v wordBreak {\w+} JScr
newPref v wordBreakPreface {\W} JScr
newPref v stringColor	green JScr
newPref v commentColor red JScr
newPref v keywordColor blue JScr


regModeKeywords  -e {//} -b {/*} {*/} -c $JScrmodeVars(commentColor) -k $JScrmodeVars(keywordColor)  -s $JScrmodeVars(stringColor) JScr {
	break case continue default delete do export for import in function if else new return switch this typeof var void while with true false }


proc JScrDummy {} {}

proc JScr::carriageReturn {} {
	global indentOnReturn electricColon
	if {$electricColon && [lookAt [pos::math [getPos] - 1]] == ":"} {
		if { [lookAt [getPos]] == "\r" } {
			catch {bind::IndentLine}
			endOfLine
			insertText "\r"
		} else {
			set pos [getPos]
			endOfLine
			set t [getText $pos [getPos]]
			replaceText $pos [getPos] ""
			catch {bind::IndentLine}
			endOfLine
			insertText "\r"
			insertText $t
		}
	} else {
		insertText "\r"
	}
	if {$indentOnReturn} {catch {bind::IndentLine}}
}

proc JScr::DblClick {from to} {
	global HOME
	select $from $to
	set word [getText $from $to]
	if {[grep "^${word}( |$)" [lindex [glob [file join $HOME JSreference index*]] 0]] != ""} {
		editMark [lindex [glob [file join $HOME JSreference JS*]] 0] $word -r
	} elseif {[lsearch -exact {break continue for function if else new return this var while with} $word] >= 0} {
		if {$word == "if" || $word == "else"} {set word "if...else"}
		editMark [lindex [glob [file join $HOME JSreference statements]] 0] $word -r
	}
}

proc JScr::correctIndentation {args} {
	eval ::correctBracesIndentation $args
}

set JScr::commentCharacters(General) [list "*" "//"]
set JScr::commentCharacters(Paragraph) [list "/* " " */" " * "]
set JScr::commentCharacters(Box) [list "/*" 2 "*/" 2 "*" 3]

