## -*-Tcl-*-
 # ###################################################################
 #  Please help with this mode! (also see makeMenu.tcl)
 # 
 #  FILE: "makeMode.tcl"
 #                                    created: 09/03/2001 {23:29:40 PM} 
 #                                last update: 11/08/2001 {11:05:38 AM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #          317 Paseo de Peralta, Santa Fe
 #     www: http://www.santafe.edu/~vince/
 #  
 # ###################################################################
 ##

# mode declaration
alpha::mode make 0.1.3 source {Makefile makefile.vc configure *.m4} {makeMenu} {
    
} maintainer {
    {Vince Darley} vince@santafe.edu http://www.santafe.edu/~vince/
} help {
    For make files
} uninstall {this-file}

#  mode preferences  #

namespace eval make {}
newPref v prefixString {# } make
set make::commentCharacters(General) "\#"

regModeKeywords -e "\#" -i "\$" -s green make {}

newPref f autoMark 0 make

proc make::MarkFile {} {
    message "Marking"
    set pos  [minPos]
    set markExpr {^([a-zA-Z]+):}

    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $markExpr $pos} match]} {
	set start [lindex $match 0]
	set end   [pos::math [lindex $match 1] -1]
	set text  [getText $start $end]
	setNamedMark $text $start $start $start
	set pos [nextLineStart $end]
    }
    message ""
}

