# Automatically created by mode assistant, with input from Vince.
#
# Mode: man
# 
# Note: Additional user modifications.


# Mode declaration.
#  first two items are: name version
#  then 'source' means source this file when we first use the mode
#  then we list the extensions, and any features active by default
alpha::mode man 0.1.3 source {*.n *.3 *.1} {} {
    # Script to execute at Alpha startup
} help {
    Unix-style manual pages can be edited with this mode.  Parsing and
    viewing of man pages is not supported (use 'nroff' or 'man').
}

# For Tcl 8
namespace eval man {}

newPref v wordBreak {(\\.)?[\w\\]+} man
newPref v wordBreakPreface {([^\w\\.])} man

# Paragraphs limits are either empty lines, or lines starting with a
# dot
set man::startPara {^[ \t]*(\.[^\r\n]*)?$}
set man::endPara {^[ \t]*(\.[^\r\n]*)?$}

# Mode preferences settings, which can be edited by the user (with F12)

newPref flag wordWrap 1 man
newPref v prefixString  {'\" } man

# These are used by the ::parseFuncs procedure when the user clicks on
# the {} button in a file edited using this mode.  If you need more sophisticated
# function marking, you need to add a man::parseFuncs proc

newPref flag funcExpr {^.SH [^\r\n\t]*} man
newPref flag parseExpr {.SH (.*)} man

# Register comment prefix
set man::commentCharacters(General) {'\" }
# Register multiline comments
set man::commentCharacters(Paragraph) {{'\" } {'\" } {'\" }}
# List of keywords
set manKeyWords {
    .TH .BS .SH .sp .so .AS .AP .BE .IP .PP .TP .VE .LP .RS .RE
    NAME SYNOPSIS KEYWORDS ARGUMENTS
    DESCRIPTION OPTIONS OPERANDS EXAMPLES FILES ATTRIBUTES SEE ALSO NOTES USAGE
    ENVIRONMENT VARIABLES EXIT STATUS BUGS
}

# Colour the keywords, comments etc.
regModeKeywords -e {'\"} man $manKeyWords
# Discard the list
unset manKeyWords

proc man::MarkFile {} {
    set pos [minPos]
    set pat {^([A-Z][A-Z ]+$)|(NAME[\r\n\t ]+[a-zA-Z0-9:]+)}
    set count 0
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 $pat $pos} match]} {
	set pos0 [lindex $match 0]
	set pos1 [lindex $match 1]
	set text [getText $pos0 $pos1]
	regsub "NAME\[\r\n\t \]+" $text {NAME -- } text
	while {[lcontains labels $text]} {append text " "}
	lappend labels $text
	setNamedMark $text $pos0 $pos0 $pos0
	set pos [nextLineStart $pos1]
	incr count
    }
    status::msg "This reference manual contains $count sections."
}

proc man::DblClick {from to shift option control} {
    select $from $to
    set markName [getSelect]
    set pat "^$markName|(\[A-Z\]\[A-Z \]+$markName)"
    if {[string toupper $markName] != $markName} {
	# This is not an ALL CAP keyword.
	status::msg "Command double-click on ALL CAP section names."
    } elseif {[catch {search -f 1 -r 1 -i 0 -s $pat [minPos]} match]} {
	status::msg "Couldn't find the section '$markName'."
    } else {
	placeBookmark
	goto [lineStart [pos::math [lindex $match 0] - 1]]
	insertToTop
	status::msg "Press Ctrl-. to return to original cursor position."
    }
}

