##############################################################################
# TIP mode.
# 
# For Tcl Improvement Proposals.  As Donal Fellows says:
# 
# If you want it to be a *formal* proposal to the TCT (as opposed to just
# some idea that you're floating about) then format it according to the
# rules described in TIP#3:
# 
#   <http://purl.org/tcl/tip/3.html>
# 
# and email it to the TCT or (preferably) the acting TIP Editor
# (attachments OK) at:
# 
#   <mailto:donal.fellows@cs.man.ac.uk>
# 
#=============================================================================
# Automatically created by mode assistant, with input from Vince.
# 
# This file is distributed under a Tcl-style free license.
#
# Mode: TIP


# Mode declaration.
#  first two items are: name version
#  then 'source' means source this file when we first use the mode
#  then we list the extensions, and any features active by default
alpha::mode TIP 0.3.4 source *.tip {TIPMenu indentUsingSpacesOnly} {
    # Script to execute at Alpha startup
    addMenu TIPMenu TIP
} help {
    Tcl Improvement Proposals are the best of way of getting a particular
    change to Tcl into the official Tcl releases.  Alpha's TIP mode
    includes a TIP menu which makes it easier to write such proposals --
    see the "TIP Example.tip" file for an example.

    See the TIP web page at <http://purl.org/tcl/tip/>
    for further information.
}


namespace eval TIP {}

# Mode preferences settings, which can be edited by the user (with F12)

# The email address of the current TIP editor
newPref variable tipEditor donal.fellows@cs.man.ac.uk TIP
# The url of the current TIP web site
newPref url tipWebsite http://purl.org/tcl/tip/ TIP
# The url of the TIP formatting guidelines
newPref url tipFormat http://purl.org/tcl/tip/3.html TIP
# The url of the tclcore mailing list archives
newPref url tclcoreArchives \
  "http://www.geocrawler.com/redir-sf.php3?list=tcl-core" TIP

newPref flag wordWrap 1 TIP

# These are used by the ::parseFuncs procedure when the user clicks on
# the {} button in a file edited using this mode.  If you need more
# sophisticated function marking, you need to add a TIP::parseFuncs
# proc

newPref var funcExpr {^~ [^\r\n]+} TIP
newPref var parseExpr {~ (.*)} TIP

# This proc is called every time we turn the menu on.
# Its main effect is to ensure this code, including the
# menu definition below, has been loaded.
proc TIPMenu {} {}
# Now we define the menu items.
Menu -n $TIPMenu -p TIP::menuProc {
    createDraftTip
    (-)
    mailToEditor
    convertToHtml
    (-)
    tagAsPreformatted
    (-)
    tipFormatting
    tipWebsite
    tclcoreArchive
}

# This procedure is called whenever we select a menu item
proc TIP::menuProc {menu item} {
    global TIPmodeVars
    switch -- $item {
	createDraftTip {
	    global HOME
	    file::openAsTemplate [file join $HOME "Examples" TIP-Example.tip] \
	      "DraftTIP.tip" 0
	}
	mailToEditor {
	    set tip [getText [minPos] [maxPos -w [win::Current]]]
	    # Very long url's seemed to have trouble.
	    global tcl_platform
	    if {$tcl_platform(platform) == "windows"} {
		if {[string length $tip] > 500} {
		    putScrap $tip
		    set tip "The TIP was placed on the clipboard (it was\
		      too long to handle automatically)\nJust paste it in"
		}
	    }
	    composeEmail [url::mailto $TIPmodeVars(tipEditor) \
	      body $tip subject TIP]
	}
	convertToHtml {
	    global HOME
	    set to "[file rootname [win::StripCount [win::Current]]].html"
	    script::run [file join $HOME Tools parse.tcl] -noTk $to
	    if {[file exists $to]} {
		htmlView $to
	    }
	}
	tagAsPreformatted {
	    TIP::tagAsPreFormatted
	}
	tipFormatting {
	    url::execute $TIPmodeVars(tipFormat)
	}
	tipWebsite {
	    url::execute $TIPmodeVars(tipWebsite)
	}
	tclcoreArchive {
	    url::execute $TIPmodeVars(tclcoreArchives)
	}
    }
}

# Register comment prefix
set TIP::commentCharacters(General) ~
# Register multiline comments
set TIP::commentCharacters(Paragraph) {{~ } {~ } {~ }}
# List of keywords
set TIPKeyWords {
    Title TIP Version Author State Type Tcl-Version Vote Created Post-History
}

# Colour the keywords, comments etc.
regModeKeywords -e ~ -i > -s green TIP $TIPKeyWords
# Discard the list
unset TIPKeyWords

newPref f autoMark 1 TIP

proc TIP::MarkFile {} {
    set pos  [minPos]
    set markExpr {^~ [^\r\n]+}

    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $markExpr $pos} match]} {
	set start [lindex $match 0]
	set end   [nextLineStart $start]
	regsub    {^~ } [getText $start $end] {} text
	setNamedMark [string trimright $text] $start $start $start
	set pos $end
    }
}

proc TIP::tagAsPreFormatted {} {
    set sel [getSelect]
    if {![string length $sel]} {
	error "No current selection"
    }
    # Turn into spaces
    set sel [text::maxSpaceForm $sel]
    # split and join with leading '|'
    set sel "|[join [split $sel \r\n] \r|]"
    # remove a trailing | if necessary
    set sel [string trimright $sel "|"]
    replaceText [getPos] [selEnd] $sel
}
