## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "RemoteTclShell.tcl"
 #                                    created: 1/10/97 {5:54:23 pm} 
 #                                last update: 03/23/2001 {21:25:36 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: <http://www.santafe.edu/~vince/>
 #  
 #  Description: 
 # 
 #  History
 # 
 #  modified   by  rev reason
 #  --------   --- --- -----------
 #  1/10/97    VMD 0.1 original
 #  1999-09-26 VMD 0.2 updated for Alpha/Alphatk 7.2 or newer
 #  
 # Copyright (c) 1997-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # Distributable under Tcl-style (free) license.
 #  
 # ###################################################################
 ##

# mode declaration
alpha::extension RemoteTclShell 0.2.1 {
    alpha::package require AlphaTcl 7.2.1
    menu::replaceWith Utils "<S/Y<Oshell" items "<S/Y<Oshell" "<S/Y<O<IremoteTclShell" 
} maintainer {
    {Vince Darley} <vince@santafe.edu> <http://www.santafe.edu/~vince/>
} uninstall {this-file} help {Use Alpha as a console for a remote Wish shell}

#  Remote Tcl Shell routines  #


namespace eval tcltk {}

proc tcltk::Prompt {} {
    global Shel::startPrompt Shel::endPrompt tclshInterp
    if {[info exists tclshInterp]} {
	set name ${tclshInterp}
    } else {
	set name "no-shell"
    }
    return "${Shel::startPrompt}${name}${Shel::endPrompt} " 
}


proc remoteTclShell {} {
    global tclshSig tclshSigs tcl_platform tclshInterp
    if {$tcl_platform(platform) == "macintosh"} {
	app::launchElseTryThese $tclshSigs tclshSig "Please locate the remote Tcl application"
	set tclshInterp [file tail [nameFromAppl $tclshSig]]
    } else {
	tcltk::findTclshInterp
    }
    Shel::start "tcltk" "* Tcl remote shell *" "Welcome to Alpha's remote Tcl shell\r"
}


