# (install)
##################################################################
# 
# BibTeX to HTML converter (new version). 
# 
# Pierre BASSO 
# email:basso@lim.univ-mrs.fr
#
# 
# This procedure is inserted as a command in the menu mode BibTeX.
# You use this command in selecting all a bib file  or only a part, 
# bibToHtml will convert the selected part. If no selection, all the
# bib file is selected. The selection is put in a temporary bib file,
# bibToHtml asks for a bib style, it builds an aux temporary file then
# it launches BibTeX which deals this temporary aux and converts the
# temporary bib file. If your selection is a part of a file, or whole the file,
# 'fooname.bib' all these temporaries files are created in the same folder. 
# 
#  Then bibToHtml deals with the temporary bbl file created, when it ends 
#  it asks for directly sending the html file to the browser, else it displays
#  this file as a front window. You may improve this html file, in adding titles, 
#  figures or any fancies, for example, before sending to the browser.
# 
#  WARNING: if some bib entries of selection are wrong, launching BibTeX will
#           display the errors. But these errors don't affect the work of 
#           bibToHtml, at the output these erroneous entries will be displayed
#           by the browser with wrong fields.
#           
#  WARNING: it is not needed to sort the selection because BibTeX will do it.
#           So the html outcome of bibToHtml appears correctly sorted.
#  
# I borrowed from "Convert LaTeX to accents" the table of regular 
# expressions for conversion of LaTeX characters. 
# Thanks to F. Miguel Dionsio 
# 
#
#
#################################################################


alpha::extension bibToHtml 2.1 {
    alpha::package require -loose Bib 3.6b1
    menu::insert bibtexConversions items end "bibToHtml"
} maintainer {
    "Pierre Basso" <basso@lim.univ-mrs.fr>
} help {
    file "BibToHtml Help"
}



#
#
#########################################################
#
#

proc Bib::bibToHtml {} {
    
   global  tabHtmlChar tabRegExpr 
   global HtmlGreek GreekExpr
   global LatexStyles HtmlStyles endHtmlStyles
   global label
   
 
# Keep name of the bib file in front window
  set bibfile [lindex [winNames -f] 0]
  set bibfile [file rootname $bibfile]
    
# Beginning to end of selection
  set buffer [getSelect]
  set lselect [string length $buffer]
  if {$lselect == 0} {
             endOfBuffer
             set endselection [getPos]
             set buffer [getText 0 $endselection]
}



# Create a temporary bib file with the selected entries
  set tmp [file dirname $bibfile]
  append tmp ":\$\$tmp"
  set tmpbib $tmp
  append tmpbib ".bib"
  catch {open $tmpbib w} id
  if {[string range $id 0 3] != "file"} {
     alertnote "cannot open a temporary .bib file"
     beep
     return
  }
  
  puts $id $buffer
  close $id
# Ask  for a bib style and creates temporary files .aux, .bak, .bbl, .blg
  set values [dialog  -w 350 -h 120\
                      -t "Please, provide a bibliography style:" 10 20 250 40 -e "plain" 270 20 330 40\
                      -b OK 50 80 115 110 -b Cancel 150 80 215 110]
  
  if {[lindex $values 2] == 1} {
      beep
      return}
 
  set buffer "\\bibstyle\{[lindex $values 0]\}\r"
  append buffer "\\citation\{*\}\r"
  append buffer "\\bibdata\{\$\$tmp\}"
  set tmpaux $tmp
  append tmpaux ".aux"
  catch {open $tmpaux w} id
  if {[string range $id 0 3] != "file"} {
     alertnote "cannot open a temporary .aux file"
     beep
     return
  }
  puts $id $buffer
  close $id
  set tmpbak $tmp
  append tmpbak ".bak"
  catch {open $tmpbak w} id
  if {[string range $id 0 3] != "file"} {
     alertnote "cannot open a temporary .bak file"
     beep
     return
  }
  close $id
  set tmpbbl $tmp
  append tmpbbl ".bbl"
  catch {open $tmpbbl w} id
  if {[string range $id 0 3] != "file"} {
     alertnote "cannot open a temporary .bbl file"
     beep
     return
  }
  close $id
  set tmpblg $tmp
  append tmpblg ".blg"
  catch {open $tmpblg w} id
  if {[string range $id 0 3] != "file"} {
     alertnote "cannot open a temporary .blg file"
     beep
     return
  }
  close $id

# launch BibTeX
  bibtexAUXFile $tmpaux
  
  
# Initialise conversion tables
# 
                                           

 set tabHtmlChar [list  "\\&agrave;" "\\&aacute;" "\\&acirc;" "\\&atilde;" "\\&auml;" "\\&aring;"\
                        "\\&Agrave;" "\\&Aacute;" "\\&Acirc;" "\\&Atilde;" "\\&Auml;" "\\&Aring;"\
                        "\\&egrave;" "\\&eacute;" "\\&ecirc;"  "\\&euml;" \
                        "\\&Egrave;" "\\&Eacute;" "\\&Ecirc;"  "\\&Euml;" \
                        "\\&igrave;" "\\&iacute;" "\\&icirc;"    "\\&iuml;" \
                        "\\&Igrave;" "\\&Iacute;" "\\&Icirc;"  "\\&Iuml;" \
                        "\\&ograve;" "\\&oacute;" "\\&ocirc;" "\\&otilde;" "\\&ouml;" \
                        "\\&Ograve;" "\\&Oacute;" "\\&Ocirc;" "\\&Otilde;" "\\&Ouml;" \
                        "\\&ugrave;" "\\&uacute;" "\\&ucirc;"  "\\&uuml;" \
                        "\\&Ugrave;" "\\&Uacute;" "\\&Ucirc;"  "\\&Uuml;" \
                        "" ""  "\\&aelig;" "\\&Aelig;" "\\&oslash;"  "\\&Oslash;"\
                        "\\&ccedil;" "\\&ntilde;" "\\&Ccedil;" "\\&Ntilde;"\
                        "\\&yacute;" "\\&yuml;"  "\\&Yacute;" "\\&Yuml;" ]

 set quote {"}                                  
 set ws {[ \t]*}
 set sp {[ \t]}
 set sep { *( |\b)}
 set seplater {\\\\sepsep//}
 set a [rexp a]
 set regas  [list  "\\\\`$a" "\\\\'$a" "\\\\\\^$a"  "\\\\~$a"  "\\\\\\$quote$a" "\\\\aa$sep"]
 set a [rexp A]
 set regcas [list  "\\\\`$a" "\\\\'$a" "\\\\\\^$a"  "\\\\~$a"  "\\\\\\$quote$a" "\\\\AA$sep"]
 set e [rexp e]
 set reges  [list  "\\\\`$e"  "\\\\'$e" "\\\\\\^$e"  "\\\\\\$quote$e"]
 set e [rexp E]
 set regces [list  "\\\\`$e"  "\\\\'$e" "\\\\\\^$e"  "\\\\\\$quote$e"]
 set i [rexp \\i$ws]
 set regis  [list  "\\\\`$i" "\\\\'$i"  "\\\\\\^$i"  "\\\\$quote$i"]
 set i [rexp I]
 set regcis  [list "\\\\`$i" "\\\\'$i"  "\\\\\\^$i"  "\\\\$quote$i"]
 set o [rexp o]
 set regos   [list "\\\\`$o" "\\\\'$o"  "\\\\\\^$o"  "\\\\~$o"  "\\\\$quote$o"]
 set o [rexp O]
 set regcos   [list "\\\\`$o" "\\\\'$o"  "\\\\\\^$o"  "\\\\~$o"  "\\\\$quote$o"]
 set u [rexp u]
 set regus    [list "\\\\`$u" "\\\\'$u"  "\\\\\\^$u"  "\\\\$quote$u"]
 set u [rexp U]
 set regcus   [list "\\\\`$u" "\\\\'$u"  "\\\\\\^$u"  "\\\\$quote$u"]
# set reglig   [list "\\\\oe$sep"  "\\\\OE$sep" "\\\\ae$sep" "\\\\AE$sep" "\\\\o$sep" "\\\\O$sep"]
 set reglig   [list "\\&\\#339"  "\\&\\#338;" "\\\\ae$sep" "\\\\AE$sep" "\\\\o$sep" "\\\\O$sep"]
 set regoth1  [list "\\\\c$sp[rexp c]|\\\\c{$ws\(c\)$ws}"  "\\\\~[rexp n]" "\\\\c$sp[rexp C]|\\\\c{$ws\(C\)$ws}"  "\\\\~[rexp N]" ] 
 set regoth2  [list "\\\\\\'[rexp y]" "\\\\\\$quote[rexp y]" "\\\\\\'[rexp Y]" "\\\\\\$quote[rexp Y]"]
                
 set tabRegExpr [concat $regas $regcas $reges $regces $regis $regcis $regos $regcos $regus $regcus\
              $reglig $regoth1  $regoth2 ]

 set GreekExpr [list "\(\\\$\)\\\\\(alpha\)\(\\\$\)" "\(\\\$\)\\\\\(beta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(chi\)\(\\\$\)" "\(\\\$\)\\\\\(delta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(epsilon\)\(\\\$\)" "\(\\\$\)\\\\\(phi\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(gamma\)\(\\\$\)" "\(\\\$\)\\\\\(eta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(iota\)\(\\\$\)" "\(\\\$\)\\\\\(varphi\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(kappa\)\(\\\$\)" "\(\\\$\)\\\\\(lambda\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(mu\)\(\\\$\)" "\(\\\$\)\\\\\(nu\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(pi\)\(\\\$\)" "\(\\\$\)\\\\\(theta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(rho\)\(\\\$\)" "\(\\\$\)\\\\\(sigma\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(tau\)\(\\\$\)" "\(\\\$\)\\\\\(upsilon\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(varpi\)\(\\\$\)" "\(\\\$\)\\\\\(omega\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(xi\)\(\\\$\)" "\(\\\$\)\\\\\(psi\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(zeta\)\(\\\$\)" "\(\\\$\)\\\\\(Delta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(Phi\)\(\\\$\)" "\(\\\$\)\\\\\(Gamma\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(vartheta\)\(\\\$\)" "\(\\\$\)\\\\\(Lambda\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(Pi\)\(\\\$\)" "\(\\\$\)\\\\\(Theta\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(Sigma\)\(\\\$\)" "\(\\\$\)\\\\\(varsigma\)\(\\\$\)"\
                     "\(\\\$\)\\\\\(Omega\)\(\\\$\)" "\(\\\$\)\\\\\(Xi\)\(\\\$\)"\
		     "\(\\\$\)\\\\\(Psi\)\(\\\$\)"]

 set HtmlGreek [list "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">a</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">b</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">c</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">d</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">e</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">f</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">g</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">h</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">i</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">j</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">k</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">l</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">m</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">n</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">p</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">q</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">r</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">s</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">t</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">u</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">v</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">w</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">x</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">y</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">z</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">D</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">F</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">G</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">J</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">L</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">P</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">Q</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">S</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">V</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">W</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">X</FONT>"\
                     "<FONT SIZE=\"3\" FACE=\"Symbol\" POINT-SIZE=\"3\">Y</FONT>"]

 set LatexStyles [list  "(\\\{\\\\it|\\\\textit\{)" "(\\\{\\\\em|\\\\emph\{)"\
                        "(\\\{\\\\bf|\\\\textbf\{)" "(\\\{\\\\tt|\\\\texttt\{)"\
                                                "(\\\\underline\{)"]
                                          
 set HtmlStyles  [list  "<I>" "<EM>" "<B>"  "<TT>" "<U>"]   
 
 set endHtmlStyles [list  "</I>" "</EM>" "</B>" "</TT>" "</U>"] 
 
#
# Translation of bbl temporary file into html
  buttonAlert "Converts a bbl file into html. Please wait the end of BibTeX process (beep sound)" OK
  set answer [askyesno -c  "Do you want labels?"]
  if {$answer == "cancel"} {
      removeFile $tmpbib
      removeFile $tmpaux
      removeFile $tmpbak
      removeFile $tmpblg
      removeFile $tmpbbl
      beep; return}
  if {$answer == "yes"} {set label 1} else {set label 0}
  
  set tmpbbl  $tmp
  append tmpbbl ".bbl"
  if {[file exists $tmpbbl] == 0} {
	alertnote "BibTeX cannot create a bbl file"
	beep
	return
   }
  set buffer [Convert2Html $tmpbbl]
#alertnote "retour conversion"
# Remove all temporaries files 
   removeFile $tmpbib
   removeFile $tmpaux
   removeFile $tmpbak
   removeFile $tmpblg
   if {$buffer == "wrong bbl"} {beep ; return}
   removeFile $tmpbbl

 # Display html file or edit it	
  set aa [file tail $bibfile]  
  set values [dialog -w 500 -h 220\
		  -t "Save the temporary html file as:"  10 20 280 40  -e "$aa" 300 20 450 40\
		  -r "Do you want edit this  html file?"  0 10 60 280 80\
		  -r "Do you want send this  html file to browser?" 1 10 100 340 120\
                  -b OK 50 160 115 190 -b Cancel 200 160 265 190]
 set cancel [string trim [lindex $values 4]]
 if {$cancel == 1} {
      beep
      return
 }
 set save [string trim [lindex $values 0]]
 set edit [string trim [lindex $values 1]]
 set browse [string trim [lindex $values 2]]   
 set xx [string first "." $save ]
 if {$xx != -1} {
    set extens [string range $save  [expr $xx+1] end]
    if {$extens != "html"} {
	set save [string range $save 0 [expr $xx-1]]
        append save ".html"
    }
 } else {append save ".html"}

  set htmlfile [file dirname $bibfile]
  append htmlfile ":$save"
  set idhtml [open $htmlfile w]
  set bufferhtml "<HTML>\r <HEAD>\r <TITLE> Bibliography</TITLE>\r </HEAD>\r"
  append bufferhtml "<BODY BGCOLOR=$quote#ffffff$quote LINK=$quote#cc0000$quote" 
  append bufferhtml "VLINK=$quote#005522$quote ALINK=$quote#ff3300$quote" 
  append bufferhtml "topmargin=$quote 5$quote leftmargin=$quote 5$quote>\r\r<DL>\r"   
  append bufferhtml $buffer 
  append bufferhtml "</DL>\r\r</BODY>\r </HTML>"
  puts $idhtml $bufferhtml
  close $idhtml
   
   if {$browse == 1}  {htmlSendWindow $htmlfile} 
   if {$edit == 1} {edit $htmlfile}
   

}


#
# Conversion of a bbl file into html
#

proc Convert2Html {bblfile} {

   global  tabHtmlChar tabRegExpr 
   global HtmlGreek GreekExpr
   global LatexStyles HtmlStyles endHtmlStyles
   global label
#
#   set id [open $bblfile r]
   catch {open $bblfile r} id
   if {[string range $id 0 3] != "file"} {
       alertnote "couldn't open the temporary bbl file"
       return "wrong bbl"       
   }
   if {[file size $bblfile] == 0} {
       alertnote "wrong temporary bbl file"
       return "wrong bbl"       
   }
   
   set bibitem ""
   set biblabel 0
   set convertedfile ""
   set bibindex 0
   while {$bibitem != "\\end\{thebibliography\}"} {
        set nbchar [gets $id bibitem]
	if {[string first "\\begin\{thebibliography\}" $bibitem] != -1} {continue}
	if {$nbchar == 0} {
	    append convertedfile "\r\r<BR><BR>"
	    continue
	}
	if {$bibitem == "\\end\{thebibliography\}"} {continue}
	if {[string first  "\\bibitem" $bibitem] != -1} {
	    if {$label == 0} {continue}
	    set bibitem [string  range $bibitem 8 end]
	    if {[string index $bibitem 0] == "\{"} {
		incr bibindex 1
		append convertedfile "\[$bibindex\]  "
		continue
	    }
	    set aa [string first "\]" $bibitem ]
	    set bibitem [string range $bibitem 1 [expr $aa-1]]
	    set biblabel 1
	}
	if {[string first  "\\newblock" $bibitem] != -1} {
	    set bibitem [string range $bibitem 10 end]
	    append convertedfile " "
	    set offset 0
	    set newblock ""
	    set endblock 0
	    while {$endblock != 1} {
		set nbchar [gets $id newblock]
	        if {[string first  "\\newblock" $newblock] != -1 || $nbchar == 0} {
		    set offset [expr -$nbchar-1]
		    seek $id $offset current
		    set endblock 1
		    continue
		}
	        append bibitem $newblock
	    }
	}
        regsub -all "\r" $bibitem "" bibitem
        regsub -all "\b" $bibitem "" bibitem
        regsub -all "\f" $bibitem "" bibitem
        regsub -all "\n" $bibitem " " bibitem
        regsub -all "" $bibitem "\\&#176;" bibitem  
        set indicbs [string first "\\" $bibitem ]
        if {$indicbs == -1} {
            regsub -all "\{" $bibitem "" bibitem
            regsub -all "\}" $bibitem "" bibitem
	    regsub -all "\~" $bibitem "" bibitem
	    regsub -all "" $bibitem "'" bibitem
	    if {$biblabel == 1} {
		append convertedfile "\[$bibitem\]  "
	        set biblabel 0} else {append convertedfile $bibitem}
            continue
	}
# Converts european accentued letters
	regsub -all "\\\\i" $bibitem "i" bibitem 
        set len [llength $tabRegExpr]
        set i 0
        while {$i < $len} {
              set c [lindex $tabRegExpr $i]
              set s [lindex $tabHtmlChar $i]
              regsub -all "$c" $bibitem "$s" bibitem 
              incr i
	}
# Searches for and converts greek letters in title of mathematical articles
        set indicbs [string first "\\" $bibitem ]
        if {$indicbs == -1} {
            regsub -all "\{" $bibitem "" bibitem
            regsub -all "\}" $bibitem "" bibitem
            if {$biblabel == 1} {append convertedfile "\[$bibitem\]  "
	                      set biblabel 0} else {append convertedfile $bibitem}
            continue
	}
        set len [llength $GreekExpr]
        set i 0
        while {$i < $len} {
               set c [lindex $GreekExpr $i]
                   set s [lindex $HtmlGreek $i]
                   regsub -all "$c" $bibitem "$s" bibitem 
                   incr i}
# Searches for styles italic, emphasized, typewriter, bold, underlined.
        set indicbs [string first "\\" $bibitem ]
        if {$indicbs == -1} {
            regsub -all "\{" $bibitem "" bibitem
            regsub -all "\}" $bibitem "" bibitem
            append convertedfile $bibitem
	    continue
	}
        set len [llength $LatexStyles]
        set j 0
        while {$j < $len} {
              set style [lindex $LatexStyles $j]
	      set found 1
	      while {$found > 0} {
                   set found [regexp -indices $style $bibitem values]
                   if {$found == 0} {continue}
                   set begtext  [lindex $values 0]
                   set bufftmp [string range $bibitem 0 [expr $begtext - 1]]
                   set htmlconv [lindex $HtmlStyles $j]
                   append bufftmp " $htmlconv"
                   set i 0
                   set braces 1
                   set lentmp [expr [string length  $bibitem ] - [lindex $values 1]]
                   while {$i < $lentmp} {
                          set char [string index $bibitem [expr [lindex $values 1] + $i + 1]]
                          if {$char == "\{"} {incr braces}
                          if {$char == "\}"} {
				      incr braces -1
                                      if {$braces == 0} {
					  set char [lindex $endHtmlStyles $j]
                                          set ii [expr $i+1]
                                          set i $lentmp
		                      } 
                           }
                           append bufftmp $char
                           incr i
                    }
                    append bufftmp [string range $bibitem [expr [lindex $values 1]+$ii+1] end]
                    set bibitem $bufftmp
	       }
               incr j
          }
# Convert superscript  expressions $A^e$
         set super [string first "^" $bibitem]
         while {$super >= 0} {
                 set bufftmp [string  range $bibitem 0 [expr $super-1]]
#	alertnote "bufftmp = $bufftmp"
	         set bibitem [string range $bibitem [expr $super+1] end]
                 set char [string range $bibitem 0  [expr [string first "$" $bibitem]-1]]
		 set bibitem [string range $bibitem [expr [string first "$" $bibitem]+1] end]
#	alertnote "exposant : $char"		 
#	alertnote "bibitem = $bibitem"
 		 append bufftmp "<SUP>$char</SUP> "
		 append bufftmp $bibitem
                 set bibitem $bufftmp
                 set super [string first "^" $bibitem]
         }
# Searches for and converts \uppercase commands
         set uppercase [string first "\\uppercase" $bibitem]
         while {$uppercase >= 0} {
                 set bufftmp [string  range $bibitem 0 [expr $uppercase-1]]
                 set bibitem [string range $bibitem [expr $uppercase+11] end]
                 set closbrace [string first "\}" $bibitem]
                 set char [string range $bibitem 0  $closbrace]
                 set char [string trimright $char "\}"]
                 set char [string toupper $char]
                 append bufftmp $char
                 append bufftmp [string  range $bibitem [expr $closbrace+1] end]
                 set bibitem $bufftmp
                 set uppercase [string first "\\uppercase" $bibitem]
         }
# Converts bad character ""
        regsub -all "" $bibitem "'" bibitem
# Converts possible \bullet latex commands.
        regsub -all "\(\\\$\)\\\\\(bullet\)\(\\\$\)" $bibitem "\\&#176;" bibitem
# Clears all possible remaining backslashes
        regsub -all "\\\\" $bibitem "" bibitem
# Clears possible remaining braces and backslashes.
        regsub -all "\{" $bibitem "" bibitem
        regsub -all "\}" $bibitem "" bibitem
# Clears possible tildas
	regsub -all "\~" $bibitem "" bibitem
# Clears possible dollars
	regsub -all "\\\$" $bibitem "" bibitem
# Converts -- into -
	regsub -all "\\-\\-" $bibitem "-" bibitem
# Conversion is achieved
	if {$biblabel == 1} {append convertedfile "\[$bibitem\]  "
	                     set biblabel 0} else {append convertedfile $bibitem}
    }

# Close bbl file and return
    close $id
    return $convertedfile
}

