## -*-Tcl-*- (install) (nowrap)
 # ###################################################################
 #  An extension to Alpha
 # 
 #  FILE: "bibToRefer.tcl"
 #                                    created: 08/24/98 {15:25:47 PM}  
 #                                last update: 12/15/00 {02:18:51 pm} 
 # 
 # (Vince turned this contributed code into a package)
 # ###################################################################
 ##
 
alpha::feature bibToRefer 1.03 "Bib" {
    alpha::package require -loose Bib 3.6b1
} {
    menu::insert bibtexConversions items end "bibToRefer"
} {
} uninstall {this-file} maintainer {
    "Peter Blattner" peter.blattner@imt.unine.ch
} help {
    Conversion of BibTeX to Refer (Endnote compatible).  If there are
    several authors, each author has its own tag %A.

    It might be necesseary to run the "Convert LaTeX to Accent" utility
    first, and eventually the "Format All Entries" menu item.

    Important: "@string"s are not handled, and if they are present the
    procedure will die without any warning.
}


###########################################################################
###########################################################################
#          BibTeX -> Refer (EndNote)  PBL
###########################################################################

###########################################################################
#  set-up of the fields used to make the Refer conversion (PBL)

set convFldBib(article) {reftype citekey author title journal year volume number pages month note}
set convFldRef(article) {"JOURNAL ARTICLE" "%F" "%A" "%T" "%B" "%D" "%V" "%N" "%P" "%8" "%O"}

set convFldBib(book) {reftype citekey author title publisher year editor volume number series address edition month note}
set convFldRef(book) {"BOOK" "%F" "%A" "%T" "%I" "%D" "%E" "%V" "%N" "%B" "%C" "%7" "%8" "%O"}

set convFldBib(booklet) {reftype citekey title author howpublished address month year note}
set convFldRef(booklet) {"BOOK" "%F" "%T" "%A" "%9" "%C" "%8" "%D" "%O"}

set convFldBib(conference) {reftype citekey author title booktitle year editor volume number series pages organization publisher address month note}
set convFldRef(conference) {"CONFERENCE PROCEEDINGS" "%F" "%A" "%T" "%B" "%D" "%E" "%V" "%N" "%S" "%P" "%Y" "%I" "%C"  "%8" "%O"}

set convFldBib(inbook) {reftype citekey author title chapter publisher year editor pages volume number series address edition month type note}
set convFldRef(inbook) {"BOOK SECTION" "%F" "%A" "%T" "%1" "%I" "%D" "%E" "%P" "%V" "%N" "%S" "%C" "%7" "%8" "%O"}

set convFldBib(incollection) {reftype citekey author title booktitle publisher year editor volume number series type chapter pages address edition month note}
set convFldRef(incollection) {"CONFERENCE PROCEEDINGS" "%F" "%A" "%T" "%B" "%I" "%D" "%E" "%V" "%N" "%S" "%9" "%1" "%P" "%C" "%8" "%O"}

set convFldBib(inproceedings) {reftype citekey author title booktitle year editor volume number series pages organization publisher address month note}
set convFldRef(inproceedings) {"CONFERENCE PROCEEDINGS" "%F" "%A" "%T" "%B" "%D" "%E" "%V" "%N" "%S" "%P" "%Y" "%I" "%C"  "%8" "%O"}

set convFldBib(manual) {reftype citekey title author organization address edition year month note}
set convFldRef(manual) {"REPORT" "%F" "%T" "%A" "%I" "%C" "%E"  "%D" "%8" "%O"}

set convFldBib(mastersthesis) {reftype citekey author title school year address month note type}
set convFldRef(mastersthesis) {"THESIS" "%F" "%A" "%T" "%I" "%D"  "%C" "%8" "%O" "%9"}

set convFldBib(misc) {reftype citekey author title howpublished year month note}
set convFldRef(misc) {"GENERIC" "%F" "%A" "%T" "%I" "%D"  "%C" "%8" "%O" "%9"}

set convFldBib(phdthesis) {reftype citekey author title school year address month type note}
set convFldRef(phdthesis) {"THESIS" "%F" "%A" "%T" "%I" "%D"  "%C" "%8" "%9" "%O"}

set convFldBib(proceedings) {reftype citekey title year editor volume number series publisher organization address month note}
set convFldRef(proceedings) {"EDITED BOOK" "%F" "%T" "%D" "%A" "%V" "%N" "%B" "%I" "%E" "%C"  "%8" "%O"}

set convFldBib(techreport) {reftype citekey author title institution year type number address month note}
set convFldRef(techreport) {"REPORT" "%F" "%A" "%T" "%I" "%D" "%9" "%N"  "%C" "%8" "%O"}

set convFldBib(unpublished) {reftype citekey author title note year month}
set convFldRef(unpublished) {"REPORT" "%F" "%A" "%T" "%O" "%D" "%8"}

# Special fields are fields that may have several authors/editors etc...

set SpecialFld [list "%A" "%E" "%Y"];

# list with all BibTeX types
set bibtypelst [list article book booklet conference inbook incollection inproceedings maunal masterthesis misc phdthesis proceedings techreport unpublished]

# if a BibTeX entry type doesn't exist, it becomes "generic" (see EndNote Manual)

set convFldBib(generic) {reftype citekey author journal address year editor publisher keywords number pages series title url volume abstract organization notes chapter custom edition month type translator isbn}
set convFldRef(generic) {"GENERIC" "%F" "%A" "%B" "%C" "%D" "%E" "%I"  "%K" "%N" "%P" "%S" "%T" "%U" "%V" "%X" "%Y" "%O" "%1" "%2" "%7" "%8" "%9" "%?" "%@"}




###################################################################
# conversion of BibTeX to Refer (Endnote compatible)
# if there are several authors, each author has its own tag %A.
# It might be necesseary to run the "Convert LaTeX to Accent" utility
# first, and eventually the "Format All Entries"
# Limitation: "@string" is not handled  
#			PBL

proc Bib::bibToRefer {} {
    global bibtypelst
    set spc "                           "
    # get current file name
    set fname [lindex [winNames] 0]
    # get output file name
    set fnameout [file rootname $fname]
    append fnameout ".refer"
    set fnameout [string trimright [putfile "Save converted file as" $fnameout]]
    if {![string length $fname]} {
	askyesno bloed
	return
    }
    set idout [open $fnameout "w"]
    
    goto [minPos]
    
    set hit [getEntry [getPos]]
    
    # This is a counter
    set nbEntry 0 
    
    #loop over all the entries
    while {[pos::compare [getPos] < [lindex $hit 1]]} {
	set top [lindex $hit 0] 
	set bottom [lindex $hit 1]
	if {[catch {getFields [getPos]} flds]} {
	    error "bibFormatEntry: Getflds couldn't find any"
	}
	set names [lindex $flds 0]
	set vals [lindex $flds 1]
	set nfld [llength $names]
	
	set type [string tolower [lindex $vals 0]]
	set citekey [lindex $vals 1]
	
	# Don't process @string entries
	if {$type == "string"} {
	    return
	}
	message $citekey
	
	# check if the reference type exists, if not : generic
	set isBibFld [lsearch $bibtypelst $type]
	if {$isBibFld < 0} {set type "generic"}
	
	#writes one entry in the output file
	puts $idout [getConvFlds $type $citekey $names $vals $nfld]
	
	goto $top
	nextEntry
	set hit [getEntry [getPos]]
	
	incr nbEntry
    }
    close $idout
    edit $fnameout
    set msg [format "%4.0d" $nbEntry]
    append  msg  " entries converted"
    message $msg
}

###################################################################
# converts one BibTeX entry to Refer
#			PBL

proc getConvFlds {type citekey names vals nfld} {
    global convFldBib convFldRef SpecialFld
    
    # "%0" is the entry type
    set mytext "%0 " 
    append mytext [lindex $convFldRef($type) 0]
    
    # "%F" is the entry label=citekey
    append mytext "\r%F "  
    append mytext $citekey
    append mytext "\r"
    
    # now all the other fields
    for {set ifld 2} {$ifld <$nfld} {incr ifld} {
	set mn [lindex $names $ifld]
	set vl [lindex $vals $ifld]
	if  {$vl !=""} {
	    set jfld [lsearch $convFldBib($type) $mn]
	    if {$jfld > 0} {
		set FldRef [lindex $convFldRef($type) $jfld]
		# Test if the field is a special field, if yes -> splitFld
		set kfld [lsearch $SpecialFld $FldRef]
		if {$kfld < 0} {
		    append mytext $FldRef 
		    append mytext " "
		    regsub -all " ?(\r|\n)" $vl " " vl
		    regsub -all "\t" $vl "" vl
		    append mytext $vl
		    append mytext "\r"
		} else {
		    append mytext [splitFld $FldRef $vl]
		}
		# if the field doesn't exist, the fieldname and the field itselfs
		# are saved as "Custom" with tag "%2"
	    } else {
		append mytext "%2 "
		append mytext $mn
		append mytext "="
		regsub -all " ?(\r|\n)" $vl " " vl
		regsub -all "\t" $vl "" vl
		append mytext $vl
		append mytext "\r"
	    }
	    
	}		
    }
    append mytext "\r"
    return $mytext
}

###################################################################
# if there are several authors they are split:
# example:
# author = "Herzig, H. P. and Ehbets, P."  becomes
# %A Herzig, H. P.
# %A Ehbets, P.
# 
#			PBL

proc splitFld {FldRef vl} {
    regsub -all " ?(\r|\n)" $vl " " vl
    regsub -all "\t" $vl "" vl
    set repstr "\r"
    append repstr $FldRef
    append repstr " "
    regsub -all " and " $vl $repstr vl
    set splitstr $FldRef
    append splitstr " "
    append splitstr $vl
    append splitstr "\r"
    return $splitstr
}
