## -*-Tcl-*- (nowrap)
 # ###################################################################
 #  AlphaTcl - core Tcl engine
 # 
 #  FILE: "contextual.tcl"
 #                                    created: 1/31/2001 {9:16:50 PM} 
 #                                last update: 10/05/2001 {18:38:05 PM} 
 #  Author: Jonathan Guyer
 #  E-mail: jguyer@his.com
 #    mail: Alpha Cabal
 #     www: http://www.his.com/jguyer/
 #  
 # Copyright (c) 2001 Jonathan Guyer.  All rights reserved.
 # 
 #  Description: 
 #  
 #  Rudimentary capabilities for Contextual Menus.  The arguments
 #  and meanings are prone to change.
 # 
 #  History
 # 
 #  modified   by  rev reason
 #  ---------- --- --- -----------
 #  2001-01-31 JEG 0.1 original
 # ###################################################################
 ##

alpha::extension contextual 0.1 {
    hook::register contextualMenuHook contextual::contextualMenu
    hook::register contextualMenuHook tcl::contextualMenu Tcl
} uninstall {this-file} maintainer {
    "Jon Guyer" <jguyer@his.com> <http://www.his.com/jguyer/>
} help {
    Support for Contextual Menus
} requirements {
    alpha::package require Alpha 8.0a2
}

namespace eval contextual {}


proc contextual::contextualProc {menu item} {
    alertnote $menu $item
}

proc contextual::buildContextualMenu {} {
    return [list build {} contextual::contextualProc {}]
}

proc contextual::switchWrapProc {menu item} {
    global mode
    
    wordWrapProc [lsearch [list "none" "wrap" "soft"] $item]
    
    # To force update of status bar
    displayMode $mode
}

proc contextual::switchFormatProc {menu item} {
    global mode
    
    setModeVarAlpha $item

    # To force update of status bar
    displayMode $mode
}

proc contextual::switchModeProc {menu item} {
    newMode $item
}

proc contextual::buildWindowWrap {} {
    return [list build [list "none" "wrap" "soft"] {contextual::switchWrapProc} {}]
}

proc contextual::buildWindowFormat {} {
    set ma ""
    lappend ma "Mac"
    lappend ma "UNIX"
    lappend ma "IBM"
    lappend ma "(-)"
    lappend ma "MPW"
    lappend ma "Think"
    lappend ma "None"
    lappend ma "(-)"
    lappend ma "Read Only"
    lappend ma "Show Invisibles"
    lappend ma "(-)"
    lappend ma "Tab Size"
    
    return [list build $ma {contextual::switchFormatProc -m} {}]
}

proc contextual::buildWindowMode {} {
    return [list build [mode::listAll] {contextual::switchModeProc -m} {}]
}

proc contextual::contextualMenu {menu pos selectionDesc} {
    menu::buildProc $menu contextual::buildContextualMenu
    
    menu::buildProc wrap contextual::buildWindowWrap
    menu::buildProc format contextual::buildWindowFormat
    menu::buildProc Mode contextual::buildWindowMode
    
    menu::insert $menu submenu end wrap
    menu::insert $menu submenu end format
    menu::insert $menu submenu end Mode
}

proc tcl::contextualMenu {menu pos selectionDesc} {
    menu::insert $menu items 0 "(someTclActionAt $pos" "(-)"
}


