## -*-Tcl-*-
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "elecBindings.tcl"
 #	 				  created: 24/7/97 {6:03:56 pm}	
 #	      			      last update: 07/18/2001 {11:44:09 AM}	
 #	Author:	Vince Darley
 #	E-mail:	<vince@santafe.edu>
 #	  mail:	317 Paseo de Peralta
 #           Santa Fe, NM 87501, USA
 #	   www:	<http://www.santafe.edu/~vince/>
 #	
 #	Declares all the global variables for the electric procedures,
 #	and sets up bindings, traces, so it all works.
 # ###################################################################
 ##

alpha::extension elecBindings 9.0.1 {
    ensureset electricBindings 0
    array set keys::specialProcs { 
	"Complete Or Tab" "bind::TabOrComplete"
	"Expand" "bind::Expansion"
    }
    # set up some bindings if they don't exist
    if {![info exists "keys::specialBindings(Expand)"]} {
	set "keys::specialBindings(Expand)" ""
    }
    if {![info exists "keys::specialBindings(Complete Or Tab)"]} {
	set "keys::specialBindings(Complete Or Tab)" ""
    }
    hook::register specialKeys elec::keyBindings
} maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} uninstall this-file help {file "ElecCompletions Help"}

proc elec::presetKeyBindings {set} {
    global keys::specialBindings
    switch -- $set {
	0 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" "/c"
		"Complete" "<B/c"
		"Expand" "<O/ "
		"Prev Stop" "<U/c"
		"Real Tab" "<I/c"
		"nth Stop" ""
		"Clear All Stops" "<U<B/c"
		"Next Stop" ""
		"Complete Or Tab" ""
	    }
	}
	1 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" ""
		"Complete" ""
		"Expand" "<O/ "
		"Prev Stop" "<U<B/J"
		"Real Tab" "<I/c"
		"nth Stop" "<B/c"
		"Clear All Stops" "<U<B/c"
		"Next Stop" "<B/J"
		"Complete Or Tab" "/c"
	    }
	}
	2 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" ""
		"Complete" ""
		"Expand" ""
		"Prev Stop" ""
		"Real Tab" ""
		"nth Stop" ""
		"Clear All Stops" ""
		"Next Stop" ""
		"Complete Or Tab" ""
	    }
	}
	
    }
}

proc elec::keyBindings {} {
    global electricBindings
    
    set l [list {Control-tab (invokes), tab + modifiers (moves)} \
      {Tab key (invokes), j + modifiers (moves)} \
      {A 'clean slate' to build a custom keyset}]
    set text [lindex {
	"use 'control-Tab' to invoke completions and 'Tab' (+modifiers) to move amongst template stops."
	"use 'Tab' to invoke completions and 'j' (+modifiers) to move amongst template stops."
	"are based upon a user-defined set."
    } $electricBindings]
    set b [dialog::optionMenu \
      "Special keys binding-sets:\r\rYour current key-bindings $text\
      From the pop-up below, you may make adjustments to those bindings,\
      or reset them to one of the standard sets\
      (and then make any desired adjustments)." \
      [concat [list "Adjust current set" "-"] $l] "" 1]
    
    if {$b != 0} {
	set electricBindings [incr b -1]
	elec::presetKeyBindings $electricBindings
	prefs::modified electricBindings
    }
    hook::callAll electricBindings *
    return
}


