## -*-Tcl-*- (install)
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "fileUtils.tcl"
 #					created: 01-01-17 11.43.11	
 #				    last update: 12/14/2001 {11:54:37 AM}	
 #	Author:	Vince Darley and others
 #	E-mail:	<vince@santafe.edu>
 #	  mail:	317 Paseo de Peralta
 #           Santa Fe, NM 87501, USA
 #	   www:	<http://www.santafe.edu/~vince/>
 #	
 # ###################################################################
 ##

alpha::extension fileUtils 1.2.5 {
    menu::insert winUtils items end \
      {Menu -n moreUtils -p menu::fileUtils { 
	"sortAndReplace"
	"<E<SremoveDuplicateLines"
	"<S<IkeepDuplicateLines"
	"<S<UkeepAllDuplicateLines"
	"<S<OkeepUniqueLines"
	"<S<BcountDuplicates"
	"insertModeLine"
	"stuffFile"
	"stuffOpenWindows"
	"<E<Stabs8To4" 
	"<Stabs4To8" 
    }}
} uninstall this-file maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    Creates a simple menu called 'More Utils' which adds some file/window
    related manipulations.
}

namespace eval file {}
namespace eval file::Utils {}

proc file::Utils::insertModeLine {} {
    global mode 
    placeBookmark
    goto [minPos]
    file::notTextMode
    
    insertText "-*-${mode}-*-\n"
    goto [minPos]
    comment::Line
    returnToBookmark
}

proc file::Utils::sortAndReplace {} {
    balance
    set epts [getEndpts]
    set start [lindex $epts 0]
    set end [lindex $epts 1]
    set start [pos::math $start + 1]
    set end [pos::math $end - 1]
    replaceText $start $end [lsort [getText $start $end]]
    wrapText [lineStart $start] [pos::math [nextLineStart $end] - 1]
}

proc file::Utils::removeDuplicateLines {} {file::Utils::uniq r }
proc file::Utils::keepUniqueLines {} {file::Utils::uniq u }
proc file::Utils::keepDuplicateLines {} {file::Utils::uniq d }
proc file::Utils::keepAllDuplicateLines {} {file::Utils::uniq a }
proc file::Utils::countDuplicates {} {file::Utils::uniq c }

## 
 # The meaning of the flags is unchanged :
 #     "c" count : prefix lines by the number of occurrences
 #     "r" remove : remove duplicates, leaving one exemplary
 #     "u" unique : only print unique lines
 #     "d" duplicates : only print (once) duplicate lines
 #     "a" all-duplicates : print all duplicate lines (i-e remove unique lines)
 ##
proc file::Utils::uniq {{flag r}} {
    if {[pos::compare [getPos] == [selEnd]]} {
	set pos [minPos]
	set lastpos [maxPos]
    } else {
	# We want complete lines :
	if {[lookAt [pos::math [selEnd] - 1]] != "\r"} {
	    set lastpos [nextLineStart [selEnd]]
	} else {
	    set lastpos [selEnd]
	}
	beginningOfLine
	set pos [getPos]
    }
    # Last line of the selection must be complete.
    # If it does not end with a carriage return, we add it :
    if {[lookAt [pos::math $lastpos - 1]] != "\r"} {
	goto $lastpos
	insertText "\r"
	set lastpos [pos::math $lastpos + 1]
    }
    set otext [getText $pos [nextLineStart $pos]]
    set firstpos $pos
    set inipos $pos
    set pos [nextLineStart $pos]
    set dupl 0
    switch -- $flag {
	"u" {
	    while {[pos::compare $pos < $lastpos]} {
		set ntext [getText $pos [nextLineStart $pos]]
		if { $ntext != $otext } {
		    if {$dupl} {
			deleteText $inipos $pos
			set dupl 0
			set lastpos [pos::math $lastpos + $inipos - $pos]
		    } else {
			set inipos $pos
		    }
		    set otext $ntext
		    set pos [nextLineStart $inipos]
		} else {
		    set dupl 1
		    set pos [nextLineStart $pos]
		}
	    }
	    # Now we take care of the last line
	    if {$dupl} {
		deleteText $inipos $pos
	    }
	}
	"d" {
	    while {[pos::compare $pos < $lastpos]} {
		set ntext [getText $pos [nextLineStart $pos]]
		if { $ntext != $otext } {
		    if {$dupl} {
			set lastpos [pos::math $lastpos + [nextLineStart $inipos] - $pos]
			deleteText [nextLineStart $inipos] $pos
			set dupl 0
			set inipos [nextLineStart $inipos]
		    } else {
			deleteText $inipos $pos
			set lastpos [pos::math $lastpos + $inipos - $pos]
		    }
		    set otext $ntext
		    set pos [nextLineStart $inipos]
		} else {
		    set dupl 1
		    set pos [nextLineStart $pos]
		}
	    }
	    # Now we take care of the last line
	    if {$dupl} {
		deleteText [nextLineStart $inipos] $pos
	    } else {
		deleteText $inipos $pos
	    }
	}
	"a" {
	    while {[pos::compare $pos < $lastpos]} {
		set ntext [getText $pos [nextLineStart $pos]]
		if { $ntext != $otext } {
		    if {$dupl} {
			set dupl 0
			set inipos $pos
		    } else {
			deleteText $inipos $pos
			set lastpos [pos::math $lastpos + $inipos - $pos]
		    }
		    set otext $ntext
		    set pos [nextLineStart $inipos]
		} else {
		    set dupl 1
		    set pos [nextLineStart $pos]
		}
	    }
	    # Now we take care of the last line
	    if {!$dupl} {
		deleteText $inipos $pos
	    }
	}
	"c" {
	    set count 1
	    while {[pos::compare $pos < $lastpos]} {
		set ntext [getText $pos [nextLineStart $pos]]
		if { $ntext != $otext } {
		    if {$dupl} {
			set lastpos [pos::math $lastpos + [nextLineStart $inipos] - $pos]
			deleteText [nextLineStart $inipos] $pos
			set dupl 0
		    }
		    goto $inipos
		    insertText "\t$count\t"
		    set lastpos [pos::math $lastpos + [string length $count] + 2]
		    set inipos [nextLineStart $inipos]
		    set otext $ntext
		    set pos [nextLineStart $inipos]
		    set count 1
		} else {
		    set dupl 1
		    set count [incr count]
		    set pos [nextLineStart $pos]
		}
	    }
	    # Now we take care of the last line
	    if {$dupl} {
		deleteText [nextLineStart $inipos] $pos
	    }
	    goto $inipos
	    insertText "\t$count\t"
	}
	"r" {
	    while {[pos::compare $pos < $lastpos]} {
		set ntext [getText $pos [nextLineStart $pos]]
		if { $otext == $ntext } {
		    select $pos [nextLineStart $pos]
		    set lastpos [pos::math $lastpos - [nextLineStart $pos] + $pos]
		    deleteText $pos [nextLineStart $pos]
		} else {
		    select $pos [nextLineStart $pos]
		    set pos [nextLineStart $pos]
		    set otext $ntext
		}
	    }
	}
    }
    goto $firstpos
}

proc file::Utils::getAllFileWindows {} {
    set files {}
    foreach f [winNames -f] {
	if {[file exists $f]} { 
	    lappend files $f 
	} elseif {[file exists [win::StripCount $f]]} {
	    lappend files [win::StripCount $f]
	}
    }
    return $files
}

proc file::Utils::stuffFile {} {
    app::launchBack DStf
    sendOpenEvent noReply 'DStf' [win::Current]
    sendQuitEvent 'DStf'
} 

proc file::Utils::stuffOpenWindows {} {
    app::launchFore DStf
    eval sendOpenEvents 'DStf' [file::Utils::getAllFileWindows]
    sendQuitEvent 'DStf'
}

proc file::Utils::tabs8To4 {} {
    set fname [win::Current]
    setWinInfo tabsize 8
    select [minPos] [maxPos]
    tabsToSpaces
    setWinInfo tabsize 4
    select [minPos] [maxPos]
    spacesToTabs		
    
}

proc file::Utils::tabs4To8 {} {
    set fname [win::Current]
    setWinInfo tabsize 4
    select [minPos] [maxPos]
    tabsToSpaces
    setWinInfo tabsize 8
    select [minPos] [maxPos]
    spacesToTabs		
    
}


