## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "filesetEncodingPreference.tcl"
 #                                    created: 05/09/2000 {19:34:19 PM} 
 #                                last update: 07/25/2001 {15:34:50 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #          317 Paseo de Peralta
 #     www: http://www.santafe.edu/~vince/
 #  
 # Copyright (c) 2000-2001 Vince Darley
 # 
 # Distributable under Tcl-style (free) license.
 # ###################################################################
 ##

alpha::extension filesetEncodingPreference 0.1a2 {
    # Attach 'encoding' preference to each fileset
    fileset::attachNewInformation "" variable "Encoding" "" \
      "If you enter anything here, it is used as the default encoding\
      for any files opened which are in this fileset.  The default\
      may be overridden by other considerations."
    hook::register fileset-file-opening fileset::checkEncodingPreference
} requirements {
    if {[info tclversion] < 8.1} {
	error "filesetEncodingPreference requires Tcl 8.1 or newer;\
	  you have [info tclversion]"
    }
} help {
    Can be used to ensure a given fileset is opened with a particular
    default encoding, different to that set as a global default.
    
    This only works with Alphatk at present.  Alpha 8 has yet to be
    updated for use with different encodings.
}

namespace eval fileset {}

proc fileset::checkEncodingPreference {fset name} {
    set fsetEncoding [fileset::getInformation $fset "Encoding"]
    if {[string length $fsetEncoding]} {
	global ::alpha::encoding
	set alpha::encoding $fsetEncoding
    }
}
