## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "filesetFtpMirror.tcl"
 #                                    created: 02/23/2001 {21:16:18 PM} 
 #                                last update: 03/30/2001 {20:31:21 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #          317 Paseo de Peralta
 #     www: http://www.santafe.edu/~vince/
 #  
 # Copyright (c) 2001 Vince Darley
 # 
 # Distributable under Tcl-style (free) license.
 # ###################################################################
 ##

alpha::extension filesetFtpMirror 0.1.1 {
    # Add the preferences as a group to filesets which want them
    fileset::attachNewInformationGroup "Fileset Ftp Mirror" "" \
     [list variable "Ftp server" "" "Server to upload files to."] \
     [list variable "User ID" "" "User name with access to above server."] \
     [list password "Password" "" "Password for above user name."] \
     [list variable "Directory" "" "Directory on the server."]
   
   set "filesetUtils(updateFilesetMirror)" [list * fileset::updateMirror]
} help {
    Can be used to mirror a given fileset onto an ftp site.  This works
    very simply.  Once this package is activated, you should attach the
   'Fileset Ftp Mirror' information group to any fileset which you would
   like to mirror.  Then enter the required server/username information.
   
   Now, whenever you would like to mirror the files, select 
   'Update Fileset Mirror' in the Fileset utilities menu, and you will
   be given a variety of options for which files to upload.
}

namespace eval fileset {}

proc fileset::updateMirror {{fset ""}} {
    set fset [pickFileset $fset "Fileset to upload" \
      [list "withinfo" "Fileset Ftp Mirror"]]
    if {![string length $fset]} { 
	message "No fileset is available for mirroring.  You should attach\
	  'Fileset Ftp Mirror' information to the filesets you want"
	return 
    }
    # Got the fileset, now need the ftp information
    foreach var [list "Ftp server" "User ID" "Password" "Directory"] {
	lappend spec [fileset::getInformation $fset $var]
    }
    # Now upload, using ftpMirrorHierarchy
    eval [list ftpMirrorHierarchy [fileset::getBaseDirectory $fset]] $spec
}
