## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "filesetTabPreference.tcl"
 #                                    created: 05/09/2000 {19:34:19 PM} 
 #                                last update: 11/27/2000 {16:28:08 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #          317 Paseo de Peralta
 #     www: http://www.santafe.edu/~vince/
 #  
 # Copyright (c) 2000 Vince Darley
 # 
 # Distributable under Tcl-style (free) license.
 # ###################################################################
 ##

alpha::extension filesetTabPreference 0.1a4 {
    # Attach 'tab size' preference to each fileset
    fileset::attachNewInformation "" variable "Tab Size" "" \
      "If you enter anything here, it is used as the default tab\
      size for any files opened which are in this fileset.  The default\
      may be overridden by other considerations."
    hook::register fileset-file-opening fileset::checkTabPreference
} help {
    Can be used to ensure a given fileset is opened with a particular
    default tab size, different to that set as a global default.
}

namespace eval fileset {}

proc fileset::checkTabPreference {fset name} {
    set fsetTabSize [fileset::getInformation $fset "Tab Size"]
    if {[string length $fsetTabSize]} {
	win::setInitialConfig $name tabsize $fsetTabSize
    }
}
