## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "functionComments.tcl"
 #                                    created: 27/10/1999 {8:15:22 pm} 
 #                                last update: 03/23/2001 {21:19:00 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley.
 # 
 # Distributed under a Tcl style license.  This package is not
 # actively improved any more, so if you wish to make improvements,
 # feel free to take it over.
 # 
 # ###################################################################
 ##

alpha::extension functionComments 0.1.2 {
    # for 'user'
    alpha::package require documentProjects 1.7.1
    alpha::package require AlphaTcl 7.2.2fc7
    
    if {[package::active electricMenu]} {
	menu::insert elec items end \
	  {Menu -n FunctionComments -p menu::generalProc {
	    "/eusual"	
	    "/e<Isimple" 
	    "/e<OwithAuthor" 
	    "/e<Uupdate" 
	}}
	hook::register requireOpenWindowsHook [list -m $electricMenu FunctionComments] 1
    } else {
	menu::insert winUtils items end \
	  {Menu -n FunctionComments -p menu::generalProc {
	    "/eusual"	
	    "/e<Isimple" 
	    "/e<OwithAuthor" 
	    "/e<Uupdate" 
	}}
	hook::register requireOpenWindowsHook [list winUtils FunctionComments] 1
    }
} maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} uninstall {this-file} help {
    Provides capability to insert nice comments for any given
    function definition.
}

namespace eval functioncomments {}

## 
 # ----------------------------------------------------------------------
 #	 
 #	"file::functionComment" --
 #	
 #  This procedure generates a nice little comment box like this one here.
 #	
 #   Results:
 #  Well it doesn't return anything, but it allows you to enter each item
 #  simply, moving from one to the next with Tab
 #	
 #   Side effects:
 #  Not much
 #	
 # ----------------------------------------------------------------------
 ##
proc functioncomments::usual { {simple ""} {author 0} } {
    global user
    if {![string length [getSelect]]} {
	select [lineStart [getPos]] [nextLineStart [getPos]]
    }
    
    # Changed 6/22/2000 by John Seal to include argument descriptions.
    
    # Selection should now include entire proc header, possibly even
    # including the word "proc" and the opening brace of the body.
    # That way you can usually just triple-click the definition line.
    
    # Strip trailing brace and leading "proc" if necessary.
    set defn [string trimright [getSelect] " \t\n\{"]
    if {[string match "proc *" $defn]} {
	set defn [string trimleft [string range $defn 5 end]]
    }
    # Extract function name and argument list.
    scan $defn "%s" fn
    set n [string length $fn]
    set defn [lindex [string range $defn $n end] 0]

    beginningOfLine
    set t "-------------------------------------------------------------------------\r"
    append t "\r"
    append t "\"$fn\" --\r"
    append t "\r description\r"
    if { $simple != "simple" } {
	# Insert argument description header
	append t "\rArgument     Default In/Out Description"
	append t "\r------------ ------- ------ ---------------------------------------------\r"
	# Insert description of each argument.
	foreach arg $defn {
	    append t [format "%-12s " [lindex $arg 0]]
	    set default [lindex $arg 1]
	    # Default values of "" need special treatment.
	    if {([llength $arg] > 1) && ($default == "")} {set default "\"\""}
	    # Arguments are usually "In" only so assume that.
	    append t [format "%-7s In     description\r" $default]
	}
	append t "\rResults:\r results\r\rSide effects:\r side effects\r"
    }
    if {$author} {
	append t "\r--Version--Author------------------Changes-------------------------------"
	append t "\r   1.0     $user(email) original\r"
    }
    append t "-------------------------------------------------------------------------"
    set t [comment::TextBlock $t]
    elec::CenterInsertion $t
}

proc functioncomments::simple {} { return [functioncomments::usual simple 0]}
proc functioncomments::withAuthor {} { return [functioncomments::usual "" 1] }


## 
 # -------------------------------------------------------------------------
 #	 
 #	"file::functionCommentUpdate" --
 #	
 #  Handles updating of a version line like the one below
 #	
 # --Version--Author------------------Changes-------------------------------  
 #    1.0     <vince@santafe.edu> original
 #    1.1     <vince@santafe.edu> quickly updated with shift-F1
 # -------------------------------------------------------------------------
 ##
proc functioncomments::update {} {
    global user
    set begin [lindex [comment::Characters Paragraph] 2]
    goto [file::findLocally "${begin}--Version--Author"]
    goto [nextLineStart [nextLineStart [getPos] ]]
    goto [file::findLocally "${begin}-------"]
    elec::Insertion "${begin}   Version     $user(email) Changes\r"
}
