## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "httpHandler.tcl"
 #                                    created: 23/9/97 {1:58:27 pm} 
 #                                last update: 09/08/2001 {18:12:00 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #           Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::extension httpHandler 0.1 {
    eventHandler GURL GURL GURLHandler
} help {
    Handle "GetURL" AppleEvents passed to Alpha.
}
	
proc httpGURLhandler {what} {
    global PREFS HOME
    set httpDir ${PREFS}:httptmp
    if {![file exists $httpDir]} {
	mkdir $httpDir
    }
    set tools ${HOME}:Tools
    regexp {[^/:]*.$} $what local
    set i 0
    while {[file exists ${tools}:tmp$i]} {incr i}
    set f ${tools}:tmp$i
    set fout [open $f w]
    puts $fout "Http_Copy http:${what} $httpDir:$local"
    puts $fout "return {httpHandled http:${what} $httpDir:$local}"
    close $fout
    # now open the file with Genii
    sendOpenEvent noReply [nameFromAppl Geni] $f
}

proc httpHandled {url local} {
    alertnote "Downloaded $url into $local"
}
