## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions --- an extension package for Alpha
 # 
 #  FILE: "latexMathbb.tcl"
 #                                    created: 26/1/98 {3:12:38 pm} 
 #                                last update: 03/23/2001 {21:24:31 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1998-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # Distributable under Tcl-style (free) license.
 #  
 # ###################################################################
 ##

# extension declaration
alpha::feature latexMathbb 1.01 {TeX Bib} {
    newPref variable blackboardBoldSymbols "QZRN" TeX TeX::adjustMathbb
    hook::register mode::init TeX::adjustMathbb TeX
} "" "" maintainer {
    {Vince Darley} <vince@santafe.edu> <http://www.santafe.edu/~vince/>
} help {
    Turns 'ZZ' into $\mathbb{Z}$ on the fly, and the same for any
    other symbols in your blackboardBoldSymbols preference.
} uninstall this-file

proc TeX::adjustMathbb {args} {
    global TeXmodeVars
    foreach symb [split $TeXmodeVars(blackboardBoldSymbols) ""] {
	Bind '[string tolower $symb]' <s> [list TeX::checkMathbb $symb] TeX
    }
}

proc TeX::checkMathbb {symb} {
    if {[lookAt [pos::math [getPos] - 1]] != $symb} { typeText $symb ; return }
    select [pos::math [getPos] - 1] [getPos]
    doUppercaseMathStyle mathbb "math blackboard bold"
}

