## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "newDocument.tcl"
 #                                    created: 18/9/97 {4:47:39 pm} 
 #                                last update: 11/05/2001 {17:55:54 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #           Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #   
 # Any package can declare a new type of document to be added to the pop-up
 # list simply by adding to the 'newDocTypes' array, as in
 # 
 # set {newDocTypes(New LaTeX Doc)} newLaTeXDocument
 # 
 # Modes can include such a statement in their alpha::mode initialization
 # argument if they want such an option to be available even if the mode
 # has not yet been loaded.
 # 
 # Copyright (c) 1997-2001  Vince Darley.
 # 
 # Distributed under a Tcl style license.  This package is not actively
 # improved any more, so if you wish to make improvements, feel free to
 # take it over.
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::feature newDocument 0.1.3 "global-only" {
    # Initialization script.
    namespace eval newDocument {}
    set newDocument::handlers(Alpha) new
    # The handler of new documents.  'Alpha' simply creates a new window, other
    # packages (such as Document Projects) have more sophisticated options.
    newPref var newDocumentHandler "Alpha" newDocument "" \
      newDocument::handlers array
    # Open untitled windows directly without asking for templates etc.
    newPref flag untitledDocsAreEmpty 1 newDocument
    # Prompt for the name of new documents, presenting additional options.
    newPref flag newDocNamePrompt 1 newDocument
    
    ensureset {newDocTypes(New File-set)}           newFileset
} {
    # Activation script.
    package::addPrefsDialog newDocument
    menu::replaceWith File "/Nnew" items "/NnewDocument"
} {
    # De-activation script.
    menu::replaceWith File "/NnewDocument" items "/Nnew"
} uninstall {
    this-file
} maintainer {
    "Vince Darley" <vince@santafe.edu> <http://www.santafe.edu/~vince/>
} help {
    This package replaces the 'File --> New...'  menu item with one named
    'New Document...'.  allowing one to select from a preset list of
    options (such as creating a new e-mail message, or inserting a template
    for a new HTML or LaTeX document.)
}

proc file::newDocument {args} {
    global newDocTypes newDocumentmodeVars newDocument::handlers
    if {$args == "" && $newDocumentmodeVars(newDocNamePrompt)} {
	if {[catch {set args [eval [list prompt "Please enter a name for the new document window" \
	  "untitled" "Or open:"] \
	  "untitled" "\(-" [lsort -ignore [array names newDocTypes]]]}]} {
	    return
	}
	if {[info exists newDocTypes($args)]} {
	    eval $newDocTypes($args)
	    return ""
	}
	if {$args == "untitled"} {
	    if {$newDocumentmodeVars(untitledDocsAreEmpty)} {
		new
		return
	    }
	    set args ""
	} else {
	    set args [list "-n" $args] 
	}
    }
    set handler [set newDocument::handlers($newDocumentmodeVars(newDocumentHandler))]
    if {[catch {eval $handler $args}]} {
	if {[info commands $handler] == ""} {
	    alertnote "Your new document handler was poorly set.  I'll reset it."
	    # handler poortly set
	    set newDocumentmodeVars(newDocumentHandler) Alpha
	    prefs::modified newDocumentmodeVars(newDocumentHandler)
	    eval new $args
	} else {
	    alertnote "Your new document handler '$handler' caused an error."
	}
    }
    return ""
}
