## -*-Tcl-*- (auto-install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "notes.tcl"
 #                                    created: 09/18/1997 {04:33:31 pm} 
 #                                last update: 09/19/2001 {12:54:33 am} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta
 #           Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 #  Includes contributions from Craig Barton Upright
 #  
 # Copyright (c) 1997-2001  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::feature notes 0.2 "global-only" {
    # Initialization script.
    # Declare some Notes prefs, add a preference to the "Misc" page.

    # All files in the 'Notes' folder can be opened with Alpha is first
    # started, or opened but iconified.
    newPref var   openNotesOnStartup 0 "global" "" [list \
      "Never" "Always" "Always, but iconified" "Always, Shrunk High" \
      "Always, Shrunk Right" "Always, Tiled"] index
    alpha::addToPreferencePage Packages openNotesOnStartup
    # Make sure that we have a directory for the notes.
    if {![file exists [file join $PREFS Notes]]} { 
	file mkdir [file join $PREFS Notes] 
    }
    # Declare a build proc for the Notes menu.
    menu::buildProc notes notes::buildMenu
    # Declare a new item for the 'New Document' package.
    set {newDocTypes(New Note)} [list notes::menuProc "" "New Note"]
    # Startup Hook
    hook::register startupHook notes::startupHook
} {
    # Activation script.
    menu::insert File submenu 0 notes
} {
    # Deactivation script.
    menu::uninsert File submenu 0 notes
} uninstall {
    this-file
} help {
    The 'Notes' package inserts a new submenu into the 'Files' menu, which
    allows you to manage a set a notes retained in your preferences folder. 
    The 'Open Notes On Startup' preference, which can be set using the menu
    item "Config --> Packages --> Miscellaneous Packages", allows you to
    automatically open these notes whenever Alpha is launched.
}


namespace eval notes {}

proc notes::startupHook {} {

    global openNotesOnStartup PREFS

    if {!$openNotesOnStartup} {return}
    foreach noteFile [notes::listNoteFiles] {
	file::openQuietly [file join $PREFS Notes $noteFile]
	if {$openNotesOnStartup == "2"} {
	    icon -t
	} elseif {$openNotesOnStartup == "3"} {
	    shrinkHigh
	} elseif {$openNotesOnStartup == "4"} {
	    shrinkRight	    
	}
    } 
    if {$openNotesOnStartup == "5"} {wintiled} 
}

proc notes::listNoteFiles {} {

    global PREFS backupExtension

    set noteList [list ]
    set noteFiles [glob -nocomplain -dir [file join $PREFS Notes] -- *]
    foreach noteFile $noteFiles {
	if {[regexp "${backupExtension}\$" $noteFile]} {continue}
	lappend noteList "[file tail $noteFile]"
    }
    return [lsort -ignore $noteList]
}

proc notes::buildMenu {} {

    if {[llength [set noteFiles [notes::listNoteFiles]]]} {
	foreach noteFile $noteFiles {lappend menuList "$noteFile&"}
	lappend menuList "(-)" "New Note" "Rename Note" "Delete Note"
    } else {
	set menuList [list "New Note"]
    }
    return [list build $menuList "notes::menuProc -m"]
}

proc notes::menuProc {menuName itemName} {
    
    global PREFS backupExtension
    
    switch $itemName {
	"New Note" {
	    set newNote ""
	    set p       "New Note Name:"
	    while {![string length $newNote]} {
		if {[catch {prompt $p ""} newNote]} {
		    status::errorMsg "Cancelled."
		} 
		set p "You must enter a name:"
	    }
	    set newNote [file join $PREFS Notes $newNote]
	    if {[catch {file::openQuietly $newNote}]} {
		close [open $newNote "w"]
		edit $newNote
		menu::buildSome notes
	    }
	}
	"Rename Note" {
	    set p1    "Select a note to rename:" 
	    set notes [notes::listNoteFiles]
	    while {![catch {listpick -p $p1 $notes} res]} {
		if {![llength $res]} {status::errorMsg "Cancelled."}
		set p2 "New name for '$res'"
		if {[catch {prompt $p2 $res} newName] || $newName == ""} {
		    status::errorMsg "Cancelled."
		    break
		} 
		set oldNote [file join $PREFS Notes $res]
		set newNote [file join $PREFS Notes $newName]
		set reOpen  0
		if {[file exists $newNote]} {
		    alertnote "'$newName' is already a note."
		    continue
		} elseif {![file exists $oldNote]} {
		    dialog::errorAlert "Couldn't find '$res' !!"
		} elseif {![catch {bringToFront $oldNote}]} {
		    killWindow
		    set reOpen 1
		}
		# Now we move the note.
		if {[file exists $oldNote]} {
		    file copy $oldNote ${newNote}
		    file delete $oldNote
		} 
		# Make sure that we transfer the backups as well.
		set oldNote ${oldNote}${backupExtension}
		if {[file exists $oldNote]} {
		    file copy $oldNote ${newNote}${backupExtension}
		    file delete $oldNote
		} 
		if {$reOpen} {file::openQuietly $newNote}
		set notes [notes::listNoteFiles]
		menu::buildSome notes
		status::msg "'$res' has been renamed '$newName'."
		set p1 "Select another, or press cancel:" 
	    }
	}
	"Delete Note" {
	    set noteFiles [notes::listNoteFiles]
	    if {[catch {listpick -l -p "Delete which notes?" $noteFiles} results]} {
	        status::errorMsg "Cancelled."
	    } 
	    foreach noteFile $results {
		lappend results ${noteFile}${backupExtension}
	    }
	    foreach noteFile $results {
		if {![catch {bringToFront $noteFile}]} {
		    set question "'$noteFile' is an open window.  Delete it anyway?"
		    if {[askyesno $question] == "no"} {continue}
		    setWinInfo dirty 0
		    killWindow
		} 
		catch {file delete [file join $PREFS Notes $noteFile]}
		if {![regexp "${backupExtension}\$" $noteFile]} {
		    lappend deletedNotes $noteFile
		} 
	    }
	    menu::buildSome notes
	    if {![info exists deletedNotes]} {return}
	    if {[llength $deletedNotes] == "1"} {
	        status::msg "'[lindex $deletedNotes 0]' has been deleted."
	    } else {
		status::msg "$deletedNotes have been deleted."
	    }
	}
	"Rebuild Menu" {
	    menu::buildSome notes
	    status::msg "The 'Notes' menu has been rebuilt."
	}
	default {
	    if {[file exists [file join $PREFS Notes $itemName]]} {
		file::openQuietly [file join $PREFS Notes $itemName]
		bringToFront $itemName
		if {[icon -q]} {icon -o} 
	    } elseif {[dialog::yesno "Couldn't find '$itemName'.  Rebuild menu?"]} {
		menu::buildSome notes
	    } else {
		status::msg "Couldn't find '$itemName'."
	    }
	}
    }
}

# This only works kindof sortof, and not very well with Alphatk.
# The pref would go in the package declaration above.

# # To always iconify notes when they are put in the background, turn this
# # item on||To disable the automatic iconification of notes when they
# # are put in the background, turn this item off
# newPref flag  alwaysIconifyNotes 0 "global"    
# 
# hook::register deactivateHook notes::deactivate
# 
# proc notes::deactivate {name} {
#     
#     global alwaysIconifyNotes PREFS
# 
#     if {!$notesmodeVars(alwaysIconifyNotes)} {return}
#     if {[file::pathStartsWith $name [file join $PREFS Notes]]} {
# 	if {![icon -q]} {icon -t}
#     }
# }

