## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "printerChoices.tcl"
 #                                    created: 13/9/97 {2:30:36 pm} 
 #                                last update: 07/18/2001 {11:44:23 AM} 
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # Description:
 # 
 # This package converts the basic 'Print' menu item into a sub-menu
 # from which the user can select a variety of printing methods.
 # This used to be part of standard Alpha, but it seemed a good
 # candidate to split off into a package.
 # ###################################################################
 ##

alpha::extension printerChoicesMenu 0.2 {
    menu::buildProc print setupPrintMenu
    menu::replaceWith File "/P<Sprint" submenu print
} help {
    This package converts the basic 'Print' menu item into a
    sub-menu from which the user can select a variety of printing
    methods.  This used to be part of standard Alpha, but it seemed
    a good candidate to split off into a package.
}
    

newPref var defaultPrinter "Alpha" global setupPrintMenu \
  {Alpha Kodex Enscriptor {DropPS} PrettyC}
lunion varPrefs(Printer) defaultPrinter

proc setupPrintMenu {args} {
    global defaultPrinter 
    set m [list {/P<SPrint} {/P<S<I<OPrint All} "\(-" \
      Alpha Kodex Enscriptor {DropPS} PrettyC]
    Menu -m -n print -p menu::print $m
    
    foreach item $m {
	if {$item == $defaultPrinter} {
	    markMenuItem -m print $item on
	} else {
	    markMenuItem -m print $item off
	}
    }
}

proc menu::print {menu item} {
    global defaultPrinter
    switch -glob $item {
	"Print All"	{	
	    if {$defaultPrinter == "Alpha"} {
		printAll
	    } else {
		foreach f [winNames -f] {
		    printFile $f
		}
	    }
	}
	"Print"	{
	    printFile [win::Current]
	}
	default {
	    set defaultPrinter $item
	    prefs::modified defaultPrinter
	    setupPrintMenu
	}
    }
}

proc printFile {fname} {
    global defaultPrinter
    
    switch -glob $defaultPrinter {
	"Alpha"			{print}
	"Kodex*"		{openAndSendFile KoDX}
	"Enscr*"		{openAndSendFile Ens3}
	"Drop*"			{openAndSendFile {DPS}}
	"Pret*"			{openAndSendFile niCe}
    }
}

