## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "rememberWindows.tcl"
 #                                    created: 09/11/2000 {11:13:30 AM} 
 #                                last update: 11/02/2001 {22:17:37 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # Only really useful for Alphatk, since Alpha has this functionality
 # built in through resource forks provided by MacOS.  Therefore this
 # file requires Tcl 8.x.  It may eventually be useful for Alpha as well,
 # when editing files on volumes that don't support resource forks.
 # 
 # Currently, cursor position, selection and first line displayed in
 # window are saved.
 # 
 # Future: window size, shape, and even the marks/colours, or encoding
 # could be saved.  i.e. we could implement a general sort of 'resource
 # fork' mechanism for files without any.
 # 
 # ###################################################################
 ##

alpha::feature rememberWindows 0.1a4 global {
    namespace eval rememberWindows {}
    prefs::updateHome rememberWindows::memory name
} {
    hook::register preCloseHook rememberWindows::Close
    hook::register openHook rememberWindows::Open
} {
    hook::deregister preCloseHook rememberWindows::Close
    hook::deregister openHook rememberWindows::Open
} help {
    Records information about all windows when they close,
    so that on next opening the cursor position, selection, 
    etc. can be restored.
    
    Only useful for Alphatk since Alpha already does this!
} uninstall this-file maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} requirements {
    alpha::package require Alpha 8.0d1
}

namespace eval rememberWindows {}

proc rememberWindows::Close {name} {
    if {![win::IsFile $name]} { return }
    variable memory
    getWinInfo -w $name arr
    set stripped [win::StripCount $name]
    set memory($stripped) [list [getPos -w $name] [selEnd -w $name] $arr(currline)]
    prefs::modified rememberWindows::memory($stripped)
}

proc rememberWindows::Open {name} {
    variable memory
    set stripped [win::StripCount $name]
    if {[info exists memory($stripped)]} {
	goto [lindex $memory($stripped) 0]
	eval select [lrange $memory($stripped) 0 1]
	set currline [lindex $memory($stripped) 2]
	if {$currline != ""} {
	    display [rowColToPos $currline 0]
	}
    }
}
