## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "smartPaste.tcl"
 #                                    created: 7/10/97 {2:50:59 pm} 
 #                                last update: 09/03/2001 {12:33:30 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # Distributable under Tcl-style (free) license.
 # ###################################################################
 ##

# extension declaration
alpha::feature smartPaste 0.5.1 global {
    namespace eval smartPaste {}
} {
    smartPaste_onoff 1
} {
    smartPaste_onoff 0
} maintainer {
    {Vince Darley} <vince@santafe.edu> <http://www.santafe.edu/~vince/>
} help {
    When pasting into supported modes, the pasted text is automatically
    indented to the correct indentation level.  Your mode needs a 
    '<mode>::correctIndentation' procedure to use this feature.
} uninstall this-file

# Turn smart paste on or off.  With a correctly written copy-ring,
# this code doesn't actually care whether copy ring is used or not.
proc smartPaste_onoff {on} {
    if {$on} {
	if {[info commands alpha::_paste] != ""} {return}
	rename paste alpha::_paste
	;proc paste {} "smartPaste::paste"
    } else {
	if {[info commands alpha::_paste] == ""} {return}
	rename paste {}
	rename alpha::_paste paste
    }
}

## 
 # 
 # "smartPaste::paste" --
 # 
 #  If a mode has the <mode>::correctIndentation proc, then give that proc
 #  a position in the current file (where pasting will occur) together with
 #  the first non-whitespace characters to be pasted.  That proc should
 #  return a number indicating the number of characters to indent.
 # 
 # Results:
 #  none
 # 
 # Side effects:
 #  text is pasted into the window.  IF THE mode::correctIndentation proc
 #  fails with an error, this proc will DO NOTHING AT ALL.  That is a bug
 #  in the mode procedure, not in this one.
 # 
 ##
proc smartPaste::paste {} {
    if {![regexp -- "^(\[ \t\r\n\]*)(\[^ \t\r\n\]+)" \
      [getScrap] "" white next]} {
	return [alpha::_paste]
    }
    if {[string trim [getText [lineStart [getPos]] [getPos]]] != ""} {
	return [alpha::_paste]
    }
    if {[set p [mode::getProc correctIndentation]] == ""} {
	return [alpha::_paste]
    }
    # find correct indentation of line to be pasted
    # this requires <mode>::correctIndentation
    set lwhite [$p [getPos] $next]
    # turn scrap indentation into spaces
    set white [string length [text::maxSpaceForm \
      [lindex [split $white "\r\n"] end]]]
    # if it's the same level as what should be there, let alpha handle it
    set end [selEnd]
    if {$white == $lwhite} { 
	if {[pos::compare [set p [lineStart [getPos]]] != [getPos]]} {
	    set diff [pos::diff $p [getPos]]
	    set end [pos::math $end - $diff]
	    deleteText $p [getPos]
	}
    }
    set scrap [text::indentBy [getScrap] [expr {$lwhite - $white}]]
    
    # If we didn't care about copyRing, we could use
    # 'replaceText [set p [lineStart [getPos]]] $end $scrap'
    # but we do, so we have to really do a 'paste'.
    set _scrap [getScrap]
    putScrap $scrap
    select [set p [lineStart [getPos]]] $end
    alpha::_paste
    putScrap $_scrap
    # goto [pos::math $p + [string length $scrap]]
    return
}
