## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "smarterSource.tcl"
 #                                    created: 18/10/95 {6:00:07 pm} 
 #                                last update: 10/11/2001 {17:30:30 PM} 
 #  
 #  Files in PREFS are passed through unchanged.  Simplified proc.
 #  Interacts ok with package rebuilding.
 # ##################################################################
 ##

## 
 # VMD May'95-Oct'97: <vince@santafe.edu>
 # 
 # Changed default directory to the the alpha preferences directory. 
 # Changed extension to '+' rather than 'bullet' (option-8) because of
 # ascii transmission problems - lots of people have a non-working version
 # of this file.
 # 
 # Passes through 'tclIndex(x)' and 'prefs.tcl' unchanged.
 # 
 # Renamed this file to 'smarterSource.tcl', originally just to
 # differentiate it from the old crippled versions.
 # 
 # IMPORTANT: Fixed the script so that it works with path names containing
 # spaces.  Changed all 'uplevel #0' to 'uplevel 1'.
 # 
 ##

#############################################################################
# BASED UPON 'smartSource.tcl':
#
# Copyright 1994, Robert Browning (osiris@cs.utexas.edu): This code is made 
# freely available to anyone who can find a use for it. Consider it part of my
# thanks to all those who have contributed to the freeware and shareware base.
# (Especially Pete Keheler, without which this code would be pretty useless).
# 
# === Modifications by Vince, May 1995 ===
# 
#############################################################################

alpha::extension smarterSource 0.1.5 {
if {![string length [info commands __ssource]]} {

lunion varPrefs(Files) tclExtensionsFolder
# location in which smarterSource looks for extension files
newPref earlyfolder tclExtensionsFolder "$PREFS"
prefs::updateHome tclExtensionsFolder
if {$tclExtensionsFolder != $PREFS} {
    if {![file exists $tclExtensionsFolder]} {
	alertnote "The 'Tcl Extensions Folder' \"$tclExtensionsFolder\"\
	  you set for the Smarter Source extension doesn't appear to exist."
    }
}

    rename source __ssource
}
;proc source {args} {
    global tclExtensionsFolder PREFS

    set filename [lindex $args 0]
    if {[llength $args] > 1 && [lsearch -exact {-rsrc -rsrcid} $filename] != -1} {
	return [uplevel 1 __ssource $args]
    }

    set justName [file tail "$filename"]
    # we don't want to over-ride these files
    if { [lsearch -exact {tclIndex tclIndexx prefs.tcl} $justName] != -1 \
      || [string match [file join ${PREFS} *${justName}] $filename] } {
	return [uplevel 1 [list __ssource $filename]] 
    }
    
    set overrideFile [file join ${tclExtensionsFolder} ${justName}]
    if {[file exists $overrideFile]} {
	set returnVal [uplevel 1 [list __ssource $overrideFile]]
    } else {
	set returnVal [uplevel 1 [list __ssource $filename]]
    }
    
    set extensionFiles [glob -nocomplain -path "[file root $overrideFile]+" \
      "*[file extension ${justName}]"]
    
    foreach extensionFile $extensionFiles {
	set returnVal [uplevel 1 [list __ssource $extensionFile]]
    }
    return "$returnVal" 
}
# end package block
} help {
    This package implements a replacement source command. It is intended to help
    make the process of augmenting Alpha's code base with your own changes less
    awkward, especially in the face of program updates. It also makes it so
    that you no longer have to source files containing procedures that you want
    to override in your global prefs.tcl file.
	
    Activating this package creates a new "Tcl Extensions Folder"
    preference, which is initially set to your Alpha Preferences folder.
    The "Config --> Prefererences --> Files" menu item allows you to set
    a different folder.

    Basically, you designate a directory to contain your files. Then
    any time Alpha is instructed to source a file named filename.tcl, it will
    first look in the directory you have designated, and if there is a file of
    the identical name there (i.e. filename.extension) it will source that file
    instead of the original one specified. If there are any files named
    filename+*.extension it will source those in the order returned by glob after
    either the original filename.extension or the replacement has been sourced.
	
    For example, if your TclExtensions directory contains files named
    latex+1.tcl and latex+2.tcl, then whenever you try to open a latex file
    Alpha will first source the standard latex.tcl file, then latex+1.tcl, then
    latex+2.tcl. If there was also a file named latex.tcl in the TclExtensions
    directory then that file would be sourced in place of the standard
    latex.tcl, then latex+1.tcl, then latex+2.tcl.
	
    You may just want to use filename+.extension for a single extension file.
    
    Note that latex+10.tcl would be sourced _before_ latex+9.tcl, so you
    may wish to use latex+01.tcl ... latex+99.tcl to make things clearer.
}

