## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "tclproUtils.tcl"
 #                                    created: 10/9/97 {11:22:17 am} 
 #                                last update: 03/23/2001 {21:26:59 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-2001  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # 
 # Distributable under Tcl-style (free) license.
 #  
 # ###################################################################
 ##

alpha::feature tclproUtils 0.1.1 Tcl {
} {
    menu::insert tclMenu items end tclProCheck tclProCheckDir...
    set "brwsGotoMatch(*Tcl Pro Check output*)" Tcl::tclProGotoMatch
} {
} maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    Interact with Tcl Pro
} uninstall this-file

namespace eval Tcl {}

set Tcl::tclProCheckSuppress "warnVarRef winBeginDot warnUndefProc"

proc Tcl::tclProCheck {} {
    variable tclProCheckSuppress
    catch {exec procheck -suppress $tclProCheckSuppress [win::Current]} res
    grepsToWindow "* Tcl Pro Check output *" $res
}

proc Tcl::tclProCheckDir... {} {
    variable tclProCheckSuppress
    catch {exec procheck -suppress $tclProCheckSuppress [file join [file dirname [win::Current]] *.tcl]} res
    grepsToWindow "* Tcl Pro Check output *" $res
}

proc Tcl::tclProGotoMatch {} {
    set text [getText [lineStart [getPos]] \
      [pos::math [nextLineStart [getPos]] - 1]]
    if {[string first "checking:" $text] == 0} {
	set file [string trim [string range $text 10 end]]
	brwsOpenWindow $file
    } elseif {[regexp {^(.*):([1-9][0-9]*) (\(.*)$} $text "" file line problem]} {
	brwsOpenWindow $file
	set pos [rowColToPos $line 0]
	select $pos [nextLineStart $pos]
	message $problem
    } else {
	message "Didn't understand the line!"
    }
}
