## -*-Tcl-*-
 # ###################################################################
 #  None - none
 # 
 #  FILE: "tkdiffControl.tcl"
 #                                    created: 04/29/98 {01:10:14 AM} 
 #                                last update: 07/20/2001 {12:15:38 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@biosgroup.com
 #    mail: Bios Group
 #          617 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.biosgroup.com/
 #  
 # ###################################################################
 ##



alpha::feature tkdiffControl 0.1 global-only {
    alpha::package require scriptRunner
    namespace eval Diff {}
    set Diff::handlers(Tkdiff) Diff::tkrun
} {} {} uninstall {
    file delete "$pkg_file"
    file delete [file join ${HOME} Tools "tkdiff.tcl"]
} maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    See Tkdiff help
}


proc Diff::tkrun {} {
    global Diff::1 Diff::2 DiffSig tcl_platform
    if {$tcl_platform(platform) == "windows" } {
	regsub -all "\\\\" [set Diff::1] "/" Diff::1
	regsub -all "\\\\" [set Diff::2] "/" Diff::2
    }
    if {[file exists $DiffSig]} {
	eval script::run tkdiff [list -script \
	  [list set env(diffcmd) $DiffSig] [win::StripCount ${Diff::1}] \
	  [win::StripCount ${Diff::2}]]
    } else {
	eval script::run tkdiff [list -script \
	  [list set env(diffcmd) [nameFromAppl $DiffSig]] \
	  [win::StripCount ${Diff::1}] [win::StripCount ${Diff::2}]]
    }
}





