## -*-Tcl-*-
 # ###################################################################
 #  Alphatk - the ultimate editor
 # 
 #  FILE: "tkhtmlViewer.tcl"
 #                                    created: 11/15/2000 {16:47:09 PM} 
 #                                last update: 11/16/2000 {17:42:35 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #     www: http://www.santafe.edu/~vince/
 #  
 # ###################################################################
 ##

alpha::extension tkhtmlViewer 0.1.1 {
    set "htmlViewer(Internal tkhtml widget)" viewInTkhtml
} uninstall this-file maintainer {
    "Vince Darley" vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    Allows viewing of html files (for example, some of Alphatk's help
    pages) in Alphatk, by launching a Tkhtml widget in a separate 
    interpreter.
}

proc viewInTkhtml {filename} {
    global HOME
    # The tkhtml widget is a little buggy regarding its
    # treatment of relative links.
    set pwd [pwd]
    cd [file dirname $filename]
    script::run [file join $HOME Tools hv.tcl] \
      -script "package require Tkhtml" [file tail $filename]
    cd [pwd]
}

