## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha extension 
 # 
 #  FILE: "vcCvs.tcl"
 #                                    created: 00-05-19 16.44.53 
 #                                last update: 10/05/2001 {17:09:24 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 2000  Vince Darley.
 # 
 # Redistributable under standard 'Tcl' license.
 # 
 # Note: when running under Alphatk, the command-line cvs is used.
 # We cannot (yet) interact properly with the command-line cvs, and
 # hence if cvs asks us for a password, the command will fail.
 # 
 # You should therefore configure things (if possible) so that
 # login occurs automatically.
 # 
 # In the future hopefully this constraint will be removed.
 # 
 # ###################################################################
 ##

# feature declaration
alpha::extension vcCvs 0.2b3 {
    # One time init
    vcs::register Cvs cvs
    # These apps are supported
    set cvsSigs {mCVS Mcvs}
    # The Cvs client application
    newPref sig cvsSig "" vcs
    # Any flags you wish to pass the Cvs application, which are valid
    # for any cvs action.
    newPref var cvsGlobalFlags "" vcs
    
    if {$tcl_platform(platform) == "macintosh"} {
	# Users can optionally attach this piece of information to a fileset.
	fileset::attachNewInformation "" file "MacCvs Pro Session File" "" \
	  "The CVS session file used by MacCvs Pro for this file set"
    }
} maintainer {
    {Vince Darley} vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    Cvs version control
} uninstall {this-file}

namespace eval cvs {}


proc cvs::getState {name} {
    # Should this be CVS or Cvs on a filesystem that cares about
    # such things?
    if {[file exists [file join [file dirname $name] CVS]]} {
	# it's under version control, to do...
	set status [cvs::actionOnFile status $name]
	if {[regexp {Status: ([^\r\n]*)} $status "" status]} {
	    set status [string trim $status]
	    if {$status == "Needs Patch"} {
		return "needs-patch"
	    } elseif {$status == "Up-to-date"} {
		return "up-to-date"
	    } elseif {$status == "Unknown"} {
		return "no-vcs"
	    } else {
		return "checked-out"
	    }
	} else {
	    message "$status"
	    return ""
	}
    } else {
	return ""
    }
}

# Execute a command line CVS command.
proc cvs::execute {args} {
    global vcsmodeVars
    set flags "$vcsmodeVars(cvsGlobalFlags) $args"
    catch {app::runScript [list vcsmodeVars cvs] "Cvs application" "" 1 0 $flags} res
    return $res
}

# Execute a CVS command in MacCVS.
proc cvs::executeMacCvs {args} {
    set cvs::tmpfile [temp::path cvs tmp]
    eval [eval concat tclAE::build::resultData 'mCVS' misc dosc "----" $args MODE FILE FILE [list [list [tclAE::build::TEXT ${cvs::tmpfile}]]]]
    return [file::readAll ${cvs::tmpfile}]
}

array set cvs::MacCvsProEvents {
    commit ChKn
    update updt
    checkout cout
    edit "MRO "
}

# Execute a CVS command in MacCVS Pro.
# Global flags are ignored for MacCVS Pro.
proc cvs::executeMacCvsPro {action onFile} {
    global cvs::MacCvsProEvents
    set com ""
    if {[lindex $action 0] == "commit"} {
	set com [list Cmnt [tclAE::build::TEXT [lindex $action 2]]]
	set action [lindex $action 0]
    } else {
    }
    if {![info exists cvs::MacCvsProEvents($action)]} {return "$action not implemented for MacCvs Pro."}
    eval [eval concat [list AEBuild 'Mcvs' MCvs [set cvs::MacCvsProEvents($action)] "----" [list [cvs::MacCvsProFileRef $onFile]]] $com]
}

# Execute a command line CVS command for a folder.
proc cvs::executeGlobal {dir args} {
    global vcsmodeVars
    set flags "$vcsmodeVars(cvsGlobalFlags) $args"
    catch {app::runScript [list vcsmodeVars cvs] "Cvs application" $dir 1 0 $flags "" 1} res
    return $res
}

# Launch a Mac CVS app.
proc cvs::launch {} {
    global vcsmodeVars cvsSigs
    app::launchAnyOfThese $cvsSigs vcsmodeVars(cvsSig) "Please locate a Cvs application."
}

# Perform a CVS action on a file.
proc cvs::actionOnFile {action onFile} {
    global alpha::platform vcsmodeVars
    set onFile [win::StripCount $onFile]
    if {${alpha::platform} == "alpha"} {cvs::launch}
    switch -- $vcsmodeVars(cvsSig) {
	mCVS {
	    set action "$vcsmodeVars(cvsGlobalFlags) $action"
	    set action [list [tclAE::build::List [concat $action [file tail $onFile]] -as TEXT] SPWD [tclAE::build::TEXT [file dirname $onFile]]]
	    set res [cvs::executeMacCvs $action]
	}
	Mcvs {
	    set res [cvs::executeMacCvsPro $action $onFile]
	}
	default {
	    set dir [pwd]
	    cd [file dirname $onFile]
	    set res [eval cvs::execute $action [list [file tail $onFile]]]
	    cd $dir
 	}
    }
    set res
}

# Perform a CVS action on a folder.
proc cvs::actionOnDir {action onDir} {
    return [cvs::executeGlobal $onDir $action]
}

proc cvs::otherCommands {state} {
    return [list updateAll]
}

proc cvs::updateAll {name} {
    message "cvs update all: [cvs::actionOnDir update [file dirname $name]]"
}

proc cvs::lock {name} {
    vcs::lock $name
}

proc cvs::unlock {name} {
    vcs::unlock $name
}

proc cvs::checkIn {name} {
    global vcsmodeVars
    message "cvs checkin: [cvs::actionOnFile [list commit -m [prompt "Log message:" ""]] $name]"
    # cvs modifies the file's header
    revert -w $name
}

# Checkout only apply to folders.
proc cvs::checkOut {name} {
    message "cvs checkout: unimplemented"
#     message "cvs checkout: [cvs::actionOnFile checkout $name]"
}

proc cvs::undoCheckout {name} {
    message "cvs undoCheckout: unimplemented"
}

proc cvs::add {name} {
    message "cvs add: [cvs::actionOnFile add $name]"
}

proc cvs::makeWritable {name} {
    message "cvs makeWritable: [cvs::actionOnFile edit $name]"
    setWinInfo read-only 0
}

proc cvs::showDifferences {name} {
    set difference [cvs::actionOnFile "diff -u" $name]
    if {[string length $difference]} {
	Diff::of $name $difference
    } else {
	message "cvs diff: no differences to file in repository"
    }
}

proc cvs::refetchReadOnly {name} {
    set result [string trim [cvs::actionOnFile update $name]]
    if {[string length $result]} {
	revert -w $name
	message "cvs refetchReadOnly: $result"
    } else {
	message "cvs refetchReadOnly: no new version available"
    }
}

# Returns the MacCVS Pro session file of the current fileset.
proc cvs::MacCvsProSessionFile {} {
    if {[set sessionfile [vcs::getFilesetInfo "MacCvs Pro Session File"]] == ""} {
	dialog::alert "The window must belong to a fileset with a MacCvs Pro Session File defined. Use 'Edit A Fileset' to set the session file."
	error "no session file"
    }
    return $sessionfile
}

# Returns the local root of a MacCVS Pro session file.
proc cvs::MacCvsProLocalRoot {name sessionfile} {
    global file::separator
    sendOpenEvent noReply 'Mcvs' $sessionfile
    set localroot [specToPathName [tclAE::build::objectProperty 'Mcvs' lrfs [tclAE::build::nameObject docu [tclAE::build::TEXT [file tail $sessionfile]] [tclAE::build::nullObject]]]]
    if {![string match "$localroot${file::separator}*" $name]} {
	dialog::alert "The local root of this window's fileset is $localroot, but this window is not inside that folder."
	error "wrong local root"
    }
    return $localroot
}

# Returns the relative path to the local root of "name".
proc cvs::MacCvsProFileRef {name} {
    set sessionfile [cvs::MacCvsProSessionFile]
    set root [cvs::MacCvsProLocalRoot $name $sessionfile]
    set name [string range $name [expr {[string length $root] + 1}] end]
    regsub -all : $name / name
    tclAE::build::nameObject file [tclAE::build::TEXT $name] [tclAE::build::nameObject docu [tclAE::build::TEXT [file tail $sessionfile]] [tclAE::build::nullObject]]
}


## 
 # -------------------------------------------------------------------------
 # 
 # "cvs::getMenuItems" --
 # 
 #  Returns menu items pertinant for CVS
 # -------------------------------------------------------------------------
 ##
proc cvs::getMenuItems {state} {
    set res [vcs::generalMenuItems $state]
    if {[llength res]} {
        lappend res "(-)"
    } 
    lappend res updateAll
    
    return $res
}

