## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha extension 
 # 
 #  FILE: "vcPerforce.tcl"
 #                                    created: 03/27/2000 {14:57:19 PM} 
 #                                last update: 1/8/2001 {9:02:52 AM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 2000  Vince Darley, all rights reserved
 # 
 # Redistributable under standard 'Tcl' license.
 # 
 # ###################################################################
 ##

# feature declaration
alpha::extension vcPerforce 0.1.4 {
    # one time init
    vcs::register Perforce perforce
    # The Perforce client application
    newPref sig perforceSig "" vcs
} maintainer {
    {Vince Darley} vince@santafe.edu <http://www.santafe.edu/~vince/>
} help {
    Perforce version control

    So far it requires you to setup your client using some other
    tool.  Once that is setup, you can do simple checkout/checkin
    operations from within Alpha.
} uninstall {this-file}

namespace eval perforce {}

proc perforce::getState {name} {
    set st [perforce::execute opened $name]
    if {[string first "is not under client's root" $st] != -1} {
	# not in correct path to be in repository
	return ""
    } elseif {[string first " - file(s) not opened on this client." $st] != -1} {
	# either not open, or not in repository
	set st [perforce::execute files $name]
	if {[string first " - no such file(s)." $st] != -1} {
	    # not in repository
	    return "no-vcs"
	} else {
	    # it's in there, but not open
	    return "read-only"
	}
    } else {
	# it is open in edit mode
	return "checked-out"
    }
}

proc perforce::makeChangeSpec {description} {
    set changelist [perforce::execute change -o]
    regsub {<enter description here>} $changelist [quote::Regsub $description] changelist

    set filename [temp::path tmp perforce.tmp]
    set fout [open $filename w]
    puts -nonewline $fout $changelist
    close $fout
    return $filename
}

proc perforce::execute {args} {
    global vcsmodeVars
    catch {app::runScript [list vcsmodeVars perforce] "Perforce application" "" 1 0 $args} res
    #catch {eval [list exec $vcsmodeVars(perforceSig)] $args} res
    return $res
}

proc perforce::otherCommands {state} {
    return ""
}

proc perforce::lock {name} {
    message "perforce lock: [perforce::execute revert [win::StripCount $name]]"
}

proc perforce::unlock {name} {
    message "perforce unlock: [perforce::execute edit [win::StripCount $name]]"
}

proc perforce::add {name} {
    message "perforce add: [perforce::execute add [win::StripCount $name]]"
}

proc perforce::checkIn {name {description ""}} {
    if {![string length $description]} {
	set description [getline "Description of change"]
	if {![string length $description]} {
	    error "Cancelled!"
	}
    }
    set result [perforce::execute submit -i [win::StripCount $name] < [perforce::makeChangeSpec $description]]
    message "perforce checkin: $result"
    vcs::syncLockStatus $name
}

proc perforce::undoCheckout {name} {
    set result [perforce::execute revert [win::StripCount $name]]
    revert -w $name
    message "perforce undoCheckout: $result"
}

proc perforce::checkOut {name} {
    message "perforce checkout: [perforce::execute edit [win::StripCount $name]]"
}

proc perforce::refetchReadOnly {name} {
    set result [perforce::execute sync [win::StripCount $name]]
    if {![string match "* - file(s) up-to-date." $result]} {
	revert -w $name
    }
    message "perforce refetchReadOnly: $result"
}

proc perforce::showDifferences {name} {
    set difference [perforce::execute diff -dc $name]
    if {![string match "* - file(s) not opened on this client." $difference]} {
	Diff::of $name $difference
    } else {
	message "cvs diff: $difference"
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "perforce::getMenuItems" --
 # 
 #  Returns menu items pertinant to Perforce
 # -------------------------------------------------------------------------
 ##
proc perforce::getMenuItems {state} {
    return [vcs::generalMenuItems $state]
}


