## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha extension 
 # 
 #  FILE: "vcVoodoo.tcl"
 #                                    created: 03/27/2000 {14:57:19 PM} 
 #                                last update: 9/24/01 {7:06:52 PM} 
 #  Author: Jonathan Guyer
 #  E-mail: <jguyer@his.com>
 #    mail: Alpha Cabal
 #     www: <http://www.his.com/~jguyer/>
 #  
 # Copyright (c) 2001  Jonathan Guyer.
 # Copyright (c) 2000-2001  Vince Darley.
 # 
 # Redistributable under standard 'Tcl' license.
 # 
 # No more than a dummy shell right now...
 # 
 # ###################################################################
 ##

# feature declaration
alpha::extension vcVoodoo 0.1 {
    # one time init
    vcs::register Voodoo Vodo
    newPref sig voodooSig "Vodo" vcs
} maintainer {
    {Jonathan Guyer} <jguyer@his.com> <http://www.his.com/~jguyer/Alpha/>
} help {
    VOODOO Personal version control
} uninstall {this-file}

namespace eval Vodo {}

proc Vodo::menuProc {menu item} {
    global voodoo voodooProject
    
    if {![info exists voodooProject]} {
	return
    }
    
    if {[regexp {(.*)WithDialog$} $item blah item]} {
	set dialog 1
    } else {
	set dialog 0
    }
    
    switch -- $item {
	"store" -
	"fetch" -
	"fetchReadOnly" -
	"add" -
	"compare" {
	    voodoo::try [list voodoo::window voodoo::${item}]
	}
	"add&Store" {
	    voodoo::try [list voodoo::window voodoo::add]
	    voodoo::try [list voodoo::window voodoo::store]
	}
	"makeWritable" {
	    vcs::makeWritable [win::Current]
	}
	default {
	    vcs::menuProc $menu $item
	}
    }
}

proc Vodo::getState {name} {
    return [vcs::getState $name]
}

proc Vodo::checkCompatibility {name} {
    vcs::ckid::checkCompatibility $name [list "VOODOO"]
}

proc Vodo::otherCommands {state} {
    return ""
}

proc Vodo::lock {name} {
    vcs::lock $name
}

proc Vodo::unlock {name} {
    vcs::unlock $name
}

proc Vodo::store {name} {
    voodoo::submenuProc store window
}

proc Vodo::storeWithDialog {name} {
    voodoo::submenuProc store windowWithDialog
}

proc Vodo::fetch {name} {
    voodoo::submenuProc fetch window
}

proc Vodo::fetchWithDialog {name} {
    voodoo::submenuProc fetch windowWithDialog
}

proc Vodo::add {name} {
    voodoo::submenuProc add window
}

proc Vodo::fetchReadOnly {name} {
    voodoo::submenuProc "Fetch Read-Only" window
}

proc Vodo::fetchReadOnlyWithDialog {name} {
    voodoo::submenuProc "Fetch Read-Only" windowWithDialog
}

proc Vodo::makeWritable {name} {
    vcs::makeWritable $name
}

proc Vodo::compare {name} {
    voodoo::submenuProc compare window
}

proc Vodo::status {name} {
    voodoo::submenuProc status window
}

proc Vodo::getInfo {name} {
    vcs::ckid::getInfo $name
}

## 
 # -------------------------------------------------------------------------
 # 
 # "Vodo::getMenuItems" --
 # 
 #  Returns menu items pertinant to VOODOO
 # -------------------------------------------------------------------------
 ##
proc Vodo::getMenuItems {state} {
    global voodooProject
    
    if {$voodooProject(lockFiles)} {
        set storeIcon [icon::FromID 491]
    } else {
	set storeIcon [icon::FromID 490]
    }
    
    lappend res "(-"
    
    switch -- $state {
      "no-vcs" { 
	  lappend res "<E<Sadd&Store$storeIcon"	\
	    "<Sadd[icon::FromID 490]"			\
	    "<E<SstoreWithDialog$storeIcon"    \
	    "<S(store$storeIcon"              	\
      }
      "checked-out" { 
	  lappend res                                   \
	    "<E<SstoreWithDialog[icon::FromID 490]"    \
	    "<Sstore[icon::FromID 490]"              	\
	    "<E<SfetchReadOnlyWithDialog[icon::FromID 491]"          \
	    "<SfetchReadOnly[icon::FromID 491]"         \
	    "\(makeWritable[icon::FromID 492]"          \
	    "(-)"                                       \
	    "compare" 					\
	    "status"
      }
      "read-only" { 
	  lappend res                                   \
	    "<E<SfetchWithDialog[icon::FromID 490]"    \
	    "<Sfetch[icon::FromID 490]"             	\
	    "<E<SrefetchReadOnlyWithDialog[icon::FromID 491]"       \
	    "<SrefetchReadOnly[icon::FromID 491]"       \
	    "makeWritable[icon::FromID 492]"		\
	    "(-)"                                       \
	    "compare"					\
	    "status"
      }
      "mro" { 
	  lappend res                                   \
	    "<E<SfetchWithDialog[icon::FromID 490]"    \
	    "<Sfetch[icon::FromID 490]"             	\
	    "<E<SrefetchReadOnlyWithDialog[icon::FromID 491]"       \
	    "<SrefetchReadOnly[icon::FromID 491]"       \
	    "<E<SstoreWithDialog[icon::FromID 490]"    \
	    "<Sstore[icon::FromID 490]"              	\
	    "(-)"                                       \
	    "compare"					\
	    "status"
      }
      "" {
	  # no version control registered, or not possible 
	  # to place under version control with current
	  # system
	  set res {}
      }
      default {
	  error "Bad response '$state' received from vcs system"
      }
    }
    
    return $res
}

