if {[catch {
    # First fix some problems with Tcl 7.4
    if {[info tclversion] < 7.6} { 
	set tcl_platform(platform) macintosh
	# Alpha already has these two renamed internally
	# they need their argument packaged as a list!
	;proc mkdir {dir} {
	    oldMkdir [list $dir]
	}
	;proc rmdir {dir} {
	    oldRmdir [list $dir]
	}
	
	if {[info commands __file] == ""} {
	    rename file __file
	    
	    ;proc file {cmd args} {
		switch -- $cmd\
		  "dirname" {eval __file_dirname $args}\
		  "join" {eval __file_join $args}\
		  "copy" {eval __file_copy $args}\
		  "rename" {eval __file_rename $args}\
		  "delete" {eval __file_delete $args}\
		  "mkdir" {eval mkdir $args}\
		  "volumes" {eval __file_volumes $args}\
		  "split"  {eval __file_split $args}\
		  "attributes" {eval __file_attributes $args}\
		  "nativename" {lindex $args 0}\
		  "pathtype" {eval __file_pathtype $args}\
		  "separator" {return ":"}\
		  "system" {return "native"}\
		  "normalize" {eval __file_normalize $args}\
		  "mtime" {eval __file_mtime $args}\
		  default {uplevel 1 __file $cmd $args}
	    }

	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_dirname" --
	     #
	     #  Implementation of [file dirname].
	     #
	     # 2001-07-10 <Frederic.Boulanger@supelec.fr>:
	     #    __file dirname does not take :: (up folder) specifiers into account
	     #    It is safer to find the dirname by removing the tail from the path
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_dirname {args} {
		if {[llength $args] != 1}\
		  then {return -code error "wrong # args: should be \"file dirname name\""}
		set path [lindex $args 0]
		set dir [string range $path 0 [expr \
		  [string length $path] - [string length [__file tail $path]] -2]]
		if {[string index $path 0] != ":" && ![regexp : $dir]} {set dir "$dir:"}
		if {[string index $path 0] == ":" && ![regexp : $dir]} {set dir ":$dir"}
		return $dir
	    }




	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_join" --
	     #
	     #  Implementation of [file join].
	     #
	     #    Empty arguments and arguments simply being ":" are ignored.
	     #    Arguments containing a colon but not beginning with a colon are
	     #  interpreted as absolute paths. The result from the previous arguments
	     #  is thrown away.
	     #    A colon at the beginning or end of an argument is stripped off, unless
	     #  that colon is part of a "::".
	     #    If res ends in ':' and p starts with ':', we must remove
	     #  one ':'. For instance "file join a:b:c:d:: ::e" must
	     #  return "a:b:c:d:::e" since "::" means "one directory level
	     #  up", but "two directory levels up" is said ":::", not "::::".
	     #  If not, add ':' only is res does not end in ':'
	     #  and p does not start with ':'
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_join {args} {
		if {![llength $args]} then {return -code error\
		  "wrong # args: should be \"file join name ?name ...?\""}
		set res ""
		foreach p $args {
		    if {$p == "" || $p == ":"} {continue}
		    if {[string index $p 0] != ":" && [regexp : $p]} {
			if {[string match "*:" $p] && ![string match "*::" $p]}\
			  {regexp {^(.*):$} $p "" p}
			set res $p
		    } else {
			if {[string match "*:" $p] && ![string match "*::" $p]}\
			  {regexp {^(.*):$} $p "" p}
			if {[string index $p 0] == ":" && ![string match "::*" $p]}\
			  {set p [string range $p 1 end]}
			if {[string match "*:" $res] && [string match ":*" $p]} {
			    append res [string range $p 1 end]
			} elseif {![string match "*:" $res] && ![string match ":*" $p]} {
			    append res : $p
			} else {
			    append res $p
			}
		    }
		}
		if {![regexp : $res]} then {append res :} else {set res}
	    }



	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_copy" --
	     #
	     #  Implementation of [file copy], with approximate emulation of '-force'.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_copy {args} {
		set i 0
		while 1 {
		    switch -- [lindex $args $i]\
		      "-force" {incr i; set force 1}\
		      "--" {incr i; break}\
		      default {break}
		}
		if {[info exists force] && [file exists [lindex $args end]]}\
		  {file delete [lindex $args end]}
		eval copyFile [lrange $args $i end]
	    }



	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_rename" --
	     #
	     #  Implementation of [file rename] that copes with the fact that
	     #  moveFile cannot move a file or folder across volumes by
	     #  asking the Finder to move it.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_rename {args} {
		if {[catch {eval moveFile $args} err]} {
		    if {$err == "An unknown error occured."} {
			file::move [lindex $args 0] [lindex $args 1]
		    } else {
			return -code error $err
		    }
		}
	    }



	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_delete" --
	     #
	     #  Implementation of [file delete].
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_delete {args} {
		set i 0
		while 1 {
		    switch -- [lindex $args $i]\
		      "-force" {incr i; set force 1}\
		      "--" {incr i; break}\
		      default {break}
		}
		global file::separator
		foreach f [lrange $args $i end] {
		    if {![file isdirectory $f]} then {
			removeFile $f
		    } elseif {[info exists force]} {
			rm -r [string trimright $f ${file::separator}]
		    } else {
			rmdir $f
		    }
		}
	    }


	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_volumes" --
	     #
	     #  Implementation of [file volumes], thanks to Jon.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_volumes {} {
		tclAE::build::resultData 'MACS' core getd ----\
		  {obj {form:indx, want:type(cdis), seld:abso('all '), from:'null'()}}\
		  rtyp type(TEXT)
	    }



	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_split" --
	     #
	     #  Implementation of [file split].
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_split {args} {
		if {[llength $args] != 1} then {return -code error\
		  "wrong # args: should be \"file split name\""}
		set path [lindex $args 0]
		set pieces [split [string trim $path :] :]
		set res ""
		foreach p $pieces {if {$p == ""} {lappend res ::} else {lappend res $p}}
		if {[string index $path 0] != ":" && [regexp ":" $path]}\
		  then {lreplace $res 0 0 "[lindex $res 0]:"}\
		  else {set res}
	    }



	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_attributes" --
	     #
	     #  Rudimentary implementation of [file attributes]. The only
	     #  thing that works is
	     #
	     #     file attributes <filename> -readonly
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_attributes {f attr args} {
		switch -- $attr\
		  "-readonly" {
		    #__file stat [lindex $args 0] r
		    if {[llength $args]} {
			# set read-only status
		    } else {
			# get read-only status
			return [expr {![__file writable $f]}]
		    }
		  }\
		  default {error "file attributes $attr unimplemented"}
	    }


	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_pathtype" --
	     #
	     #  Implementation of [file pathtype]. Not perfect, but not bad either.
	     #
	     #  We do a nasty hack to avoid loading all the
	     #  AE code when we rebuild tcl indices on an Alpha
	     #  upgrade.  Frankly I don't think anyone's ever
	     #  used a relative path with Alpha except when
	     #  they type 'auto_mkindex .' in the shell.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_pathtype {args} {
		global alpha::guiNotReady
		if {[info exists alpha::guiNotReady] && ${alpha::guiNotReady}}\
		  {return "absolute"}
		set relative 1
		set path [lindex $args 0]
		foreach volume [__file_volumes] {
		    if {[string first $volume $path] == 0}\
		      then {set relative 0; break}
		}
		lindex {absolute relative} $relative
	    }

	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_mtime" --
	     #
	     #  Implementation of [file mtime] which copes with optional
	     #  extra argument to set a file's mtime.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_mtime {f args} {
		if {[llength $args] == 0} then {return [__file mtime $f]}
		if {[llength $args] > 1} { return -code error\
		  "wrong # args: should be \"file mtime name ?time?\""}
		set time [lindex $args 0]
		# need to implement this
		return -code error "'file mtime name val' not implemented.\
		  Please contribute an implementation using appleevents."
	    }


	    ##
	     # -------------------------------------------------------------------------
	     #
	     # "__file_normalize" --
	     #
	     #  Primitive implementation of [file normalize].
	     #
	     # 2001-08-22 <Lars.Hellstrom@math.umu.se>:
	     #  Using __file_join instead of mere concatenation. The latter fails
	     #  when $path starts with a colon.
	     #
	     # -------------------------------------------------------------------------
	     ##
	    proc __file_normalize {path} {
		if {[__file_pathtype $path] == "relative"}\
		  then {__file_join [pwd] $path} else {set path}
	    }
	}
    } 
    # Startup of Alpha/Alphatk is split into two phases. The first
    # phase initialises the environment (PREFS folder, early prefs, etc),
    # and the second phase continues with loading of packages, menus,
    # etc, and reads in all of the user's ordinary preferences.  During
    # the first phase we should avoid interacting with the user, because
    # the gui may not yet be properly created.
    # 
    # We split things into two phases so that, for example, the editor
    # can use some of the information gathered in the first phase
    # (especially the early prefs) and use them to control what happens
    # later.  For example, the location/type of status bar used can be
    # set from such early preferences.
    
    # First phase:
    # basic initialisation: (works with Alpha 7.2.1 or 8.0 development)
    # (Note that this phase has already happened under Alphatk, and possibly
    # in the future under Alpha 8).  If the initAlphaTcl file notices
    # it has already been sourced, it will simply return.
    source [file join $HOME Tcl SystemCode initAlphaTcl.tcl]

    # Second phase:
    # do all the more complex stuff:
    source [file join $HOME Tcl SystemCode runAlphaTcl.tcl]

} err]} {
    append alpha::errorLog "\r" $errorInfo
    set errCache $errorInfo
    if {![llength [info commands auto_load]] \
      || (![auto_load dialog::yesno] || ![auto_load dialog::alert])} {
	# This error happened either too early on in a weird way,
	# so that even the auto-loading mechanism doesn't work
	# (and has overwritten the original problem)
	# We just use the cached information.
	set errorInfo $errCache
	alertnote "That was a core startup error.  Alpha will probably\
	  not function correctly.  Press Ok to view the error.  Also note\
	  that auto-loading seems not to be functioning."
	if {[info tclversion] < 8.0} {
	    alertnote [string range $errorInfo 0 250]
	} else {
	    alertnote $errorInfo
	}
    } else {
	if {[dialog::yesno -y "View the error" -n "Continue" \
	  "That was a core startup error.  Alpha will probably\
	  not function correctly."]} {
	    dialog::alert $errCache
	}
    }
}
if {[info exists alpha::errorLog]} {
    catch {
	new -n "* Alpha startup error log *" -info ${alpha::errorLog}
	unset alpha::errorLog
    }
}
# call these two procs to sort out the menu enabled state.
catch {
    menuEnableHook [expr {[win::Current] != ""}]
    requireOpenWindowsHook 2
}
message "Initialization Complete"
