#  AlphaTcl - core Tcl engine
# (auto-install)
alpha::extension internationalMenus 0.3.4 {
    alpha::package require -loose Alpha 7.1.5
    # Menu-replacements (all western keyboards)
    hook::register keyboard intlMenu::standard "Australian"
    hook::register keyboard intlMenu::brasil "Brasil"
    hook::register keyboard intlMenu::standard "British"
    hook::register keyboard intlMenu::canadian_csa "Canadian - CSA"
    hook::register keyboard intlMenu::canadian_iso "Canadian - ISO"
    hook::register keyboard intlMenu::canadian_french "Canadian - French"
    hook::register keyboard intlMenu::danish "Danish"
    hook::register keyboard intlMenu::standard "Dutch"
    hook::register keyboard intlMenu::euro_one "Espaol - ISO"
    hook::register keyboard intlMenu::euro_one "Finnish"
    hook::register keyboard intlMenu::euro_two "Flemish"
    hook::register keyboard intlMenu::euro_two "French"
    hook::register keyboard intlMenu::euro_two "French - numerical"
    hook::register keyboard intlMenu::euro_one "German"
    hook::register keyboard intlMenu::euro_two "Italian"
    hook::register keyboard intlMenu::euro_one "Norwegian"
    hook::register keyboard intlMenu::roman_jis "Roman - JIS"
    hook::register keyboard intlMenu::spanish "Spanish"
    hook::register keyboard intlMenu::euro_one "Swedish"
    hook::register keyboard intlMenu::swiss "Swiss French"
    hook::register keyboard intlMenu::swiss "Swiss German"
    hook::register keyboard intlMenu::slovencrotian "Slovenian"
    hook::register keyboard intlMenu::slovencrotian "Croatian"
    hook::register keyboard intlMenu::standard "U.S."
    hook::register keyboard intlMenu::italian_pro "Italian - Pro"
} uninstall {this-file} help {
    Changes incompatible menu key-bindings to keys which are useable
    on any (western) international keyboard
}

namespace eval intlMenu {}

# Define some help procs so we save a lot of typing
proc intlMenu::change_winMenu {zoom zoom_char choose choose_char} {
    menu::replaceWith openWindowsMenu [list "//<Szoom" "//<S<I<OdefaultSize" \
      "<S/;chooseAWindow"] \
      items "$zoom_char<Szoom" "$zoom_char<S<I<OdefaultSize" \
      "$choose_char<SchooseAWindow"
}

proc intlMenu::change_editMenu {twiddle twiddle_char \
  shiftLeft shiftLeft_char \
  shiftRight shiftRight_char} {
    menu::replaceWith Edit [list "/`<Stwiddle" "/`<S<I<OtwiddleWords"] \
      items "$twiddle_char<Stwiddle" "$twiddle_char<S<I<OtwiddleWords"
    menu::replaceWith Edit [list {/[<SshiftLeft} {/[<S<I<OshiftLeftSpace}] \
      items "$shiftLeft_char<SshiftLeft" "$shiftLeft_char<S<I<OshiftLeftSpace" 
    menu::replaceWith Edit [list {/]<SshiftRight} {/]<S<I<OshiftRightSpace}] \
      items "$shiftRight_char<S<EshiftRight" "$shiftRight_char<S<I<OshiftRightSpace"
}

proc intlMenu::change_editMenu_original {} {
    menu::replaceWith Edit [list "/`<Stwiddle" "/`<S<I<OtwiddleWords"] \
      items "/`<Stwiddle" "/`<S<I<OtwiddleWords"
    menu::replaceWith Edit [list {/[<SshiftLeft} {/[<S<I<OshiftLeftSpace}] \
      items {/[<SshiftLeft} {/[<S<I<OshiftLeftSpace} 
    menu::replaceWith Edit [list {/]<SshiftRight} {/]<S<I<OshiftRightSpace}] \
      items {/]<SshiftRight} {/]<S<I<OshiftRightSpace}
}

proc intlMenu::change_markHilite {to hilite_char} {
    menu::replaceWith Search "/=markHilite" items "$hilite_char<OmarkHilite"
}

proc intlMenu::change_searchMenu {pop pop_char goto goto_char} {
    menu::replaceWith Search [list "/.<BreturnToBookmark" "/G<I<BgotoLine"] \
      items "$pop_char<BreturnToBookmark" "$goto_char<I<BgotoLine" 
}

proc intlMenu::bindBraces {} {
    Bind '\[' <zs>  normalLeftBrace
    Bind '\]' <zs>  normalRightBrace
}

proc intlMenu::unbindBraces {} {
    unBind '\[' <zs>  normalLeftBrace
    unBind '\]' <zs>  normalRightBrace
}

# These are the procs which are called automatically when the user chooses 
# one of the (western) international keyboards in the international prefs 
# dialog.
proc intlMenu::brasil {args} {
    intlMenu::change_winMenu zoom "/-" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/\\"
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::bindBraces
}

proc intlMenu::canadian_csa {args} {
    intlMenu::change_winMenu zoom "//" choose "/;"
    intlMenu::change_editMenu twiddle "" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::canadian_iso {args} {
    intlMenu::change_winMenu zoom "/-" choose "/;"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::canadian_french {args} {
    intlMenu::change_winMenu zoom "//" choose "/;"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::bindBraces
}

proc intlMenu::danish {args} {
    intlMenu::change_winMenu zoom "/-" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/$"
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::euro_one {args} {
    intlMenu::change_winMenu zoom "/-" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to ""
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::euro_two {args} {
    intlMenu::change_winMenu zoom "/-" choose "/;"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "/(" shiftRight "/)"
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/:" goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::spanish {args} {
    intlMenu::change_winMenu zoom "/-" choose "/;"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/." goto ""
    intlMenu::unbindBraces
}

proc intlMenu::swiss {args} {
    intlMenu::change_winMenu zoom "/-" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/$"
    intlMenu::change_searchMenu pop "/." goto ""
    intlMenu::unbindBraces
}

proc intlMenu::slovencrotian {args} {
    intlMenu::change_winMenu zoom "//" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "" shiftRight ""
    intlMenu::change_markHilite to "/-"
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}

proc intlMenu::standard {args} {
    intlMenu::change_winMenu zoom "//" choose "/;"
    intlMenu::change_editMenu_original
    intlMenu::change_markHilite to "/="
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::bindBraces
}

proc intlMenu::roman_jis {args} {
    intlMenu::change_winMenu zoom "//" choose "/;"
    intlMenu::change_editMenu twiddle "/@" shiftLeft "/\[" shiftRight "/\]"
    intlMenu::change_markHilite to "/-"
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::bindBraces
}
proc intlMenu::italian_pro {args} {
    intlMenu::change_winMenu zoom "/-" choose "/,"
    intlMenu::change_editMenu twiddle "/<" shiftLeft "<O<B/8" shiftRight "<O<B/9"
    intlMenu::change_markHilite to "/\\"
    intlMenu::change_searchMenu pop "/." goto "/G"
    intlMenu::unbindBraces
}
