## -*-Tcl-*-
 # ###################################################################
 # 
 #  FILE: "openWindowsMenu.tcl"
 #                                    created: 04/04/2001 {19:13:29 PM} 
 #                                last update: 09/19/2001 {20:34:33 PM} 
 #  
 #  Author: Vince Darley, Craig Upright
 #  
 #  Contains most stuff related to the 'Windows' menu in Alpha(tk).
 #  
 #  This file is distributed under a Tcl-style license.
 # 
 # ###################################################################
 ##
 
alpha::menu openWindowsMenu 0.1.4 global "263" {
    menu::buildProc openWindowsMenu win::buildWinMenu
    menu::buildSome openWindowsMenu
} {
    hook::register requireOpenWindowsHook [list $openWindowsMenu arrangeWindows] 2
    hook::register closeHook win::removeFromMenu
    hook::register openHook win::addToMenu
    hook::register saveasHook win::renameInMenu
    if {[info tclversion] < 8.0} {
	hook::register requireOpenWindowsHook [list $openWindowsMenu chooseAWindow] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu zoom] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu iconify] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu shrinkWindow] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu splitWindow] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu otherPane] 1
	hook::register requireOpenWindowsHook [list $openWindowsMenu toggleScrollbar] 1
    } else {
	hook::register requireOpenWindowsHook [list $openWindowsMenu ""] 1
    }
    hook::register dirtyHook win::dirtyHook
    hook::register fileMovedHook win::fileMovedHook
} {
    hook::deregister requireOpenWindowsHook [list $openWindowsMenu arrangeWindows] 2
    hook::deregister closeHook win::removeFromMenu
    hook::deregister openHook win::addToMenu
    hook::deregister saveasHook win::renameInMenu
    if {[info tclversion] < 8.0} {
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu chooseAWindow] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu zoom] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu iconify] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu shrinkWindow] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu splitWindow] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu otherPane] 1
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu toggleScrollbar] 1
    } else {
	hook::deregister requireOpenWindowsHook [list $openWindowsMenu ""] 1
    }
    hook::deregister dirtyHook win::dirtyHook
    hook::deregister fileMovedHook win::fileMovedHook
} help {
    Windows menu
    
    Use this menu to choose between open windows, and to adjust 
    the shape or arrangement of existing windows.|Windows menu
    
    It is disabled because no windows are currently open.
}

namespace eval win {}

proc win::dirtyHook {name dirty} {
    global openWindowsMenu
    markMenuItem -m $openWindowsMenu [file tail $name] $dirty ""
}

proc win::fileMovedHook {from to} {
    global winNumToName winNameToNum
    set i $winNameToNum($from)
    unset winNameToNum($from)
    set winNumToName($i) $to
    set winNameToNum($to) $i
}

proc win::buildWinMenu {} {
    global openWindowsMenu winNameToNum alpha::platform
    set ma {
	"//<Szoom"
	"//<S<I<OdefaultSize"
	"<S/;chooseAWindow"
	{Menu -n shrinkWindow -p menu::winTileProc {
	    full
	    high
	    low
	    left
	    right
	}}
	{Menu -n arrangeWindows -p menu::winTileProc {
	    /Jvertically^1
	    /J<O<Ihorizontally^2
	    /J<B<OunequalVert^6
	    /J<B<I<OunequalHor^5
	    bufferOtherWindow
	    \(-
	    tileAll
	    overlayAll
	    iconifyAll
	    deiconifyAll
	    \(-
	    swapWithNext
	    nextWindow
	    prevWindow
	}}
	\(-
	/I<Biconify
	<E<S/msplitWindow
	<S<O/motherPane
	/otoggleScrollbar
    }

    if {${alpha::platform} == "tk"} {
	lappend ma "<O/otoggleLineNumbers"
    }
    lappend ma "\(-"
    # We may be reloading, so add whatever windows we have
    if {[info exists winNameToNum]} {
	set nms [array names winNameToNum]
	foreach name $nms {
	    set item [file tail $name]
	    set num $winNameToNum($name)
	    if {$num < 10} 	{
		lappend ma /$num${item}
	    } else {
		lappend ma ${item}
	    }
	}
    }
    return [list "build" $ma menu::winProc "" $openWindowsMenu]
}

proc menu::winProc {menu name} {
    global winNameToNum

    set nms [array names winNameToNum]

    if {[lsearch -glob $nms "*[quote::Find $name]"] < 0} {
	$name
	return
    }

    foreach nm $nms {
	if {[string match *[quote::Find $name] $nm] == "1"}  {
	    bringToFront $name
	    if {[icon -q]} { icon -f $name -o }
	    return
	}
    }
    return "normal"
}

proc menu::winTileProc {menu item} {
    if {$menu == "shrinkWindow"} {
	set First [string toupper [string index $item 0]]
	shrink${First}[string range $item 1 end]
    } else {
	switch $item {
	    "vertically"	{win$item}
	    "horizontally"	{win$item}
	    "unequalVert"	{win$item}
	    "unequalHor"	{win$item}
	    "tileAll"		{wintiled}
	    "overlayAll"	{winoverlay}
	    "deiconifyAll"	{iconifyAll 0}
	    default		{$item}
	}
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "win::addToMenu" --
 # 
 #  Adds a window name to the window menu.  This new version adds a 
 #  binding, to work-around a bug in Alpha, so that using cmd-0-9
 #  works if the window name contains square brackets.  The problem
 #  is that the 'addMenuItem' line creates a binding of the form
 #  'menu::winProc 263 namewith[square]brackets' which when evaluated
 #  causes an error.  We force a separate binding to
 #  'menu::winProc 263 {namewith[square]brackets}' which does work.
 # -------------------------------------------------------------------------
 ##
proc win::addToMenu {name} {
    global winNameToNum openWindowsMenu winNumToName
    if {[info tclversion] < 8.0} {
	set name [subst $name]
    }
    
    for {set i 0} {$i<100} {incr i} {
	if {![info exists winNumToName($i)]} {
	    regsub { <[0-9]+>$} $name {} nm
	    if {[file exists $nm]} {
		set nm [file tail $name]
	    } else {
		set nm $name
	    }
	    if {$i < 10} {
		addMenuItem -m -l "/$i" $openWindowsMenu "$nm"
		if {[info tclversion] < 8.0} {
		    # This bug will be fixed in Alpha 8
		    Bind '$i' <c> [list menu::winProc $openWindowsMenu $nm]
		}
	    } else {
		addMenuItem -m -l "" $openWindowsMenu "$nm"
	    }
	    set winNumToName($i) $name
	    set winNameToNum($name) $i
	    return
	}
    }
}

proc win::removeFromMenu {name} {
    global winNameToNum winNumToName openWindowsMenu
    if {[info tclversion] < 8.0} {
	set name [subst $name]
    }
    set num $winNameToNum($name)
    unset winNumToName($num)
    unset winNameToNum($name)
    regsub { <[0-9]+>$} $name {} nm
    if {[file exists $nm]} {
	set nm [file tail $name]
    } else {
	# in case it was a file but the file was actually moved!
	global file::separator tcl_platform
	if {[regexp "\[^${file::separator}\]+\$" $name nm]} {
	    if {![catch {deleteMenuItem -m $openWindowsMenu $nm}]} { return } 
	}
	if {$tcl_platform(platform) == "windows"} {
	    if {[regexp "\[^\\\\\]+\$" $name nm]} {
		if {![catch {deleteMenuItem -m $openWindowsMenu $nm}]} { return } 
	    }
	}
	set nm $name
    }
    # to handle alpha problem with rebuilding the menu
    if {[catch {deleteMenuItem -m $openWindowsMenu $nm}]} { 
	deleteMenuItem $openWindowsMenu $nm 
    }
}

proc win::renameInMenu {oldName newName} {
    win::removeFromMenu $oldName
    win::addToMenu $newName
}
