#  AlphaTcl - core Tcl engine
# Note that if Alpha upgrades to Tcl 8.0, these procs should be replaced
# with simple wrappers around the Tcl procs 'file mkdir' 'file copy' etc.
# (the built in Tcl 8.0 ones are more robust and cope better with the
# Mac filesystem than Alpha's procedures)
#================================================================================

# improvements, first version by Mark Nagata, then Vince and recently 
# Johan improved them further (and fixed bugs)
proc cp args {
    eval movecopy cp copy $args
}

proc mv args {
    eval movecopy mv move $args
}

proc movecopy {cmd0 cmd args} {
    global file::separator
    if {[llength $args] < 2} {
	error "usage: $cmd0 <file1> <file2>\r       $cmd0 <file1> .... <dir>"
    }
    set dir [lindex $args end]
    if {![regexp -- "${file::separator}" $dir] && $dir != ""} {
	set dir "${file::separator}$dir"
    }
    if {[regexp -- "${file::separator}\$" $dir]} {
	set dir [string trimright $dir ${file::separator}]
    }
    set args [lreplace $args end end]
    set files {}
    foreach arg $args {
	eval lappend files [glob -nocomplain $arg]
    }
    set report ""
    if {[llength $files] == 1} {
	set f [lindex $files 0]
	if {[file exists $dir]} {
	    set targ [file join $dir [file tail $f]]
	    append report "$f >-> $targ \r"
	    ${cmd}File $f $targ
	} else {
	    append report "$f >-> $dir \r"
	    ${cmd}File $f $dir
	}
    } else {
	if {$dir != ""} {
	    if {[regexp -- "^${file::separator}" $dir]} {
		file::ensureDirExists "[pwd][string range $dir 1 end]"
	    } else {
		regexp -- "^\[^${file::separator}\]+${file::separator}" $dir disk
		if {![file exists $disk]} {error "No disk '$disk'"}
		file::ensureDirExists $dir
	    }
	}
	foreach f $files {
	    message [file tail $f]
	    set targ [file join $dir [file tail $f]]
	    if {[catch {${cmd}File $f $targ} that]} {
		append report "Error trying to $cmd '$f': $that\r"
	    } else {
		append report "$f >-> $targ \r"
	    }
	}
    }
    echo [string trimright $report]
}

proc rm args {
    set opts(-r) 0
    getOpts
    set files {}
    foreach arg $args {
	eval lappend files [glob -nocomplain $arg]
    }
    __rm $opts(-r) $files
}

proc __rm {recurse names} {
    foreach f $names {
	if {[file isdirectory $f]} {
	    if {$recurse} {
		__rm $recurse [glob -nocomplain -dir $f * .*]
	    } 
	    file delete $f
	} else {			
	    message [file tail $f]		
	    file delete $f				
	}			
    }
}

proc textToAlpha {{dir ""}} {
    set num 0
    if {![string length $dir]} {
	set dir [get_directory -p "Creators to 'ALFA':"]
    }
    
    foreach f [glob -nocomplain -dir $dir *] {
	if {[file isfile $f] && ([getFileType $f] == "TEXT") && ([getFileSig $f] != "ALFA")} {
	    message $f
	    setFileInfo $f creator ALFA
	    incr num
	} elseif {[file isdirectory $f]} {
	    incr num [textToAlpha $f]
	}
    }
    message "Converted $num files"
    return $num
}
