## -*-Tcl-*-
 # ###################################################################
 #  AlphaTcl - core Tcl engine
 # 
 #  FILE: "alphaCommands.tcl"
 #                                    created: 03/18/1998 {01:13:44 AM} 
 #                                last update: 08/11/2001 {13:36:40 PM} 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #  
 # Copyright (c) 1999-2001 Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution of
 # this file, and for a DISCLAIMER OF ALL WARRANTIES.
 #  
 #  Description: 
 # 
 #   Mostly procedures which would really help Alpha if they were
 #   hard-coded.  Some other procedures for convenience are here too.
 # ###################################################################
 ##

if {${alpha::platform} != "alpha"} {
    alertnote "Shouldn't load this code!"
    return
}

# Not sure if this should really deal with rectangular selections
proc selectLimits {} {
    if {[pos::compare [getPos] == [selEnd]]} {
	return [list]
    } else {
	return [list [getPos] [selEnd]]
    }
}

namespace eval tmark {}

## 
 # -------------------------------------------------------------------------
 # 
 # "tmark::getPos" --
 # 
 #  This procedure is pretty slow, due to limitations in Alpha.  In
 #  Alpha 8, we'll have a hard-wired quick version.  It also works
 #  around a bug in which Alpha tells us that windows which aren't
 #  files (e.g. just created with 'new -n') are located in Alpha's
 #  'pwd' directory.
 #  
 #  The stupid thing is that Alpha knows exactly where each stop is, but
 #  it won't tell us!  'gotoTMark $m' goes to exactly the position we
 #  want, but we can't find it out some other way.
 # -------------------------------------------------------------------------
 ##
if {[info tclversion] < 8.0} {
    proc tmark::getPos {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" f
	if {[file exists $f]} {
	    if {[regexp "\{$m \{[quote::Regfind $f]\} (\[0-9\]+) \[0-9\]+\}" [getTMarks] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{$m \{[quote::Regfind [pwd]$f]\} (\[0-9\]+) \[0-9\]+\}" [getTMarks] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc tmark::getPos {m {f ""}} { 
	if {$f == ""} {
	    return [lindex [getPosOfTMark $m] 0] 
	} else {
	    return [lindex [getPosOfTMark -w $f $m] 0] 
	}
    }

}
if {[info tclversion] < 8.0} {
    proc tmark::getRange {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" df
	if {[file exists $df]} {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind $df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+) \}" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind [pwd]$df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+) \}" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc tmark::getRange {m {f ""}} { 
	if {$f == ""} {
	    return [getPosOfTMark $m]
	} else {
	    return [getPosOfTMark -w $f $m]
	}
    }

}
namespace eval mark {}
if {[info tclversion] < 8.0} {
    proc mark::getRange {m {f ""}} {
	if {$f == ""} {set f [win::Current]}
	regsub { <[0-9]+>$} $f "" df
	if {[file exists $df]} {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind $df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+)" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	} else {
	    if {[regexp "\{ \{$m\} \{[quote::Regfind [pwd]$df]\} (\[0-9\]+ \[0-9\]+ \[0-9\]+)" [getNamedMarks -w $f] "" where]} {
		return $where
	    }
	}
	error "No such mark"
    }
} else {
    proc mark::getRange {m {f ""}} { 
	if {$f == ""} {
	    return [getPosOfMark $m]
	} else {
	    return [getPosOfMark -w $f $m]
	}
    }

}

## 
 # -------------------------------------------------------------------------
 # 
 # "tmark::getPositions" --
 # 
 #  For speed you can ask for a bunch of positions at once.
 # -------------------------------------------------------------------------
 ##
if {[info tclversion] < 8.0} {
    proc tmark::getPositions {mm} {
	regexp {(.*) <[0-9]+>$} [set f [win::Current]] "" f
	if {[file exists $f]} {
	    set reg " \{[quote::Regfind $f]\} (\[0-9\]+) \[0-9\]+\}"
	} else {
	    set reg " \{[quote::Regfind [pwd]$f]\} (\[0-9\]+) \[0-9\]+\}"
	}
	set marks [getTMarks]
	foreach m $mm {
	    if {[regexp "\{$m$reg" $marks "" where]} {
		lappend res $where
	    } else {
		error "No such mark"
	    }
	}
	return $res
    }
} else {
    proc tmark::getPositions {mm} {
	foreach m $mm {
	    lappend res [lindex [getPosOfTMark $m] 0]
	}
	return $res
    }
}

if {[info tclversion] < 8.0} {

proc tmark::isAt {p} {
    regexp {(.*) <[0-9]+>$} [set f [win::Current]] "" f
    if {[file exists $f]} {
	if {[regexp "\{(stop\[0-9\]+:\[0-9\]+) \{[quote::Regfind $f]\} $p $p\}" [getTMarks] "" which]} {
	    return $which
	}
    } else {
	if {[regexp "\{(stop\[0-9\]+:\[0-9\]+) \{[quote::Regfind [pwd]$f]\} $p $p\}" [getTMarks] "" which]} {
	    return $which
	}
    }
    return ""
}

} else {
    proc tmark::isAt {p} { return [isTMarkAt $p] }
}

# Thanks to Johan Linde:
proc refresh {{w ""}} {
    if {$w == ""} {
	if {[string length [win::Current]]} {
	    eval [list sizeWin] [lrange [getGeometry] 2 end]
	}
    } else {
	eval [list sizeWin $w] [lrange [getGeometry $w] 2 end]
    }
}


namespace eval text {}

proc text::hyper {from to hyper} {
    text::color $from $to 15 $hyper
}

proc text::color {from to colour {hyper ""}} {
    if {[is::Integer $colour]} {
	if {$colour > 7} {
	    if {$colour == 15} {
		insertColorEscape $from $colour $hyper
	    } else {
		insertColorEscape $from $colour
	    }
	    insertColorEscape $to 12
	} else {
	    insertColorEscape $from $colour
	    insertColorEscape $to 0
	}
    } else {
	insertColorEscape $from $colour
	insertColorEscape $to 12
	insertColorEscape $to 0
    }
}

namespace eval pos {}

proc pos::compare {args} {uplevel expr $args}
proc pos::math {args} {uplevel expr $args}
proc pos::diff {p1 p2} {uplevel [list expr abs($p1 - $p2)]}
proc minPos {} { return 0 }




