## -*-Tcl-*-
 # ###################################################################
 #  AlphaTcl - core Tcl engine
 # 
 #  FILE: "alphaMenus.tcl"
 #                                    created: 98-04-07 07.36.22 
 #                                last update: 10/31/2001 {14:24:15 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom
 # Fetherston, Johan Linde and suggestions from the alphatcl-developers
 # mailing list.  Alpha is shareware; please register with the author
 # using the register button in the about box.
 #  
 # Description:
 # 
 #  Initialises variables which contain the global menus.  If you 
 #  use the smarterSource package, you can over-ride these quite
 #  easily.  This file is sourced by the procedure 'menu::buildSome'
 #  which handles menu building.
 # ###################################################################
 ##
#  File menu  #
set menu::items(File) {
    "/Nnew"
    "/Oopen"
    "<B<O/OopenRemote"
    "<S/Wclose"
    "<S<O<U/WcloseFloat"
    "<S<I<O/WcloseAll"
    "(-"
    "<S/Ssave"
    "<S<B<O/SsaveUnmodified"
    "<S<I<O/SsaveAll"
    "<SsaveACopyAs"
    "<S<UrenameTo"
    "<SsaveAs"
    "revert"
    "(-"
    {Menu -n fileUtils -p menu::fileUtils {}}
    "(-"
    "pageSetup"
    "/P<Sprint"
    "printAll"
    "(-"
    "/Qquit"
}
lappend menu::which_subs(File) "fileUtils"
set menu::proc(File) menu::fileProc

#  Edit menu  #
set menu::items(Edit) {
    "/Zundo"
    "/Z<I<Oredo"
    "(-"
    "/X<Scut"
    "/C<Scopy"
    "/V<Spaste"
    "/A<SselectAll"
    "/A<S<I<OselectParagraph"
    "clear"
    "(-"
    "/`<Stwiddle"
    "/`<S<I<OtwiddleWords" 
    "(-" 
    {/[<SshiftLeft} 
    {/[<S<I<OshiftLeftSpace} 
    {/]<SshiftRight} 
    {/]<S<I<OshiftRightSpace} 
    "/Bbalance" 
}

#  Text menu  #
set menu::items(Text) {
    "/I<SfillParagraph"
    "/I<S<O<IwrapParagraph"
    "/I<S<O<I<UsentenceParagraph"
    "/U<S<OfillRegion"
    "/U<S<I<OwrapRegion"
    "/U<S<O<I<UsentenceRegion"
    "<E<SparagraphToLine"
    "<SlineToParagraph"
    "(-"
    "<SreverseSort"
    "<S<UsortParagraphs"
    "<SsortLines"
    "(-"
    "zapInvisibles"
    "<SspacesToTabs"
    "<StabsToSpaces"
    "<S<EindentSelection"
    "<SIndentLine"
    "<E<SdowncaseRegion"
    "<SupcaseRegion"
    "(-"
    {Menu -n Strings {
	"<SremovePrefix"
	"<SinsertPrefix"
	"<S<EremoveSuffix"
	"<SinsertSuffix"
	"setPrefix"
	"setSuffix"}
    }
    "/D<ScommentLine"
    "/D<S<I<OuncommentLine"
    "<SuncommentBox"
    "<ScommentBox"
    "<S<EuncommentParagraph"
    "<ScommentParagraph"
}
set menu::proc(Text) menu::textProc

proc menu::textProc {menu item} {
    switch -- $item {
	"commentLine"             comment::Line
	"uncommentLine"           comment::undoLine
	"commentBox"              comment::Box
	"uncommentBox"            comment::undoBox
	"commentParagraph"        comment::Paragraph
	"uncommentParagraph"      comment::undoParagraph
	"uncommentLine"           comment::undoLine
	"fillParagraph"           paragraph::fill
	"sentenceParagraph"       paragraph::sentence
	"indentLine"              bind::IndentLine
	default                 {eval $item}
    }
}

#  Search menu  #
set menu::items(Search) {
    "/F<Sfind"
    "/F<S<I<OsearchStart"
    "/G<SfindAgain"
    "/G<S<I<OfindAgainBackward"
    "/MfindInNextFile"
    "/E<SenterSearchString"
    "/E<S<I<OenterReplaceString"
    "(-"
    "/S<S<BquickFind"
    "/S<S<B<IquickFindRegexp"
    "/R<BreverseQuickFind"
    "(-"
    "/Rreplace"
    "/Hreplace&FindAgain"
    "<S/R<O<IreplaceAll"
    "<S/R<O<I<BreplaceInFileset"
    "(-"
    "/,<BplaceBookmark"
    "/.<BreturnToBookmark"
    "/G<I<BgotoLine"
    "(-"
    "/M<I<OmatchingLines" 
    "gotoMatch" 
    "/M<BnextMatch"
    "(-"
    "/K<I<OgotoFunc"
    "/K<O<BgotoFileMark"
    "/=markHilite"
    {Menu -n namedMarks -p namedMarkProc {
	"markFile"
	"displayNamedMarks"
	"/F<O<UfloatNamedMarks"
	"(-"
	"/K<OsetNamedMark"
	"removeNamedMark"
	"removeAllMarks"
	"(-"
	"sortAlphabetically"
	"sortByPosition"}
    }
    {Menu -n unnamedMarks -p unnamedMarkproc {
	"/ <BsetUnnamedMark"
	"exchangePointAndMark"}
    }
}
set menu::proc(Search) ""

#  Utils menu  #
set menu::proc(fileUtils) menu::fileUtils
set menu::proc(winUtils) menu::fileUtils
set menu::items(fileUtils) {
    "fileRemove"
    "fileInfo"
    "textToAlpha"
    "showInFinder"
}
set menu::items(winUtils) {
    "insertPathName"
    "insertFile"
}

set menu::items(Utils) {
    {Menu -n winUtils -p menu::fileUtils {}}
    {Menu -n asciiEtc {
	"quoteChar"
	"(-"
	"keyCode"
	"keyAscii"
	"getAscii"
	"insertAscii"}
    }
    "(-"
    "<S/Y<Oshell"
    "<S/Y<U<Ocalculator"
    "<S/Y<B<OtoolserverShell"
    "<S/L<O<IspellcheckWindow"
    "<S/L<O<I<BspellcheckSelection"
    "wordCount"
    "(-" 
    "sendUrl"
    "/jcmdDoubleClick"
}
set menu::proc(Utils) ""
lappend menu::which_subs(Utils) "winUtils"

#  Config menu  #

set menu::items(Config) {
    {Menu -n preferences {}} 
    {Menu -n packages -p menu::packagesProc {}}
    {Menu -n "Mode Prefs" -p mode::menuProc {}}
    "setupAssistant"
    "createNewMode"
    "(-"
    "/lsetFontsTabs"
    "specialKeys" 
    "/kdescribeBinding"
    "listPackages" 
    "<SlistGlobalBindings" 
    "<SlistAllBindings" 
    "listFunctions" "(-" 
    "viewSavedSetting"
    "removeSavedSetting"
    "(-"
    {Menu -n redefineColors -p menu::colorProc {
	foreground
	background
	"(-"
	blue
	cyan
	green
	magenta
	red
	white
	yellow
	"(-"
	color_9
	color_10
	color_11
	color_12
	color_13
	color_14
	color_15}
    }
}
set menu::proc(Config) "menu::globalProc"
lappend menu::which_subs(Config) mode packages preferences
proc removeSavedSetting {} {prefs::removeSavedSetting}
proc viewSavedSetting {} {prefs::viewSavedSetting}


