##
## This is file `dialogsNew.tcl',
## generated with the docstrip utility.
##
## The original source files were:
##
## dialogsNew.dtx  (with options: `core')
## 
## ===================================================================
## AlphaTcl - core Tcl engine
## 
## Source file version data:
##                                    created: 12/1/96 {5:36:49 pm}
##                                last update: 11/28/2001 {09:56:38 AM}
##  Author: Vince Darley
##  E-mail: <vince@santafe.edu>
##    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
##     www: <http://www.santafe.edu/~vince/>
##
##  Author: Lars Hellstr\"om
##  E-mail: <Lars.Hellstrom@math.umu.se>
##
## Copyright (c) 1997-2001  Vince Darley, Lars Hellstr\"om
## Distributed under Tcl style free license.
## ===================================================================
namespace eval dialog {}
if {${alpha::platform}=="alpha"} then {
   set code 0
   foreach w {0 6 12 12 6 14 11 14 0 4 16 14 14 0 6 6 9 11 11 9 11 6 6\
     16 12 9 12 11 13 6 6 6 4 6 7 10 7 11 10 3 5 5 7 7 4 7 4 7 8 8 8 8\
     8 8 8 8 8 8 4 4 6 8 6 8 11 8 8 8 8 7 7 8 8 6 7 9 7 12 9 8 8 8 8 7\
     6 8 8 12 8 8 8 5 7 5 8 8 6 8 8 7 8 8 6 8 8 4 6 8 4 12 8 8 8 8 6 7\
     6 8 8 12 8 8 8 5 5 5 8 6 8 8 8 7 9 8 8 8 8 8 8 8 8 7 8 8 8 8 4 4\
     4 4 8 8 8 8 8 8 8 8 8 8 5 6 7 9 7 7 9 8 10 10 11 6 6 9 11 8 14 7\
     6 6 8 10 8 9 10 11 6 7 7 10 12 8 8 6 7 12 6 8 9 9 9 14 8 8 8 8 11\
     12 6 10 7 7 4 4 7 9 8 8 3 8 6 6 10 10 5 4 4 7 15 8 7 8 7 7 6 6 6\
     6 8 8 11 8 8 8 8 4 6 8 6 6 6 6 6 6 6 6} {
      if {[info tclversion] < 8.1} then {
         set charwidth([format %c $code]) $w
      } else {
         set charwidth([encoding convertfrom [format %c $code]]) $w
      }
      incr code
   }
   proc dialog::text_width {str} {
      global charwidth
      set w 0
      foreach ch [split $str ""] {incr w $charwidth($ch)}
      set w
   }
} else {
   proc dialog::text_width {str} {font measure system $str}
}

# This is duplicated from dialogUtils.tcl
if {${alpha::platform} == "alpha"} {
    set dialog::strlength 253
} else {
    set dialog::strlength 2000
}

if {${alpha::platform} == "alpha"} then {
   proc dialog::width_abbrev {str width {ratio 0.33}} {
      global charwidth dialog::ellipsis
      set w 0
      set tw [expr {$width - [dialog::text_width ${dialog::ellipsis}]}]
      set abbr ""
      set t [expr {$ratio * $tw}]
      foreach ch [split $str ""] {
         incr w $charwidth($ch)
         if {$w < $t} then {append abbr $ch}
      }
      if {$w <= $width} then {return $str}
      append abbr ${dialog::ellipsis}
      set t [expr {(1-$ratio) * $tw}]
      foreach ch [split $str ""] {
         if {$w < $t} then {append abbr $ch}
         incr w -$charwidth($ch)
      }
      set abbr
   }
} else {
   proc dialog::width_abbrev {str width {ratio 0.33}} {
      global dialog::ellipsis
      if {[font measure system $str] <= $width} then {return $str}
      set tw [expr {$width - [font measure system ${dialog::ellipsis}]}]
      set lower -1
      set upper [expr {[string length $str] - 1}]
      set t [expr {$ratio * $tw}]
      while {$upper - $lower > 1} {
         set middle [expr {($upper + $lower) / 2}]
         if {[font measure system [string range $str 0 $middle]] > $t}\
         then {set upper $middle} else {set lower $middle}
      }
      set abbr [string range $str 0 $lower]
      append abbr ${dialog::ellipsis}
      set upper [string length $str]
      set t [expr {(1 - $ratio) * $tw}]
      while {$upper - $lower > 1} {
         set middle [expr {($upper + $lower) / 2}]
         if {[font measure system [string range $str $middle end]] > $t}\
         then {set lower $middle} else {set upper $middle}
      }
      append abbr [string range $str $upper end]
   }
}
if {![info exists dialog::ellipsis]} then {
   if {[info tclversion] >= 8.1} then {
      set dialog::ellipsis \u2026
   } else {
      set dialog::ellipsis \xc9
   }
}
proc dialog::width_linebreak {str w} {
   if {![string length $str]} then {return {}}
   set res [list]
   foreach s [split $str \r] {
      lappend res \r
      foreach s2 [split $s \n] {
         eval [list lappend res]\
           [dialog::width_linebreak2 [string trim $s2] $w]
      }
   }
   lrange $res 1 end
}
if {${alpha::platform} == "alpha"} then {
   proc dialog::width_linebreak2 {str w} {
      global charwidth
      set res [list]
      set line ""
      set more ""
      set x 0
      set was 1
      foreach ch [split $str ""] {
         set is [expr {$ch==" " || $ch=="\t"}]
         if {!$is && $was} then {
            if {![string length $line]} then {
               set more ""
               set x 0
            }
            set x0 $x
         } elseif {$is && !$was} then {
            append line $more
            set more ""
         }
         set was $is
         incr x $charwidth($ch)
         if {$x>=$w} then {
            if {[string length $line]} then {
               lappend res $line
               set line ""
               set more [string trimleft $more]
               set x [expr {$x-$x0}]
            } else {
               lappend res $more
               set more ""
               set x $charwidth($ch)
            }
            set x0 0
         }
         append more $ch
      }
      set line [string trim "$line$more"]
      if {[string length $line]} then {lappend res $line}
      return $res
   }
} else {
   proc dialog::width_linebreak2 {str w} {
      set res [list]
      set idx -1
      while {[regexp -indices -start [expr {$idx+1}] -- {\S($|\s)} $str t]} {
         if {$w > [dialog::text_width\
             [string range $str 0 [lindex $t 0]]]} then {
            set idx [lindex $t 0]
         } elseif {$idx>=0} then {
            lappend res [string range $str 0 $idx]
            set str [string trim [string range $str [expr {$idx+1}] end]]
            set idx -1
         } else {
            set upper [lindex $t 0]
            set lower 0
            while {$upper-$lower>1} {
               set middle [expr {($upper+$lower)/2}]
               if {$w > [dialog::text_width\
                   [string range $str 0 $middle]]}\
               then {set lower $middle} else {set upper $middle}
            }
            lappend res [string range $str 0 $lower]
            set str [string trim [string range $str [expr {$lower+1}] end]]
            set idx -1
         }
      }
      if {$idx>=0} then {lappend res [string range $str 0 $idx]}
      return $res
   }
}
ensureset dialog::globalCount 0
proc dialog::create {} {
    global dialog::globalCount
    incr dialog::globalCount
    upvar #0 "dialog::changed_tcldial${dialog::globalCount}" chvar
    set chvar [list]
    return "tcldial${dialog::globalCount}"
}
proc dialog::cleanup {mod} {
    global dialog::${mod} dialog::changed_${mod}
    if {[info exists dialog::${mod}]} {
        unset dialog::${mod}
    }
    if {[info exists dialog::changed_${mod}]} {
        unset dialog::changed_${mod}
    }
}
proc dialog::valGet {mod name} {
    uplevel #0 [list set dialog::${mod}($name)]
}
proc dialog::valSet {mod name val} {
    uplevel #0 [list set dialog::${mod}($name) $val]
}
proc dialog::valExists {mod name} {
    uplevel #0 [list info exists dialog::${mod}($name)]
}
proc dialog::valChanged {mod name val} {
   global dialog::${mod} dialog::changed_${mod}
   if {![info exists dialog::${mod}($name)] \
     || ($val != [set dialog::${mod}($name)])} {
       set dialog::${mod}($name) $val
       lunion dialog::changed_${mod} $name
   }
}
proc dialog::changed_items {mod} {
    uplevel #0 [list set dialog::changed_${mod}]
}
proc dialog::handle {pages typevar dial helpvar pagevar optionL args} {
   global dialog::indentsame dialog::indentnext dialog::simple_type\
     dialog::complex_type alpha::platform
   upvar 1 $typevar typeA $helpvar helpA $pagevar currentpage
   if {![info exists currentpage]} then {
      set currentpage [lindex $pages 0]
   }
   set opts(-title) ""
   set opts(-width) 400
   array set opts $optionL
   while {1} {
      set res [list]
      set ymax 4
      set left 20
      set right [expr {$opts(-width) - 10}]
      set multipage [expr {[llength $pages] > 2}]
      set pagemenu [list $currentpage]
      set helpL [list]
      set postprocL [list]
      newforeach {page items} $pages {
         if {$multipage} then {
            lappend res -n $page
            lappend pagemenu $page
            set y 42
         } else {
            set y 38
         }
         foreach name $items {
            set type $typeA($page,$name)
            set val [dialog::valGet $dial $page,$name]
            set help {}
            catch {set help $helpA($page,$name)}
            set script [list dialog::valChanged $dial $page,$name]
            append script { [lindex $res $count]}
            set visible 1
            while {1} {
               if {[llength $type] == 1} then {
                  if {![info exists dialog::simple_type($type)]}\
                  then {set type var}
                  eval [set dialog::simple_type($type)]
               } elseif {[info exists\
                    dialog::complex_type([lindex $type 0])]} then {
                  eval [set dialog::complex_type([lindex $type 0])]
               } else {
                  dialog::cleanup $dial
                  error "Unsupported item type '$type'"
               }
               break
            }
            if {$visible} then {
               incr y 7
	       if {[info exists help]} {lappend helpL $help}
            }
            lappend postprocL $script
         }
         if {$y > $ymax} {set ymax $y}
      }
      incr ymax 6
      set buttons [list]
      set button_help [list]
      set button_press [list]
      set l $left
      set r $right
      foreach group $args {
         set b_names [list]
         set b_help [list]
         set b_press [list]
         newforeach {name help val} [lindex $group 0] {
            lappend b_names $name
            lappend b_help $help
            lappend b_press $val
         }
         set group [lrange $group 1 end]
         set b_names [dialog::makeSomeButtons $b_names\
           [expr {[lsearch -exact $group "right"] >= 0}]\
           $left l r $right ymax]
         if {[lsearch -exact $group "first"] < 0} then {
            eval [list lappend buttons] $b_names
            eval [list lappend button_help] $b_help
            eval [list lappend button_press] $b_press
         } else {
            set buttons [concat $b_names $buttons]
            set button_help [concat $b_help $button_help]
            set button_press [concat $b_press $button_press]
         }
      }
      if {![llength $button_press]} then {
         dialog::cleanup $dial
         error "No buttons in dialog."
      }
      incr ymax 33
      if {$multipage} then {
         set res [concat [list -m $pagemenu 100 10 300 29] $buttons $res]
         set helpL [concat\
           [list {Use this popup menu or the cursor keys to go to\
            a different page of the dialog.}]\
           $button_help $helpL]
      } else {
         set currentpage [lindex $pages 0]
         set res [concat [list -t $currentpage 100 10 300 25]\
           $buttons $res]
         set helpL [concat $button_help $helpL]
      }
      if {[info tclversion] >= 8.0} then {
         set res [eval [list dialog -w $opts(-width) -h $ymax\
           -T $opts(-title)] $res [list -help $helpL]]
      } else {
         if {[catch\
           [concat [list dialog -w $opts(-width) -h $ymax] $res]\
           res]} then {
            dialog::cleanup $dial
            alertnote "Sorry, you encountered a bug in Alpha 7's\
              'dialog' command, which cannot handle very complex\
              dialogs. If you are trying to edit many items at once,\
              try to edit them just one at a time."
            error "Internal bug in 'dialog'."
         }
      }
      if {$multipage} then {
         set currentpage [lindex $res 0]
      } else {
         set res [linsert $res 0 $currentpage]
      }
      set count [expr {[llength $button_press] + 1}]
      foreach script $postprocL {
         eval $script
         incr count
      }
      set count [lsearch -exact\
        [lrange $res 1 [llength $button_press]] 1]
      if {$count>=0} then {return [lindex $button_press $count]}
   }
}
proc dialog::makeSomeButtons {titleL justification xmin leftvar\
  rightvar xmax yvar {minwidth 58}} {
   upvar 1 $leftvar left $rightvar right $yvar y
   set widthL [list]
   foreach title $titleL {
      set w [expr {[dialog::text_width $title] + 17}]
      if {$w < $minwidth} then {set w $minwidth}
      lappend widthL $w
   }
   if {[expr [join $widthL "+13+"]] > $right - $left &&\
     ($xmin<$left || $right<$xmax)} then {
      incr y 33
      set left $xmin
      set right $xmax
   }
   set n 0
   foreach title $titleL {
      set w [lindex $widthL $n]
      incr n
      if {$w > $right - $left && ($xmin<$left || $right<$xmax)} then {
         incr y 33
         set left $xmin
         set right $xmax
      }
      lappend res -b $title
      if {$justification} then {
         lappend res [expr {$right-$w}] $y $right [expr {$y+20}]
         set right [expr {$right - $w - 13}]
      } else {
         lappend res $left $y [incr left $w] [expr {$y+20}]
         incr left 13
      }
   }
   set res
}
set dialog::indentsame 80
set dialog::indentnext 40
proc dialog::makeEditItem {mvar svar left right yvar name val {lines 1}\
  {minwidth 110} {maxwidth {}}} {
    upvar 1 $mvar M $yvar y
    global dialog::indentsame dialog::indentnext
    if {$maxwidth==""} then {set maxwidth [expr {$right-$left}]}
    set nw [expr {[dialog::text_width $name] + 1}]
    if {$nw<${dialog::indentsame}-13} then {
        set nw [expr {${dialog::indentsame}-13}]
    }
    if {$lines == 1 && $nw+19+$minwidth < $right-$left ||\
      $nw+19+$maxwidth <= $right-$left} then {
        incr y 3
        lappend M -t $name $left $y [expr {$left+$nw}] [expr {$y+15}]
        set ew [expr {$right - $left - $nw - 19}]
        if {$ew>$maxwidth} then {set $ew $maxwidth}
        lappend M -e $val [expr {$left+$nw+16}] $y\
          [expr {$left+$nw+$ew+16}] [expr {$y + 16*$lines - 1}]
    } else {
        lappend M -t $name $left $y [expr {$left+$nw}] [expr {$y+15}]
        incr y 19
        set ew [expr {$right - $left - ${dialog::indentnext} - 6}]
        if {$ew>$maxwidth} then {set $ew $maxwidth}
        lappend M -e $val [expr {$right - 3 - $ew}] $y\
          [expr {$right - 3}] [expr {$y + 16*$lines - 1}]
    }
    set y [expr {$y + 16*$lines + 2}]
}
array set dialog::simple_type {var\
  {dialog::makeEditItem res script $left $right y $name $val}}
array set dialog::simple_type {var2\
  {dialog::makeEditItem res script $left $right y $name $val 2}}
array set dialog::simple_type {password {
   set nw [expr {[dialog::text_width $name] + 1}]
   lappend res -t $name $left $y [expr {$left + $nw}] [expr {$y + 15}]
   incr nw 13
   if {$nw<${dialog::indentsame}} then {set nw ${dialog::indentsame}}
   regsub -all {.} $val { } vv
   lappend res -e $vv [expr {$left + $nw + 3}] [expr {$y + 6}]\
     [expr {$right - 3}] [expr {$y + 7}]
   incr y 15
   set script [list set T $page,$name]
   append script {
      regsub -all {.} [dialog::valGet $dial $T] { } vv
      if {[lindex $res $count] != $vv} then {
         dialog::valChanged $dial $T [lindex $res $count]
      }
   }
}}
proc dialog::lines_to_text {lineL left right yvar} {
   upvar 1 $yvar y
   global dialog::strlength
   set res [list]
   set item_lines [list]
   set item_length -1
   foreach line $lineL {
      if {$line!="\r"} then {
         incr item_length [expr {1 + [string length $line]}]
         if {${dialog::strlength}<$item_length} then {
            lappend res -t [join $item_lines \r] $left $y $right\
              [incr y [expr {[llength $item_lines] * 16}]]
            set item_lines [list $line]
            set item_length [string length $line]
         } else {
            lappend item_lines $line
         }
      } else {
         if {[llength $item_lines]} then {
            lappend res -t [join $item_lines \r] $left $y $right\
              [incr y [expr {[llength $item_lines] * 16}]]
         }
         incr y 6
         set item_lines [list]
         set item_length -1
      }
   }
   if {[llength $item_lines]} then {
      lappend res -t [join $item_lines \r] $left $y $right\
        [incr y [expr {[llength $item_lines] * 16}]]
   }
   if {[llength $res]} then {incr y -1}
   return $res
}
array set dialog::simple_type {text {
    eval [list lappend res] [dialog::lines_to_text\
      [dialog::width_linebreak $name [expr {$right-$left}]]\
      $left $right y]
    unset help
    set script {continue}
}}
array set dialog::simple_type {static {
    set nw [expr {[dialog::text_width $name] + 1}]
    if {$nw<${dialog::indentsame}-13} then {
        set nw [expr {${dialog::indentsame}-13}]
    }
    lappend res -t $name $left $y [expr {$left+$nw}] [expr {$y+15}]
    set vw [expr {[dialog::text_width $val] + 1}]
    lappend res -t $val
    if {$nw + 13 + $vw < $right - $left} then {
        lappend res [expr {$left + $nw + 13}] $y
    } else {
        incr y 16
        lappend res [expr {$left + ${dialog::indentnext}}] $y
    }
    lappend res $right [incr y 15]
    unset help
    set script {continue}
}}
set dialog::mute_types [list text static]
array set dialog::simple_type {flag {
    lappend res -c $name $val
    if {[info tclversion]>=8.0} then {lappend res -font 2}
    lappend res $left $y $right [incr y 15]
}}
array set dialog::complex_type {multiflag {
   eval [list lappend res] [dialog::lines_to_text\
      [dialog::width_linebreak $name [expr {$right-$left}]]\
      $left $right y]
   set flag_list [lindex $type 1]
   set y2 $y
   set r [expr {($left+$right)/2 - 5}]
   set l [expr {($left+$right)/2 + 5}]
   for {set n 0} "\$n < ([llength $flag_list]+1)/2" {incr n} {
      lappend res -c [lindex $flag_list $n] [lindex $val $n]
      if {[info tclversion]>=8.0} then {lappend res -font 2}
      lappend res $left [incr y 3] $r [incr y 15]
   }
   for {} "\$n < [llength $flag_list]" {incr n} {
      lappend res -c [lindex $flag_list $n] [lindex $val $n]
      if {[info tclversion]>=8.0} then {lappend res -font 2}
      lappend res $l [incr y2 3] $right [incr y2 15]
   }
   while {[llength $help]<[llength $flag_list]} {lappend help ""}
   eval [list lappend helpL] $help
   unset help
   set script [list dialog::valChanged $dial $page,$name]
   append script { [lrange $res $count [incr count }
   append script [expr {[llength $flag_list] - 1}] {]]}
}}
proc dialog::makeMenuItem {mvar svar left right yvar name itemL value} {
    upvar 1 $mvar M $yvar y
    global dialog::indentsame dialog::indentnext
    set nw [expr {[dialog::text_width $name]+1}]
    set itemL [linsert $itemL 0 $value]
    if {$nw<${dialog::indentsame}} then {set nw ${dialog::indentsame}}
    if {$right - $left - $nw < 50} then {
       lappend M -t $name $left $y [expr {$left+$nw}] [incr y 15]
       incr y 5
       lappend M -m $itemL [expr {$left+${dialog::indentnext}+1}]
    } else {
       incr y
       lappend M -t $name $left $y [expr {$left+$nw}] [expr {$y+15}]
       lappend M -m $itemL [expr {$left+$nw+14}]
    }
    lappend M $y [expr {$right-2}] [incr y 18]
}
array set dialog::complex_type {menu\
  {dialog::makeMenuItem res script $left $right y $name\
    [lindex $type 1] $val}}
array set dialog::simple_type {colour {
    global alpha::colors
    dialog::makeMenuItem res script $left $right y $name\
      ${alpha::colors} $val
} mode {
    dialog::makeMenuItem res script $left $right y $name\
      [linsert [mode::listAll] 0 "<none>"] $val
}}
array set dialog::complex_type {menuindex {
    set script [list dialog::valChanged $dial $page,$name]
    append script { [} [list lsearch -exact [lindex $type 1]]
    append script { [lindex $res $count]]}
    catch {lindex [lindex $type 1] $val} val
    dialog::makeMenuItem res script $left $right y $name\
      [lindex $type 1] $val
}}
proc dialog::makeSetItem {Mvar Svar left right yvar name bscript} {
   upvar 1 $Mvar M $Svar S $yvar y
   global dialog::ellipsis dialog::indentsame
   set nw [expr {[dialog::text_width $name]+1}]
   set bw [expr {[dialog::text_width "Set${dialog::ellipsis}"] + 17}]
   lappend M -t $name $left $y [expr {$left + $nw}] [expr {$y + 15}]
   lappend M -b "Set${dialog::ellipsis}"
   if {[info tclversion]>=8.0} then {
      lappend M -set [list $bscript +1]
      set S {}
   } else {
      set S [list if {[lindex $res $count] == 1} then $bscript]
   }
   lappend M [expr {$right - $bw}] $y $right [expr {$y + 15}]
   set nw [expr {$nw+13}]
   if {$nw<${dialog::indentsame}} then {set nw ${dialog::indentsame}}
   list [expr {$left + $nw}] $y [expr {$right - $bw - 13}] [incr y 15]
}
proc dialog::makeStaticValue\
  {left right yvar value subopt {ratio 0.33} {rect {0 0 0 0}}} {
   global dialog::indentnext alpha::platform
   upvar 1 $yvar y
   set vw [expr {[dialog::text_width $value] + 1}]
   if {[lindex $rect 2] - [lindex $rect 0] >= $vw} then {
      set res [list -t $value]
      if {${alpha::platform} != "alpha"} then {
         set res [concat $res $subopt]
      }
      if {[lindex $rect 3] > $y} then {set y [lindex $rect 3]}
      concat $res $rect
   } else {
      set res [list -t]
      lappend res [dialog::width_abbrev $value\
        [expr {$right - $left - ${dialog::indentnext} - 1}] $ratio]
      if {${alpha::platform} != "alpha"} then {
         set res [concat $res $subopt]
      }
      incr y
      lappend res [expr {$left + ${dialog::indentnext}}] $y\
        $right [incr y 15]
   }
}
array set dialog::simple_type {binding {
    set R [dialog::makeSetItem res script $left $right y $name\
      [list dialog::specialSet::binding $dial "$page,$name"]]
    set vv [dialog::specialView::binding $val]
    eval [list lappend res]\
      [dialog::makeStaticValue $left $right y $vv {} 0.33 $R]
}}
array set dialog::simple_type {file {
    set R [dialog::makeSetItem res script $left $right y $name\
      [list dialog::specialSet::file $dial "$page,$name"]]
    eval lappend res\
      [dialog::makeStaticValue $left $right y $val\
      [list "-dnd" $dial [list "$page,$name" $type]] 0.33 $R]
} folder {
    set R [dialog::makeSetItem res script $left $right y $name\
      [list dialog::specialSet::folder $dial "$page,$name"]]
    eval lappend res\
      [dialog::makeStaticValue $left $right y $val\
      [list "-dnd" $dial [list "$page,$name" folder]] 0.33 $R]
} url {
    set R [dialog::makeSetItem res script $left $right y $name\
      [list dialog::specialSet::url $dial "$page,$name"]]
    eval lappend res\
      [dialog::makeStaticValue $left $right y $val\
      [list "-dnd" $dial [list "$page,$name" $type]] 0.33 $R]
}\
  date {
    set R [dialog::makeSetItem res script $left $right y $name\
      [list dialog::specialSet::date $dial "$page,$name"]]
    eval lappend res\
      [dialog::makeStaticValue $left $right y [clock format $val]\
        {} 1 $R]
}}
array set dialog::simple_type {appspec {
    if {${alpha::platform} == "alpha" &&\
      [regexp {^'(....)'$} $val "" sig]} then {
        if {[catch {nameFromAppl $sig} vv]} then {
           set vv "Unknown application with sig '$sig'"
        }
    } else {
        set vv $val
    }
    set R [dialog::makeSetItem res script $left $right y $name\
         [list dialog::set_appspec $dial $page $name "Select $name"]]
    eval lappend res\
      [dialog::makeStaticValue $left $right y $vv {} 0.33 $R]
}}
proc dialog::set_appspec {dial page name prompt} {
   global alpha::platform
   set val [dialog::valGet $dial $page,$name]
   if {${alpha::platform} == "alpha" &&\
     [regexp {^'(....)'$} $val "" sig]} then {
      catch {nameFromAppl $sig} val
   }
   if {[catch {getfile $prompt $val} val]} then {return ""}
   if {${alpha::platform} == "alpha"} then {
      set sig [getFileSig $val]
      set app [nameFromAppl $sig]
      if {$app != $val} then {
         catch {
            if {[dialog::yesno -y "Path" -n "Sig" -c\
              "Application sig '$sig' is mapped to '$app', not '$val'.\
              Which should I use?"]}\
            then {dialog::valChanged $dial $page,$name $val}\
            else {dialog::valChanged $dial $page,$name '$sig'}
         }
      } else {
         dialog::valChanged $dial $page,$name '$sig'
      }
   } else {
      dialog::valChanged $dial $page,$name $val
   }
}
if {${alpha::platform} == "alpha"} then {
   array set dialog::simple_type {searchpath {
      set R [dialog::makeSetItem res script $left $right y $name\
        [list dialog::specialSet::searchpath $dial "$page,$name"]]
      if {![llength $val]} then {
         eval [list lappend res]\
           [dialog::makeStaticValue $left $right y\
             "No search paths currently set." {} 1 $R]
      } else {
         foreach path $val {
            eval [list lappend res]\
              [dialog::makeStaticValue $left $right y $path {}]
         }
      }
   }}
} else {
   array set dialog::simple_type {searchpath {
      dialog::makeSetItem res script $left $right y $name\
        [list dialog::specialSet::searchpath $dial "$page,$name"]
      lappend res "-l" $val 3
      lappend res "-dnd" $dial [list "$page,$name" searchpath]
      lappend res [expr {$left + ${dialog::indentnext}}] [incr y]\
        $right [incr y 51]
   }}
}
proc dialog::edit_subset {setL dial page name prompt} {
   if {![catch {
      listpick -p $prompt -l -L [dialog::valGet $dial $page,$name] $setL
   } res]} then {
      set val [list]
      catch {
          foreach item $res {lappend val $item}
          dialog::valChanged $dial $page,$name $val
      }
   }
}
array set dialog::complex_type {subset {
    dialog::makeSetItem res script $left $right y $name\
      [list dialog::edit_subset [lindex $type 1] $dial $page $name\
        "Edit subset"]
    eval [list lappend res]\
      [dialog::makeStaticValue $left $right y $val {} 1]
}}
array set dialog::simple_type {modeset {
    dialog::makeSetItem res script $left $right y $name\
      [list dialog::edit_subset [mode::listAll] $dial $page $name\
        "Select modes"]
    eval [list lappend res]\
      [dialog::makeStaticValue $left $right y $val {} 1]
}}
array set dialog::complex_type {prefItemType {
    set type [dialog::prefItemType [lindex $type 1]]
    continue
}}
array set dialog::simple_type {thepage {
   set script [list dialog::valChanged $dial $page,$name]
   append script { $currentpage
      continue
   }
   set visible 0
}}

proc dialog::hide_item {page item {typevar typeA}} {
   upvar 1 $typevar typeA
   set typeA($page,$item) [linsert $typeA($page,$item) 0 hidden]
}
proc dialog::show_item {page item {typevar typeA}} {
   upvar 1 $typevar typeA
   if {[lindex $typeA($page,$item) 0]=="hidden"} then {
      set typeA($page,$item) [lreplace $typeA($page,$item) 0 0]
   }
}
array set dialog::complex_type {hidden {
   set script {continue}
   set visible 0
}}
proc dialog::make {args} {
   set opts(-ok) OK
   set opts(-cancel) Cancel
   set opts(-title) ""
   set opts(-width) 400
   set opts(-debug) 0
   set opts(-hidepages) [list]
   getOpts {-title -defaultpage -ok -cancel -addbuttons -width -debug\
     -hidepages}
   set dial [dialog::create]
   set pages [list]
   foreach pagearg $args {
      set page [lindex $pagearg 0]
      set pageA($page) [list]
      foreach item [lrange $pagearg 1 end] {
         set name [lindex $item 1]
         set typeA($page,$name) [lindex $item 0]
         dialog::valSet $dial $page,$name [lindex $item 2]
         if {[llength $item]>3} then {
            set helpA($page,$name) [lindex $item 3]
         }
         lappend pageA($page) $name
      }
      if {[lsearch -exact $opts(-hidepages) $page]<0} then {
         lappend pages $page $pageA($page)
      }
   }
   if {[info exists opts(-defaultpage)]} then {
      set currentpage $opts(-defaultpage)
   } else {
      set currentpage [lindex $pages 0]
   }
   set optionL [list -width $opts(-width) -title $opts(-title)]
   set main_buttons [list\
     [list $opts(-ok) "Click here to use the current settings."\
       {set retCode 0}\
       $opts(-cancel) "Click here to discard any\
       changes you've made to the settings." {set retCode 1;\
       set retVal "cancel"}]\
     first right]
   set state 0
   while {![info exists retCode]} {
      if {[info exists opts(-addbuttons)]} then {
         set script [dialog::handle $pages typeA $dial helpA\
           currentpage $optionL [list $opts(-addbuttons)]\
           $main_buttons]
      } else {
         set script [dialog::handle $pages typeA $dial helpA\
           currentpage $optionL $main_buttons]
      }
      if {[catch $script err]} then {
         global errorInfo
         set errinfo $errorInfo
         if {$opts(-debug)} then {
            tclLog "Error in button script '$script'"
            tclLog $err
         }
         dialog::cleanup $dial
         return -code 1 -errorinfo $errinfo\
           "Error '$err' when evaluating button script."
      }
   }
   if {$retCode==0} then {
      set retVal [list]
      global dialog::mute_types
      foreach pagearg $args {
         set page [lindex $pagearg 0]
         foreach item [lrange $pagearg 1 end] {
            if {[lsearch -exact ${dialog::mute_types}\
              [lindex [lindex $item 0] 0]] < 0}\
            then {lappend retVal\
              [dialog::valGet $dial "$page,[lindex $item 1]"]}
         }
      }
   }
   dialog::cleanup $dial
   return -code $retCode $retVal
}
proc dialog::make_paged {args} {
   set opts(-ok) OK
   set opts(-cancel) Cancel
   set opts(-title) ""
   set opts(-width) 400
   set opts(-debug) 0
   getOpts {-title -defaultpage -ok -cancel -addbuttons -width -debug\
     -changedpages -changeditems}
   set dial [dialog::create]
   set pages [list]
   set delta_pages [list]
   foreach pagearg $args {
      eval [list dialog::add_page] $pagearg
   }
   set delta_pages [list]
   if {[info exists opts(-defaultpage)]} then {
      set currentpage $opts(-defaultpage)
   } else {
      set currentpage [lindex $pages 0]
   }
   set optionL [list -width $opts(-width) -title $opts(-title)]
   set main_buttons [list\
     [list $opts(-ok) "Click here to use the current settings."\
       {set retCode 0}\
       $opts(-cancel) "Click here to discard any\
       changes you've made to the settings."\
       {set retCode 1; set retVal "cancel"}]\
     first right]
   set state 0
   while {![info exists retCode]} {
      if {[info exists opts(-addbuttons)]} then {
         set script [dialog::handle $pages typeA $dial helpA\
           currentpage $optionL [list $opts(-addbuttons)]\
           $main_buttons]
      } else {
         set script [dialog::handle $pages typeA $dial helpA\
           currentpage $optionL $main_buttons]
      }
      if {[catch $script err]} then {
         global errorInfo
         set errinfo $errorInfo
         if {$opts(-debug)} then {
            tclLog "Error in button script '$script'"
            tclLog $err
         }
         dialog::cleanup $dial
         return -code 1 -errorinfo $errinfo\
           "Error '$err' when evaluating button script."
      }
   }
   if {$retCode==0} then {
      set retVal [list]
      global dialog::mute_types
      foreach page $delta_pages {
         foreach name $pageA($page) {
            lappend cA($page) $keyA($page,$name)
         }
      }
      foreach item [dialog::changed_items $dial] {set cS($item) ""}
      newforeach {page items} $pages {
         set res [list]
         foreach name $items {
            set T "$page,$name"
            if {[lsearch -exact ${dialog::mute_types}\
                 [lindex $typeA($T) 0]] < 0} then {
               lappend res $keyA($T) [dialog::valGet $dial $T]
               if {[info exists cS($T)]} then {
                  lunion cA($page) $keyA($T)
               }
            }
         }
         lappend retVal $page $res
      }
      if {[info exists opts(-changedpages)]} then {
         upvar 1 $opts(-changedpages) cp
         set cp [array names cA]
      }
      if {[info exists opts(-changeditems)]} then {
         upvar 1 $opts(-changeditems) ci
         set ci [array get cA]
      }
   }
   dialog::cleanup $dial
   return -code $retCode $retVal
}
proc dialog::add_page {page keyvalL itemsL {pos end}} {
   upvar pageA pageA typeA typeA helpA helpA keyA keyA\
      dial dial pages pages delta_pages delta_pages
   array set local $keyvalL
   set pageA($page) [list]
   lunion delta_pages $page
   foreach item $itemsL {
      set key [lindex $item 0]
      set name [lindex $item 2]
      set keyA($page,$name) $key
      if {[info exists local($key)]} then {
         dialog::valSet $dial $page,$name $local($key)
      } else {
         dialog::valSet $dial $page,$name ""
      }
      set typeA($page,$name) [lindex $item 1]
      if {[llength $item]>3} then {
         set helpA($page,$name) [lindex $item 3]
      }
      lappend pageA($page) $name
   }
   if {$pos!="end"} then {
      set pages [linsert $pages [expr {2*$pos}] $page $pageA($page)]
   } else {
      lappend pages $page $pageA($page)
   }
}
proc dialog::delete_pages {pages deleteL {deletedvar {}}} {
   set res [list]
   if {$deletedvar!=""} then {upvar 1 $deletedvar diffL}
   newforeach {page items} $pages {
      if {[lsearch -exact $deleteL $page] == -1} then {
         lappend res $page $items
      } else {
         lunion diffL $page
      }
   }
   return $res
}
proc dialog::prefItemType {prefname} {
    global flag::list
    if {[info exists flag::list($prefname)]} {
        set l [set flag::list($prefname)]
        if {[regexp "index" [lindex $l 0]]} {
            set res [list menuindex]
        } else {
            set res [list menu]
        }
        lappend res [flag::options $prefname]
    } elseif {[regexp "Colou?r$" $prefname]} {
        return "colour"
    } elseif {[regexp "Mode$" $prefname]} {
        return "mode"
    } else {
        return "var"
    }
}
proc dialog::editGroup {args} {
    global dialog::ellipsis
    set opts(-current) ""
    set opts(-title) "Edit"
    getOpts {-array -title -current -new -delete}
    upvar $opts(-array) local
    set dialog [list]
    foreach item [lsort -ignore [array names local]] {
        lappend dialog [list $item $local($item) $args]
    }
    set buttons [list]
    if {[info exists opts(-delete)]} {
        if {$opts(-delete)=="dontask"} then {
           lappend buttons "Delete" "Click here to delete this page"\
             {set pages [dialog::delete_pages $pages\
                [list $currentpage] delta_pages]}
        } else {
           lappend buttons "Delete${dialog::ellipsis}"\
             "Click here to delete this page" {
                if {[dialog::yesno "Are you sure you want to\
                  delete '$currentpage'?"]} {
                    set pages [dialog::delete_pages $pages\
                      [list $currentpage] delta_pages]
                }
             }
        }
    }
    if {[info exists opts(-new)]} {
        lappend buttons "New${dialog::ellipsis}"\
          "Click here to add a new page"\
          [list dialog::editGroupNewPage $args $opts(-new)]
    }
    if {[llength $buttons]} {
        set buttons [list -addbuttons $buttons]
    }
    set res [eval [list dialog::make_paged -title $opts(-title)\
      -defaultpage $opts(-current) -changedpages mods] $buttons $dialog]
    unset local
    array set local $res
    return $mods
}
proc dialog::editGroupNewPage {layout cmd} {
   set T [eval $cmd]
   if {![llength $T]} then {return}
   newforeach {page items} [uplevel 1 {set pages}] {
      if {$page==[lindex $T 0]} then {
         alternote "That name is already in use!"
         return
      }
   }
   uplevel 1 [concat dialog::add_page $T [list $layout]]
   uplevel 1 [list set currentpage [lindex $T 0]]
}
## 
##
## End of file `dialogsNew.tcl'.
