# If we have already sourced this file, then this variable will exist
if {[info exists global::features]} { return }

# First basic initialisation: (works with Alpha 7.2.1 or 8.0 development)
if {[info tclversion] < 8.0} {
    ;proc namespace {cmd ns script} {if {$script != ""} {uplevel $script}}
    ;proc variable {n} { global mode ; uplevel 1 [list upvar \#0 $mode::$n $n] }
    ;proc renameMenuItem {args} {}
} else {
    namespace eval alpha {
	namespace eval index {}
	namespace eval cache {}
    }
    namespace eval win {}
    if {[info commands scancontext] == ""} {
	namespace eval scancontext {
	    namespace export *
	}
	proc scancontext::scancontext {cmd args} {
	    switch -- $cmd {
		"create" {
		    uplevel 1 {
			set __scan 0
			while {1} {
			    incr __scan
			    variable scancontext$__scan
			    if {![array exists scancontext$__scan]} {
				break
			    }
			}
			set scancontext[set __scan]() 1
			return scancontext$__scan
		    }
		}
		"delete" {
		    variable [lindex $args 0]
		    unset [lindex $args 0]
		}
	    }
	}
    
	proc scancontext::scanmatch {scanid regexp script args} {
	    if {[string match "-*" $scanid]} {
		set flags $scanid
		set scanid $regexp
		set regexp [list $flags $script]
		set script [lindex $args 0]
	    } else {
		set regexp [list -- $regexp]
	    }
	    variable $scanid
	    set ${scanid}($regexp) $script
	    return $scanid
	}
    
	proc scancontext::scanfile {scanid fid} {
	    variable $scanid
	    upvar matchInfo m
	    set m(linenum) 0
	    set m(offset) 0
	    set m(handle) $fid
	    set names [array names $scanid]
	    while {[set count [gets $fid m(line)]] >= 0} {
		incr m(linenum)
		incr m(offset) [expr {$count +1}]
		foreach reg $names {
		    if {$reg == ""} {continue}
		    if {[regexp [lindex $reg 0] [lindex $reg 1] $m(line) \
		      "" m(submatch0) m(submatch1) m(submatch2)]} {
			incr m(offset) [expr {-[string length $m(submatch0)]}]
			uplevel 1 [set ${scanid}($reg)]
			incr m(offset) [string length $m(submatch0)]
		    }
		}
	    }
	}
	namespace import scancontext::*
    }
    rename lsort __lsort
    proc lsort {args} {
	if {[lindex $args 0] == "-ignore"} {
	    eval __lsort -dictionary [lrange $args 1 end]
	} else {
	    eval __lsort $args
	}
    }
    # Tcl 8.0 doesn't handle \t \r \n , but Tcl 8.1 will
    if {[info tclversion] == 8.0} {
	rename regexp __regexp
	proc regexp {args} {
	    set i 0
	    while {[string match -* [set a [lindex $args $i]]]} {
		incr i
		if {$a == "--"} {
		    set a [lindex $args $i]
		    break
		}
	    }
	    __regsub -all "\\\\t" $a "\t" a
	    __regsub -all "\\\\r" $a "\r" a
	    __regsub -all "\\\\n" $a "\n" a
	    __regsub -all "\\\\w" $a "\[a-zA-Z0-9_\]" a
	    __regsub -all "\\\\s" $a "\[ \t\r\n\]" a
	    uplevel __regexp [lreplace $args $i $i $a]
	}
	rename regsub __regsub
	proc regsub {args} {
	    set i 0
	    while {[string match -* [set a [lindex $args $i]]]} {
		incr i
		if {$a == "--"} {
		    set a [lindex $args $i]
		    break
		}
	    }
	    __regsub -all "\\\\" $a "" a
	    __regsub -all "\\\\t" $a "\t" a
	    __regsub -all "\\\\r" $a "\r" a
	    __regsub -all "\\\\n" $a "\n" a
	    __regsub -all "\\\\w" $a "\[a-zA-Z_\]" a
	    __regsub -all "\\\\s" $a "\[ \t\r\n\]" a
	    __regsub -all "" $a "\\\\" a
	    uplevel __regsub [lreplace $args $i $i $a]
	}
    }
    
    if {$tcl_platform(platform) == "macintosh" \
      && [llength [info commands alert]] > 0} {
        
        rename alertnote __alertnote
        ;proc alertnote {args} {
            alert -t stop -c "" -o "" [lindex $args 0] [join [lrange $args 1 end] " "]
            return
        }


        rename askyesno __askyesno
        ;proc askyesno {args} {
            if {[lindex $args 0] == "-c"} {
                set button [alert -t caution -k "Yes" -c "No" -o "Cancel" -C other [lindex $args 1]]
            } else {
                set button [alert -t caution -k "Yes" -c "No" -o "" -C none [lindex $args 0]]
            }
               
            return [string tolower $button]
        }


        rename buttonAlert __buttonAlert
        ;proc buttonAlert {prompt args} {
            set buttonCount [llength $args]

            if {$buttonCount > 3} {
                eval __buttonAlert [list $prompt] $args
            } else {
                set cmd [list alert -t caution -c "" -o ""]
                if {$buttonCount > 0} {
                    set defaultText [lindex $args 0]
                    lappend cmd -k $defaultText
                    if {[string tolower $defaultText] == "cancel"} {
                        lappend cmd -C ok -K cancel
                    } 
                    if {$buttonCount > 1} {
                        set cancelText [lindex $args 1]
                        lappend cmd -c $cancelText
                        if {[string tolower $cancelText] == "cancel"} {
                            lappend cmd -C cancel
                        } 
                        if {$buttonCount > 2} {
                            set otherText [lindex $args 2]
                            lappend cmd -o $otherText
                            if {[string tolower $otherText] == "cancel"} {
                                lappend cmd -C other
                            } 
                        }
                    }
                }
                
                lappend cmd $prompt
                    
                eval $cmd
            }
        }
    } else {
	if {[info commands alert] == "alert"} {
	    rename alert __alert
	}
	;proc alert {args} {
	    set opts(-h) 0
	    
	    getOpts {t c k o C K O}
	    
	    return [buttonAlert $args $opts(-k) $opts(-c) $opts(-o)]
	}
    }
}    

# We define the 'alpha::macos' variable as follows:
if {(($tcl_platform(platform) == "macintosh")||($tcl_platform(platform) == "unix" && $tcl_platform(os) == "Darwin"))} {
    set alpha::macos 1
} else {
    set alpha::macos 0
}

# Get the Tcl environment setup correctly
if {[catch [list source [file join $HOME Tcl SystemCode initTcl.tcl]] err]} {
    alertnote "There was a bad problem while sourcing initTcl.tcl"
    error $err
}

# Read Alpha's version information
if {[catch [list source [file join $HOME Tcl SystemCode alphaVersionInfo.tcl]] err]} {
    alertnote "There was a bad problem while sourcing alphaVersionInfo.tcl"
    error $err
}
# PREFS points to a folder 'Alpha', we add the major version number
append PREFS "-v[lindex [split ${alpha::version} .] 0]"

if {[info commands alphaOpen] == ""} {
    # Can be overridden to cope with cross-platform encoding issues
    proc alphaOpen {args} { uplevel 1 open $args }
}
if {[info commands alpha::showStartupVersions] != ""} {
    alpha::showStartupVersions
}
if {![info exists alpha::modifier_keys]} {
    set alpha::modifier_keys [list "Command" "cmd" "Option" "opt"]
}

# This flag will be cleared once our gui has been constructed. Currently
# this means both that the standard menus have been created, and that
# we are ready to create windows (e.g. 'new ...' will work).
set alpha::guiNotReady 1
set alpha::changingMode 0
if {$tcl_platform(platform) == "macintosh" && [info tclversion] > 8.0} {
    if {"\u0192" != ""} {
	if {![file exists [file join [info library] encoding]]} {
	    alertnote "Your 'encoding' directory inside Tcl's library\
	      '[info library]' doesn't seem to exist.  This will\
	      probably cause serious problems."
	} else {
	    alertnote "Unknown encoding problem.  Make sure you\
	      have installed Tcl properly.  This will\
	      probably cause serious problems."
	}
    }
}
# source v. important code
if {[catch [list source [file join $HOME Tcl SystemCode library.tcl]] err]} {
    alertnote "There was a bad problem while sourcing library.tcl"
    error $err
}
if {[catch [list source [file join $HOME Tcl SystemCode coreFixes.tcl]] err]} {
    alertnote "There was a bad problem while sourcing coreFixes.tcl"
    error $err
}
# check if the user over-rides things
if {[file exists [file join ${HOME} AlphaPrefs]] \
  && [file isdirectory [file join ${HOME} AlphaPrefs]]} {
    foreach PREFS [glob -types d -dir $HOME *] {
	if {[string tolower [file join ${HOME} alphaprefs]] ==
	[string tolower $PREFS]} {
	    break
	}
    }
} else {		
    if {![file exists $PREFS]} { 
	if {[catch {file mkdir $PREFS}]} {
	    alertnote "I cannot locate or create your preferences\
	      directory '$PREFS'.  From now on I'll try to use \
	      '[file join ${HOME} AlphaPrefs]' instead."
	    set PREFS [file join ${HOME} AlphaPrefs]
	    if {![file exists $PREFS]} { 
		if {[catch {file mkdir $PREFS}]} {
		    alertnote "Sorry, I couldn't make '$PREFS'.  Alpha\
		      requires a preferences directory to run.  Please fix\
		      this problem and then try to rerun Alpha.  Goodbye."
		    quit
		}
	    }
	} else {
	    # We have to be careful here; Alpha has hardly started up so we can't
	    # yet access most of AlphaTcl.
	    set major_version [lindex [split ${alpha::version} .] 0]
	    if {[file tail $PREFS] == "Alpha-v$major_version"} {
		# We just created a new folder for a major version of Alpha
		set prev_prefs [file join [file dirname $PREFS] "Alpha-v[expr {$major_version -1}]"]
		if {[file exists $prev_prefs]} {
		    # And it was an upgrade, since the old prefs folder exists.
		    # If the old version is compatible, copy it over
		    if {[info exists alpha::majorUpgradePrefsCompatible]} {
			if {[askyesno "You just upgraded to a new major version\
			  ${alpha::version} from [expr {$major_version -1}].x.\
			  Would you like me to copy over your preferences (they should\
			  be compatible)?"] == "yes"} {
			    # Copy contents of prev prefs to new $PREFS
			    if {[catch {eval file copy [glob -dir $prev_prefs *] [list $PREFS]}]} {
				alertnote "There was an error copying your preferences;\
				  this may cause problems"
			    }
			}
		    } else {
			alertnote "You just upgraded to a new major version\
			  ${alpha::version} from [expr {$major_version -1}].x.\
			  The preferences are largely incompatible between these\
			  two versions, so you'll have to re-enter them."
		    }
		    # Then ask if we should delete the old one
		    if {[askyesno "Should I delete your old preferences?"] == "yes"} {
			if {[catch {file delete -force $prev_prefs}]} {
			    alertnote "There was an error deleting your old preferences;\
			      you might want to delete '$prev_prefs' manually."
			}
		    }
		}
		unset prev_prefs
	    }
	    unset major_version
	}
    }
}

if {[info tclversion] < 8.0} {
    set auto_path {}
}

if {[catch [list alpha::makeAutoPath 0 $skipPrefs] err]} {
    alertnote "There was a bad problem while making the autopath"
    error $err
}
# Check whether we are likely to have some bad problems
# usually caused by corrupt/badly out of date Tcl
# indices, or a bad/partial installation.
set initAlphaTclErr [expr {!([auto_load cache::readContents] \
  && [auto_load prefs::loadEarlyConfiguration])}]

proc alpha::evaluateWhenGuiIsReady {args} {
    global alpha::guiNotReady
    if {[info exists alpha::guiNotReady]} {
	foreach a $args {
	    hook::register startupHook $a
	}
    } else {
	foreach a $args {
	    uplevel 1 $a
	}
    }
}

# IMPORTANT: it is vital we get to this point in the startup sequence
# without any errors.  From this point on if we hit any errors, we
# should be able to handle them reasonably gracefully, although
# even then we might force/ask the user to quit.  However errors prior
# to this point probably can't even be dealt with in a useful way,
# basically because we only load the 'unknown' procedure just above.

# get known packages
catch {cache::readContents index::feature}
catch {cache::readContents index::requirements}
# get list of packages of flag type
catch {cache::readContents index::flags}
# load any early preferences (e.g. list of active packages)
# from special cache
namespace eval global {}
if {!$skipPrefs} {
    catch {prefs::loadEarlyConfiguration}
    catch {unset mode::defaultfeatures}
}
if {![info exists global::features]} {
    set global::features ""
    set firsttime 1
}
