# If configuration has changed, rebuild indices

# Note that if the 'initAlphaTclErr' variable doesn't exist, we probably
# should never have reached here.  It is defined towards the end of
# the sourcing of initAlphaTcl.tcl.
if {![info exists initAlphaTclErr]} {
    alertnote "Error loading 'rebuildAlphaTcl.tcl'; the 'initAlphaTclErr'\
      variable was not defined.  Please report this as a bug."
}

if {$initAlphaTclErr || \
  ([catch {alpha::checkConfiguration} initAlphaTclErr] || ($initAlphaTclErr == 1))} {
    alertnote "You have recently installed or upgraded Alpha,\
      or installed/removed one of its packages. \
      This means I have to rebuild the index of all\
      packages, which will take a little while."
    # For safety's sake:
    source [file join $HOME Tcl SystemCode CorePackages cache.tcl]
    source [file join $HOME Tcl SystemCode CorePackages fileManipulation.tcl]
    source [file join $HOME Tcl SystemCode stringsLists.tcl]
    source [file join $HOME Tcl SystemCode modes.tcl]
    source [file join $HOME Tcl SystemCode package.tcl]
    source [file join $HOME Tcl SystemCode CorePackages error.tcl]
    if {[info tclversion] < 8.0} {
	# so 'file volumes/pathtype' works.  Commented out now, because we
	# shouldn't need 'file volumes/pathtype' any more.
	# source [file join $HOME Tcl SystemCode CorePackages aemain.tcl]
    }
    # power-user can use 'option' to avoid the rebuild
    if {!([getModifiers] & 72)} {
	if {[catch {alpha::makeIndices} err]} {
	    alertnote "There was a bad problem while making the package indices."
	    alertnote $err
	    error $err
	}
	if {[catch {rebuildTclIndices} err]} {
	    alertnote "There was a bad problem while making the tcl indices."
	    alertnote $err
	    error $err
	}
	# For debugging
	#listpick $auto_path
    }
}
unset initAlphaTclErr

if {[alpha::package vcompare ${alpha::version} 7.2d1] < 0} {
    alertnote "This version of Alpha is too old.\
      Upgrade from\
      http://alpha.olm.net/ or\
      ftp://ftp.ucsd.edu/pub/alpha/ \
      \r\rI'll quit now."
    quit
}
