# Rebuild the package and tcl indices, if necessary
source [file join $HOME Tcl SystemCode rebuildAlphaTcl.tcl]

if {[catch {
    # pull in smarterSource and internationalMenus packages
    # if the user activated them
    lappend alpha::earlyPackages smarterSource internationalMenus
    alpha::package require Alpha
    foreach pkg [set alpha::earlyPackages] {
	if {[lsearch -exact ${global::features} $pkg] != -1} {
	    alpha::package require $pkg
	}
    }
    unset pkg
    # So we can handle times properly
    alpha::package require isoTime
    
    set alpha::packagesAlwaysOn [list Alpha AlphaTcl isoTime\
      filesets openWindowsMenu]
    if {${alpha::platform} != "alpha"} {
	lappend alpha::packagesAlwaysOn supersearch
	if {$tcl_platform(platform) == "windows"} {
	    lappend alpha::packagesAlwaysOn removeMetaKeyFromMenus
	}
    }
    if {(($tcl_platform(platform) == "macintosh")||($tcl_platform(platform) == "unix" && $tcl_platform(os) == "Darwin"))} {
	lappend alpha::packagesAlwaysOn tclAE
    }
    foreach pkg [set alpha::packagesAlwaysOn] {
	if {[lsearch -exact ${global::features} $pkg] == -1} {
	    set global::features [linsert ${global::features} 0 $pkg]
	}
    }
    unset pkg
}]} {
    set initAlphaTclErr 1
    if {[askyesno "There was a bad error starting up; your package indices seem\
      to have been corrupted.  Shall I rebuild them and try again?"] == "yes"} {
	# try again.
	source [file join $HOME Tcl SystemCode runAlphaTcl.tcl]
    }
    alertnote "Please quit and restart Alpha as soon as possible.  This may\
      resolve the problem."
}

# Delete all old temporary files
temp::cleanupAll

alpha::getDefinitions
if {[info exists firsttime]} {
    unset firsttime
    lappend global::features internationalMenus filesetMenu    
    if {!$skipPrefs} {
	# For the moment we will force the user to go
	# through this with every new release (see below)
	# setupAssistant
    }
}
if {!$skipPrefs} {
    # Read both scalar and array definitions from preferences folder.
    prefs::readAll
    if {[key::optionPressed]} {
    }
}
# define v. important keyboard variables
keys::keyboardChanged
message "Building basic menus"
menu::buildBasic
message "Binding keys"
alpha::basicKeyBindings
alpha::keyBindings
alpha::useElectricTemplates
# Read in all packages, modes and menus.
message "Reading in packages"
alpha::findAllPlugins
if {!$skipPrefs} {
    # read preferences file
    if {[catch {prefs::tclRead} err]} {
	append alpha::errorLog "\r" $err
	unset err
    }
}
# call anything that's attached to my keyboard.
hook::callAll keyboard $keyboard
message "Building complete menus"
# build all menus completely.
alpha::buildMainMenus
# insert menus
global::insertAllMenus
# Bind special keys
bind::fromArray keys::specialBindings keys::specialProcs

# if we do anything else to a menu, it must now be rebuilt
unset alpha::guiNotReady

# couple of random things
alpha::makeColourList

if {${alpha::platform} == "alpha"} {
    # Add to chars considered part of words.  In Alphatk,
    # Tcl is unicode aware and understands all of this stuff
    # already.
    addAlphaChars {_}
}

# Call all startup hooks
hook::callAll startupHook *
# Alerts and readme's for the user:

if {!$skipPrefs} {
    if {![info exists readReadme] \
      || ([lindex $readReadme 0] != [alpha::package versions Alpha]) \
      || ([lindex $readReadme 1] != [alpha::package versions AlphaTcl]) \
    } {
	# This may be removed later (see above)
	if {![info exists readReadme]} {set readReadme ""}
	setupAssistant $readReadme [list [alpha::package versions Alpha] \
	  [alpha::package versions AlphaTcl]]
	prefs::add readReadme [list [alpha::package versions Alpha] \
	  [alpha::package versions AlphaTcl]]
	if {[llength [set files [glob -nocomplain -path \
	  [file join $HOME Help Readme] *]]]} {
	    foreach f $files {
		# Don't show Alphatk readme in Alpha.
		if {${alpha::platform} != "tk"} {
		    if {[regexp "Alphatk\$" [file tail $f]]} {
			continue
		    }
		}
		helpMenu [file tail $f]
	    }
	    unset f
	    unset files
	} else {
	    alertnote "Alpha's readme file should be in\
	      '[file join $HOME Help]', but isn't.  You may wish\
	      to reinstall Alpha."
	}
    }
    if {[info exists readReadme]} {
	unset readReadme
    }
    
    if {[info exists alpha::readAtStartup]} {
	foreach f ${alpha::readAtStartup} {
	    catch {edit -r $f}
	}
	unset alpha::readAtStartup
	prefs::modified alpha::readAtStartup
    }
}

