# OpenVerse Server GUI
# 
# This is the GUI wrapper for the server source code.
#
# Module Name		- Server GUI
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMain
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

#NOTE
#
# Now using curley braces around functiosn for greater speed


proc KillServer {} {
	global MVS

	catch {close $MVS(server_socket)}
	foreach sckt $MVS(socks) {
		SendToUser $sckt "CHAT $MVS($sckt.name) Server Is Going Down!"
		DisconnectUser $sckt 1
	}
	set MVS(serving) 0
	if {[winfo exists .ovserver]} {destroy .ovserver}
	DoNames
}

proc AnnounceServer {} {
	global MVS MV
	SendToServer "URL * OpenVerse://$MV(MyIpAddress):$MVS(port)"
}

proc AnnounceServerToUser {person} {
	global MVS MV
	SendToServer "URL $MV(whois.$person) OpenVerse://$MV(MyIpAddress):$MVS(port)"
	SendToServer "URL $MV(nick) OpenVerse://$MV(MyIpAddress):$MVS(port)"
}

proc ConnectToOwn {} {
	global MVS MV
	Disconnect
	set MV(roomhost) 127.0.0.1
	set MV(roomport) $MVS(port)
	Connect
}

proc ClearServerLog {} {
	.ovserver.log delete 0.0 end
}

proc StartServer {} {
	global MVS

	if {[winfo exists .serverQuestion]} {destroy .serverQuestion}
	if $MVS(serving) {
		ReallyStartServer
		return
	}
	if ![tk_dialog .serverQuestion "Really Start Server?" \
		"This command will start a personal OpenVerse Server. Are you sure you want to do this? A personal server is used to invite people to chat in your own private room." \
		"" 1 "Start The Server" "Oops! Nevermind!"] {
		ReallyStartServer
	}

}

proc ReallyStartServer {} {
	global MV tcl_interactive MVS

	if ![winfo exists .ovserver] {
		toplevel .ovserver
		wm title .ovserver "Personal OpenVerse Server"
		frame .ovserver.buttons -relief sunken -borderwidth 1
		button .ovserver.buttons.close -text "Kill Server" -command {KillServer}
		button .ovserver.buttons.announce -text "Announce Server" -command {AnnounceServer}
		button .ovserver.buttons.connect -text "Connect" -command {ConnectToOwn}
		button .ovserver.buttons.clear -text "Clear Log" -command {ClearServerLog}
		button .ovserver.buttons.setup -text "Server Settings" -command {ServerSetup}
		frame .ovserver.buttons.info -relief raised -borderwidth 1
		label .ovserver.buttons.info.l -text "Users Connected"
		label .ovserver.buttons.info.v -text $MVS(users) -relief sunken -borderwidth 1
		text .ovserver.log
		pack .ovserver.buttons -fill both -expand y
		pack .ovserver.log -fill both -expand y
		pack .ovserver.buttons.close .ovserver.buttons.setup \
			.ovserver.buttons.announce .ovserver.buttons.connect \
			.ovserver.buttons.clear .ovserver.buttons.info \
			-side left -fill both -expand y
		pack .ovserver.buttons.info.l -side left \
			-fill both -expand y
		pack .ovserver.buttons.info.v -side left
	} 
	if $MVS(serving) {return} else {
		set tcl_interactive 1
		set homedir "$MV(homedir)"
		catch {source "$MV(libbase)/server.tcl"} err
		LogIt $err
		LogIt "Server Started - Your IP Address is $MV(MyIpAddress)"
	}
	set MVS(serving) 1
	Serv_CheckTimeouts
	DoNames
}

proc ServerSetup {} {
	global SMVS MVS MV

	if {[winfo exists .serversetup]} {destroy .serversetup}

	toplevel .serversetup
	wm title .serversetup "Server Settings"

	frame .serversetup.basic -relief raised -borderwidth 2
	frame .serversetup.ort -relief raised -borderwidth 2
	frame .serversetup.misc -relief raised -borderwidth 2
	frame .serversetup.buttons -relief raised -borderwidth 2

	pack .serversetup.basic .serversetup.misc .serversetup.ort -side top -fill both -expand y
	pack .serversetup.buttons -fill both -expand y -side bottom

	#
	# The basic settings block
	#
	frame .serversetup.basic.l -relief sunken -borderwidth 2
	frame .serversetup.basic.r -relief sunken -borderwidth 2
	frame .serversetup.basic.rr -relief sunken -borderwidth 2

	label .serversetup.basic.l.roomname -relief raised -borderwidth 2 \
		-text "Room Name"
	button .serversetup.basic.l.image -command ChooseServerImage \
		-text "Room Image" -borderwidth 2
	label .serversetup.basic.l.port -relief raised -borderwidth 2 \
		-text "Server Port"

	entry .serversetup.basic.r.roomname -textvariable SMVS(roomname)
	entry .serversetup.basic.r.image -textvariable SMVS(roomfile)
	entry .serversetup.basic.r.port -textvariable SMVS(port)

	frame .serversetup.basic.rr.l -relief sunken -borderwidth 2
	frame .serversetup.basic.rr.r -relief sunken -borderwidth 2
	label .serversetup.basic.rr.l.size -relief raised -borderwidth 2 \
		-text "Max Av Size"
	label .serversetup.basic.rr.l.users -relief raised -borderwidth 2 \
		-text "Max Users"
	label .serversetup.basic.rr.l.samehost -relief raised -borderwidth 2 \
		-text "Max Multiple Logins"

	frame .serversetup.basic.rr.r.size
	label .serversetup.basic.rr.r.size.sxl -relief raised -borderwidth 2 \
		-text "Width"
	entry .serversetup.basic.rr.r.size.sx -textvariable SMVS(maxwidth) -width 3
	label .serversetup.basic.rr.r.size.syl -relief raised -borderwidth 2 \
		-text "Height"
	entry .serversetup.basic.rr.r.size.sy -textvariable SMVS(maxheight) -width 3
	entry .serversetup.basic.rr.r.users -textvariable SMVS(maxusers)
	entry .serversetup.basic.rr.r.samehost -textvariable SMVS(max_same_users)
	
	pack .serversetup.basic.l .serversetup.basic.r \
		.serversetup.basic.rr -side left -fill both -expand y
	
	pack .serversetup.basic.l.roomname .serversetup.basic.l.image \
		.serversetup.basic.l.port -side top \
		-fill x -expand y

	pack .serversetup.basic.r.roomname .serversetup.basic.r.image \
		.serversetup.basic.r.port -side top \
		-fill x -expand y
	pack .serversetup.basic.rr.l .serversetup.basic.rr.r -side left \
		-fill both -expand y

	pack .serversetup.basic.rr.l.size .serversetup.basic.rr.l.users \
		.serversetup.basic.rr.l.samehost -side top -fill x -expand y

	pack .serversetup.basic.rr.r.size .serversetup.basic.rr.r.users \
		.serversetup.basic.rr.r.samehost -side top -fill x -expand y

	pack .serversetup.basic.rr.r.size.sxl \
		.serversetup.basic.rr.r.size.sx \
		.serversetup.basic.rr.r.size.syl \
		.serversetup.basic.rr.r.size.sy -side left -fill x -expand y
	#
	# The MISC Settings Block
	#
	scale .serversetup.misc.maxmsglen -from 100 -to 256 \
		-label "Max MSG Len" -variable SMVS(maxmsglen) \
		-orient horizontal -relief sunken -borderwidth 2
	checkbutton .serversetup.misc.push -text "Allow Push" \
		-variable SMVS(push)

	pack .serversetup.misc.maxmsglen .serversetup.misc.push -side left \
		-fill both -expand y

	#
	# The ORT Settings block.
	#
	frame .serversetup.ort.image
	frame .serversetup.ort.l -relief sunken -borderwidth 2
	frame .serversetup.ort.r -relief sunken -borderwidth 2

	frame .serversetup.ort.image.m
	canvas .serversetup.ort.image.c -height 70.0 -width 225.0 -relief \
		raised -borderwidth 2 -background black
	label .serversetup.ort.image.m.info -text "You can register your \
		server with an OpenVerse Rapid Transit System. Setup your \
		information here." -wraplength 350 -relief raised \
		-borderwidth 2
	frame .serversetup.ort.image.m.buttons
	menubutton .serversetup.ort.image.m.buttons.rating -text Rating \
		-menu .serversetup.ort.image.m.buttons.rating.m \
		-relief raised -borderwidth 2  -indicatoron 1
	menu .serversetup.ort.image.m.buttons.rating.m
	.serversetup.ort.image.m.buttons.rating.m add radiobutton -variable SMVS(ORT_Rating) \
		-value "G" -label "G"
	.serversetup.ort.image.m.buttons.rating.m add radiobutton -variable SMVS(ORT_Rating) \
		-value "PG" -label "PG"
	.serversetup.ort.image.m.buttons.rating.m add radiobutton -variable SMVS(ORT_Rating) \
		-value "R" -label "R"
	.serversetup.ort.image.m.buttons.rating.m add radiobutton -variable SMVS(ORT_Rating) \
		-value "X" -label "X"
	.serversetup.ort.image.m.buttons.rating.m add radiobutton -variable SMVS(ORT_Rating) \
		-value "XXX" -label "XXX"
	checkbutton .serversetup.ort.image.m.buttons.ort \
		-text "Register with ort" -variable SMVS(register_ort)

	label .serversetup.ort.l.server -relief raised -borderwidth 2 \
		-text "Ort Server"
	label .serversetup.ort.l.servername -relief raised -borderwidth 2 \
		-text "Ort Username"
	label .serversetup.ort.l.serverpassword -relief raised -borderwidth 2 \
		-text "Ort Password"
	label .serversetup.ort.l.location -relief raised -borderwidth 2 \
		-text "Ort Location"
	label .serversetup.ort.l.description -relief raised -borderwidth 2 \
		-text "Serv Description"
	label .serversetup.ort.l.slocation -relief raised -borderwidth 2 \
		-text "Serv Location"
	label .serversetup.ort.l.admin -relief raised -borderwidth 2 \
		-text "Serv Admin"
	label .serversetup.ort.l.website -relief raised -borderwidth 2 \
		-text "Serv Website"


	frame .serversetup.ort.r.server
	label .serversetup.ort.r.server.hl -relief raised -borderwidth 2 \
		-text "Host"
	entry .serversetup.ort.r.server.h -textvariable SMVS(ort_hostname)
	label .serversetup.ort.r.server.pl -relief raised -borderwidth 2 \
		-text "Port"
	entry .serversetup.ort.r.server.p -textvariable SMVS(ort_port)
	entry .serversetup.ort.r.servername -textvariable SMVS(ORT_Username)
	entry .serversetup.ort.r.serverpassword -textvariable SMVS(ORT_Password)
	frame .serversetup.ort.r.location
	label .serversetup.ort.r.location.xl -relief raised -borderwidth 2 \
		-text "X"
	entry .serversetup.ort.r.location.x -textvariable SMVS(ort_location_x)
	label .serversetup.ort.r.location.yl -relief raised -borderwidth 2 \
		-text "Y"
	entry .serversetup.ort.r.location.y -textvariable SMVS(ort_location_y)
	entry .serversetup.ort.r.description -textvariable SMVS(ORT_Description)
	frame .serversetup.ort.r.slocation
	label .serversetup.ort.r.slocation.cl -relief raised -borderwidth 2 \
		-text "State"
	entry .serversetup.ort.r.slocation.c -textvariable SMVS(ORT_State)
	label .serversetup.ort.r.slocation.col -relief raised -borderwidth 2 \
		-text "Country"
	entry .serversetup.ort.r.slocation.co -textvariable SMVS(ORT_Country)
	frame .serversetup.ort.r.admin
	label .serversetup.ort.r.admin.nl -relief raised -borderwidth 2 \
		-text "Name"
	entry .serversetup.ort.r.admin.n -textvariable SMVS(ORT_Admin)
	label .serversetup.ort.r.admin.el -relief raised -borderwidth 2 \
		-text "Email"
	entry .serversetup.ort.r.admin.e -textvariable SMVS(ORT_AdminEmail)
	entry .serversetup.ort.r.website -textvariable SMVS(ORT_WebSite)

	pack .serversetup.ort.image -side top -fill both -expand y
	pack .serversetup.ort.image.c -side right
	pack .serversetup.ort.image.m -side left -fill both -expand y
	pack .serversetup.ort.image.m.info .serversetup.ort.image.m.buttons -side top -fill both -expand y
	pack .serversetup.ort.image.m.buttons.rating \
		.serversetup.ort.image.m.buttons.ort -side left

	pack .serversetup.ort.l .serversetup.ort.r -side left -fill both \
		-expand y
	pack .serversetup.ort.l.server .serversetup.ort.l.servername \
		.serversetup.ort.l.serverpassword \
		.serversetup.ort.l.location \
		.serversetup.ort.l.description \
		.serversetup.ort.l.slocation \
		.serversetup.ort.l.admin .serversetup.ort.l.website \
		-side top -fill x -expand y
	pack .serversetup.ort.r.server .serversetup.ort.r.servername \
		.serversetup.ort.r.serverpassword \
		.serversetup.ort.r.location \
		.serversetup.ort.r.description \
		.serversetup.ort.r.slocation \
		.serversetup.ort.r.admin .serversetup.ort.r.website \
		-side top -fill x -expand y
	pack .serversetup.ort.r.server.hl .serversetup.ort.r.server.h \
		.serversetup.ort.r.server.pl .serversetup.ort.r.server.p \
		-side left -fill both -expand y
	pack .serversetup.ort.r.location.xl .serversetup.ort.r.location.x \
		.serversetup.ort.r.location.yl \
		.serversetup.ort.r.location.y -side left -fill both -expand y
	pack .serversetup.ort.r.slocation.cl \
		.serversetup.ort.r.slocation.c \
		.serversetup.ort.r.slocation.col \
		.serversetup.ort.r.slocation.co -side left -fill both -expand y
	pack .serversetup.ort.r.admin.nl .serversetup.ort.r.admin.n \
		.serversetup.ort.r.admin.el .serversetup.ort.r.admin.e \
		-side left -fill both -expand y
	

	#
	# The buttons block
	#
	button .serversetup.buttons.cancel -text Cancel -command {KillServerSetupWindow}
	button .serversetup.buttons.save -text "Save/Apply" -command {SaveServerSettings}
	
	pack .serversetup.buttons.save .serversetup.buttons.cancel -side \
		left -fill both -expand y

	#
	# End window creation.
	#
	# Load the variables.
	#
	set keys {}
	set toggle 0
	foreach var [array get MVS] {
		if {!$toggle} {
			lappend keys $var
			set toggle 1
		} else {
			set toggle 0
		}
	}
	foreach key $keys {
		set SMVS($key) $MVS($key)
	}
	if {[catch {set SMVS(ORT_Image)}]} {
		set SMVS(ORT_Image) "ov_tram_logo.gif"
	}
	catch {image create photo OpenVerse_Setup_Image_ORT -file "$SMVS(images)/$SMVS(ORT_Image)"} err
	if {[string compare $err "OpenVerse_Setup_Image_ORT"]} {
		LogIt "Unable to load ORT image!"
		set SMVS(ORT_Image) "ov_tram_logo.gif"
		image create photo OpenVerse_Setup_Image_ORT -file "$SMVS(images)/$SMVS(ORT_Image)"
	}
	set SMVS(ort_logo_image) [.serversetup.ort.image.c create image 113 35 -image OpenVerse_Setup_Image_ORT]
	if {[catch {set SMVS(ORT_Server)}]} {
		set SMVS(ORT_Server) {"207.0.217.22:4200"}
	}
	set SMVS(ort_hostname) [lindex [split $SMVS(ORT_Server) ":"] 0]
	set SMVS(ort_port) [lindex [split $SMVS(ORT_Server) ":"] 1]
	if {[catch {set SMVS(ORT_Location)}]} {
		set SMVS(ORT_Location) {}
		lappend SMVS(ORT_Location) "50 400"
	}
	set SMVS(ort_location_x) [lindex [split [lindex $SMVS(ORT_Location) 0]] 0]
	set SMVS(ort_location_y) [lindex [split [lindex $SMVS(ORT_Location) 0]] 1]
}

proc SaveServerSettings {} {
	global MV MVS SMVS
	set outfile [open "$MV(homedir)/pserver.cfg" w]

	if ![file exists "$MV(homedir)/rooms/[file tail $SMVS(roomfile)]"] {
		file copy "$SMVS(roomfile)" "$MVS(homedir)/rooms"
	}
	puts $outfile "# ----------------------------------------"
	puts $outfile "#"
	puts $outfile "# Personal Server Configuration File"
	puts $outfile "#"
	puts $outfile "# Created by OpenVerse ServerGUI"
	puts $outfile "# [clock format [clock seconds]]"
	puts $outfile "#"
	puts $outfile "# OpenVerse Version $MV(version)"
	puts $outfile "#"
	puts $outfile "# ----------------------------------------"
	puts $outfile "# NOTE: You can change this image name."
	puts $outfile "# The image you use MUST be a GIF file."
	puts $outfile "# The image you use MUST be 225 pixels wide."
	puts $outfile "# The image you use MUST be 70 pixels tall."
	puts $outfile "# The image you use MUST have a unique name."
	puts $outfile "# ----------------------------------------"
	puts $outfile "set MVS(ORT_Image) \"$SMVS(ORT_Image)\""
	puts $outfile "# ----------------------------------------"
	puts $outfile "#      DO NOT EDIT BY HAND!!!!!!!!!!!!"
	puts $outfile "#    (unless you know what you're doing)"
	puts $outfile "# ----------------------------------------\n\n"
	puts $outfile "set MVS(roomname) \"$MVS(roomname)\""
	puts $outfile "set MVS(port) \"$SMVS(port)\""
	puts $outfile "set MVS(roomfile) \"[file tail $SMVS(roomfile)]\""
	puts $outfile "set MVS(ORT_Rating) \"$SMVS(ORT_Rating)\""
	puts $outfile "set MVS(ORT_Description) \"$SMVS(ORT_Description)\""
	puts $outfile "set MVS(ORT_State) \"$SMVS(ORT_State)\""
	puts $outfile "set MVS(ORT_Country) \"$SMVS(ORT_Country)\""
	puts $outfile "set MVS(ORT_Admin) \"$SMVS(ORT_Admin)\""
	puts $outfile "set MVS(ORT_AdminEmail) \"$SMVS(ORT_AdminEmail)\""
	puts $outfile "set MVS(ORT_WebSite) \"$SMVS(ORT_WebSite)\""
	puts $outfile "set MVS(maxheight) \"$SMVS(maxheight)\""
	puts $outfile "set MVS(maxwidth) \"$SMVS(maxwidth)\""
	puts $outfile "set MVS(max_same_users) \"$SMVS(max_same_users)\""
	puts $outfile "set MVS(maxusers) \"$SMVS(maxusers)\""
	puts $outfile "set MVS(push) \"$SMVS(push)\""
	puts $outfile "set MVS(maxmsglen) \"$SMVS(maxmsglen)\""
	puts $outfile "set MVS(register_ort) \"$SMVS(register_ort)\""
	puts $outfile "lappend MVS(ORT_Server) \"$SMVS(ort_hostname):$SMVS(ort_port)\""
	puts $outfile "lappend MVS(ORT_Username) \"$SMVS(ORT_Username)\""
	puts $outfile "lappend MVS(ORT_Password) \"$SMVS(ORT_Password)\""
	puts $outfile "lappend MVS(ORT_Location) \"$SMVS(ort_location_x) $SMVS(ort_location_y)\""

	
	set MVS(register_ort) $SMVS(register_ort)
	set MVS(maxheight) $SMVS(maxheight)
	set MVS(maxwidth) $SMVS(maxwidth)
	set MVS(max_same_users) $SMVS(max_same_users)
	set MVS(push) $SMVS(push)
	set MVS(maxmsglen) $SMVS(maxmsglen)
	set MVS(maxusers) $SMVS(maxusers)
	set MVS(port) $SMVS(port)
	set MVS(roomname) $SMVS(roomname)
	set MVS(roomfile) $SMVS(roomfile)
	set MVS(ORT_Server) "$SMVS(ort_hostname):$SMVS(ort_port)"
	set MVS(ORT_Username) $SMVS(ORT_Username)
	set MVS(ORT_Password) $SMVS(ORT_Password)
	set SMVS(ORT_Location) {}
	lappend MVS(ORT_Location) "$SMVS(ort_location_x) $SMVS(ort_location_y)"
	set MVS(ORT_Rating) $SMVS(ORT_Rating)
	set MVS(ORT_Description) $SMVS(ORT_Description)
	set MVS(ORT_State) $SMVS(ORT_State)
	set MVS(ORT_Country) $SMVS(ORT_Country)
	set MVS(ORT_Admin) $SMVS(ORT_Admin)
	set MVS(ORT_AdminEmail) $SMVS(ORT_AdminEmail)
	set MVS(ORT_WebSite) $SMVS(ORT_WebSite)
	set MVS(ORT_Image) $SMVS(ORT_Image)

	close $outfile
	KillServerSetupWindow
	ReloadConfig
}

proc KillServerSetupWindow {} {
	global MVS MV SMVS
	#
	# Clean up the memory we were using and kill the window.
	#
	catch {.serversetup.ort.image.c delete $SMVS(ort_logo_image)}
	catch {unset SMVS}
	destroy .serversetup
}

proc ChooseServerImage {} {
	global SMVS

	set file [tk_getOpenFile]
	#Performance enhancement
	if {[string compare $file ""]} {set SMVS(roomfile) $file}
}
