# OpenVerse Setup Module 
# 
# This module contains all the functions needed for the setup 
# Window to work.
#
# Module Name		- Setup Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMainWindow
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# Modifications by KaosBeetl:
#    Sort Passageways option, 02/07/2000
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# Performance eenhancements using string compare
# Perfomance increase by using curley braces around functions.

proc InitSetVars {} {
	global SET MV

	#------------------------
	# Bool
	#------------------------
	set SET(honor_exits) $MV(honor_exits)
	set SET(honor_call) $MV(honor_call)
        set SET(sort_bookmarks) $MV(sort_bookmarks)
	set SET(bell) $MV(bell)
	set SET(use_windowmanager_colors) $MV(use_windowmanager_colors)
	set SET(names) $MV(names)
	set SET(tooltips) $MV(tooltips)
	set SET(timestamp) $MV(timestamp)
	set SET(download_avatars) $MV(download_avatars)
	set SET(honor_effects) $MV(honor_effects)
	#-------------------------
	# Numeric
	#-------------------------
	set SET(staytime) $MV(staytime)
	set SET(movespeed) $MV(movespeed)
	set SET(urltimeout) $MV(urltimeout)
	set SET(font.balloon) $MV(font.balloon)
	set SET(font.balloon.size) $MV(font.balloon.size)
	#-------------------------
	# Strings
	#-------------------------
	set SET(panel) "$MV(panel)"
	set SET(nick) "$MV(nick)"
	set SET(anim) "$MV(anim)"
	set SET(browser_cmd) "$MV(browser_cmd)"
	set SET(default_host) "$MV(default_host)"
	set SET(default_port) "$MV(default_port)"
	set SET(personal.sex) "$MV(personal.sex)"
	set SET(personal.image) "$MV(personal.image)"
	set SET(personal.realname) "$MV(personal.realname)"
	set SET(personal.email) "$MV(personal.email)"
	set SET(personal.homepage) "$MV(personal.homepage)"
	set SET(personal.info) "$MV(personal.info)"
	set SET(personal.availability) "$MV(personal.availability)"
	set SET(font.balloon.style) "$MV(font.balloon.style)"
}

#
# This sets up the setup window.
#
proc Setup {} {
	global SET MV

	if {[winfo exists .setup]} {destroy .setup}
	InitSetVars
	set SET(refresh_menu) 0
	image create photo PERSONAL_IMAGE -file [file nativename "$SET(personal.image)"]

	toplevel .setup
	wm title .setup "OpenVerse Setup"
	wm resizable .setup 0 0
	frame .setup.na
	frame .setup.na.l
	frame .setup.na.l.t
	frame .setup.na.l.b
	frame .setup.na.l.t.nick
	frame .setup.na.l.b.avatars
	frame .setup.na.r
	frame .setup.opta
	frame .setup.optaaa
	frame .setup.optaa
	frame .setup.optb
	frame .setup.optba
	frame .setup.optc
	frame .setup.cmds


	checkbutton .setup.opta.colors -text "Color Buttons" -variable \
		SET(use_windowmanager_colors) -onval 0 -offval 1 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.bell -text "Sound" -variable \
		SET(bell) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.names -text "Names" -variable \
		SET(names) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.ttips -text "ToolTips" -variable \
		SET(tooltips) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.opta.av -text "Download Avatars" -variable \
		SET(download_avatars) -onval 1 -offval 0 \
		-relief raised -borderwidth 2

	checkbutton .setup.optaaa.ts -text "Show Timestamps" -variable \
		SET(timestamp) -onval 1 -offval 0 \
		-relief raised -borderwidth 2

	checkbutton .setup.optaa.he -text "Honor Effects" -variable \
		SET(honor_effects) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.optaa.hc -text "Honor Calls" -variable \
		SET(honor_call) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.optaa.hex -text "Honor Exits" -variable \
		SET(honor_exits) -onval 1 -offval 0 \
		-relief raised -borderwidth 2
	checkbutton .setup.optaa.sb -text "Sort Passageways" -variable \
		SET(sort_bookmarks) -onval 1 -offval 0 \
		-relief raised -borderwidth 2

	label .setup.optb.http_l -text "Browser Cmd" -width 14
	entry .setup.optb.http_e

	frame .setup.optb.font -relief sunken -borderwidth 2
	menubutton .setup.optb.font.balloon_font -text "Balloon Font" \
		-indicatoron 1 -relief raised -borderwidth 1 \
		-menu .setup.optb.font.balloon_font.m
	menu .setup.optb.font.balloon_font.m
	set depth 0
	set rows 0
	for {set c 0} {$c <= $MV(font_max)} {incr c} {
		if {!$depth || $rows > 10} {
			incr depth
			set rows 0
			set menulabel "FontList $depth"
			.setup.optb.font.balloon_font.m add cascade -menu \
				.setup.optb.font.balloon_font.m.m$depth \
				-label $menulabel
			menu .setup.optb.font.balloon_font.m.m$depth
		}
		.setup.optb.font.balloon_font.m.m$depth add radiobutton \
			-label "$MV(font.balloon.$c.name)" \
			-variable SET(font.balloon) \
			-value $c
		incr rows
	}
	menubutton .setup.optb.font.font_size -text "Size" \
		-indicatoron 1 -relief raised -borderwidth 1 \
		-menu .setup.optb.font.font_size.m
	menu .setup.optb.font.font_size.m
	.setup.optb.font.font_size.m add radiobutton \
		-label "8" \
		-variable SET(font.balloon.size) \
		-value 8
	.setup.optb.font.font_size.m add radiobutton \
		-label "10" \
		-variable SET(font.balloon.size) \
		-value 10
	.setup.optb.font.font_size.m add radiobutton \
		-label "12" \
		-variable SET(font.balloon.size) \
		-value 12
	.setup.optb.font.font_size.m add radiobutton \
		-label "14" \
		-variable SET(font.balloon.size) \
		-value 14
	.setup.optb.font.font_size.m add radiobutton \
		-label "16" \
		-variable SET(font.balloon.size) \
		-value 16

	radiobutton .setup.optb.font.normal -text "Normal" \
		-variable SET(font.balloon.style) -value "normal"
	radiobutton .setup.optb.font.bold -text "Bold" \
		-variable SET(font.balloon.style) -value "bold"
	radiobutton .setup.optb.font.italic -text "Italic" \
		-variable SET(font.balloon.style) -value "italic"
	radiobutton .setup.optb.font.bold_italic -text "Bold Italic" \
		-variable SET(font.balloon.style) -value "bold_italic"

	frame .setup.optba.serv
	label .setup.optba.serv.l -text "Default Server" -width 14
	entry .setup.optba.serv.e

	frame .setup.optba.port
	label .setup.optba.port.l -text "Default Port"
	entry .setup.optba.port.e

	frame .setup.optc.info -relief sunken -borderwidth 2
	label .setup.optc.info.txt -relief raised -text "Personal Info" \
		-borderwidth 2
	frame .setup.optc.info.meat
	frame .setup.optc.info.meat.img
	button .setup.optc.info.meat.img.img -image PERSONAL_IMAGE \
		-command {}
	
	frame .setup.optc.info.meat.inf
	frame .setup.optc.info.meat.inf.a
	frame .setup.optc.info.meat.inf.b
	frame .setup.optc.info.meat.inf.c
	frame .setup.optc.info.meat.inf.d
	label .setup.optc.info.meat.inf.a.l -text "Real Name" -width 15
	label .setup.optc.info.meat.inf.b.l -text "Email Address" -width 15
	label .setup.optc.info.meat.inf.c.l -text "Home Page" -width 15
	menubutton .setup.optc.info.meat.inf.d.avail -text "Availability" -menu \
		.setup.optc.info.meat.inf.d.avail.m -relief raised \
		-underline 0 -width 15 -borderwidth 1
	menu .setup.optc.info.meat.inf.d.avail.m
	.setup.optc.info.meat.inf.d.avail.m add radiobutton \
		-label "Always Send" -variable SET(personal.availability) \
		-value "Always"
	.setup.optc.info.meat.inf.d.avail.m add radiobutton \
		-label "Never Send" -variable SET(personal.availability) \
		-value "Never"
	.setup.optc.info.meat.inf.d.avail.m add radiobutton \
		-label "Ask Me To Send" -variable SET(personal.availability) \
		-value "Ask"

	label .setup.optc.info.meat.inf.d.l -text "Sex" -width 15
	entry .setup.optc.info.meat.inf.a.e
	entry .setup.optc.info.meat.inf.b.e
	entry .setup.optc.info.meat.inf.c.e
	radiobutton .setup.optc.info.meat.inf.d.oa -text Male \
		-variable SET(personal.sex) -value "Male"
	radiobutton .setup.optc.info.meat.inf.d.ob -text Female \
		-variable SET(personal.sex) -value "Female"
	radiobutton .setup.optc.info.meat.inf.d.oc -text Other \
		-variable SET(personal.sex) -value "Other"

	frame .setup.optc.info.meat.txt
	text .setup.optc.info.meat.txt.t -height 10 -width 60 -wrap word

	frame .setup.optc.list -relief sunken -borderwidth 2
	label .setup.optc.list.txt -relief raised -text "Panel Style" \
		-borderwidth 2
	listbox .setup.optc.list.l -width 20 -height 12 \
		-relief raised -yscrollcommand ".setup.optc.list.scrly set" \
		-xscrollcommand ".setup.optc.list.scrlx set"
	scrollbar .setup.optc.list.scrly -command ".setup.optc.list.l yview"
	scrollbar .setup.optc.list.scrlx -command ".setup.optc.list.l xview" \
		-orient horizontal
	

	scale .setup.na.r.bspeed -from 1 -to 20 -variable SET(staytime) \
		-orient horizontal -label "Balloon Speed" -relief raised \
		-borderwidth 2
	scale .setup.na.r.mspeed -from 1 -to 20 -variable SET(movespeed) \
		-orient horizontal -label "Move Speed" -relief raised \
		-borderwidth 2
	scale .setup.na.r.url -from 1 -to 300 -variable SET(urltimeout) \
		-orient horizontal -label "URL Timeout" -relief raised \
		-borderwidth 2


	label .setup.na.l.t.nick.txt -text "Nick Name" -width 16
	entry .setup.na.l.t.nick.entry
	menubutton .setup.na.l.b.avatars.menu -text "Avatar" -menu \
		.setup.na.l.b.avatars.menu.m -relief raised \
		-underline 0 -width 15 -borderwidth 1
	menu .setup.na.l.b.avatars.menu.m


	set anims 0
	set depth 0
	set count 0
	foreach file [List_Avatars] {
		if !$depth {
			incr depth
			.setup.na.l.b.avatars.menu.m add cascade -menu \
				.setup.na.l.b.avatars.menu.m.m$depth -label "Avatars $depth"
			menu .setup.na.l.b.avatars.menu.m.m$depth
		}
		set SET(avatar_setup.$count) "[file tail $file]"
		.setup.na.l.b.avatars.menu.m.m$depth add command -label [file tail $file] \
			-command "SET_SetAvatar $count"
		incr anims
		incr count
		if {$anims > 19} {
			incr depth
			.setup.na.l.b.avatars.menu.m add cascade -menu \
				.setup.na.l.b.avatars.menu.m.m$depth -label "Avatars $depth"
			menu .setup.na.l.b.avatars.menu.m.m$depth
			set anims 0
		}
	}
	entry .setup.na.l.b.avatars.entry

	button .setup.cmds.cancel -text "Cancel" -command "destroy .setup"
	button .setup.cmds.save -text "Save & Apply" -command "SaveSetup 1"
	button .setup.cmds.apply -text "Apply Only" -command "SaveSetup 2"
	button .setup.cmds.saveo -text "Save Only" -command "SaveSetup 3"
	button .setup.cmds.server -text "Start Server" -command "StartServer"

	pack .setup.na -side top -fill both -expand y
	pack .setup.na.l .setup.na.r .setup.na.r.url -side left -fill both \
		-expand y
	pack .setup.na.l.t -side top -fill both -expand y
	pack .setup.na.l.b -side bottom -fill both -expand y
	pack .setup.na.l.t.nick -fill both -expand y
	pack .setup.na.l.b.avatars -fill both -expand y
	pack .setup.na.l.t.nick.txt -side left
	pack .setup.na.l.t.nick.entry -side left -fill both -expand y
	pack .setup.na.l.b.avatars.menu -side left
	pack .setup.na.l.b.avatars.entry -side left -fill both -expand y
	pack .setup.opta -fill both -expand y
	pack .setup.opta.ttips .setup.opta.bell .setup.opta.names \
		.setup.opta.colors .setup.opta.av \
		-side left -fill both -expand y
	pack .setup.optaaa -fill both -expand y
	pack .setup.optaaa.ts -side left -fill both -expand y
	pack .setup.optaa -fill both -expand y
	pack .setup.optaa.he .setup.optaa.hc .setup.optaa.hex .setup.optaa.sb\
		-side left -fill both -expand y
	pack .setup.optb -fill both -expand y
	pack .setup.optb.http_l -side left
	pack .setup.optb.http_e -side left -fill both -expand y
	pack .setup.optb.font -side left -fill both -expand y
	pack .setup.optb.font.balloon_font .setup.optb.font.font_size .setup.optb.font.normal \
		.setup.optb.font.bold .setup.optb.font.italic .setup.optb.font.bold_italic -side left
	pack .setup.optba -fill both -expand y
	pack .setup.optba.serv -side left -fill both -expand y
	pack .setup.optba.port -side left
	pack .setup.optba.serv.l -side left
	pack .setup.optba.serv.e -side left -fill x -expand y
	pack .setup.optba.port.l .setup.optba.port.e -side left
	pack .setup.optc -fill both -expand y
	pack .setup.optc.info -side left -fill both -expand y
	pack .setup.optc.info.txt -side top -fill x -expand y
	pack .setup.optc.info.meat -side bottom -fill both -expand y
	pack .setup.optc.info.meat.txt -fill both -expand y -side bottom
	pack .setup.optc.info.meat.img -side left
	pack .setup.optc.info.meat.inf -side right -fill both -expand y
	pack .setup.optc.info.meat.img.img -side top
	pack .setup.optc.info.meat.inf.a -fill x -expand y
	pack .setup.optc.info.meat.inf.b -fill x -expand y
	pack .setup.optc.info.meat.inf.c -fill x -expand y
	pack .setup.optc.info.meat.inf.d -fill x -expand y
	pack .setup.optc.info.meat.inf.a.l -side left
	pack .setup.optc.info.meat.inf.a.e -side left -fill x -expand y
	pack .setup.optc.info.meat.inf.b.l -side left
	pack .setup.optc.info.meat.inf.b.e -side left -fill x -expand y
	pack .setup.optc.info.meat.inf.c.l -side left
	pack .setup.optc.info.meat.inf.c.e -side left -fill x -expand y
	pack .setup.optc.info.meat.inf.d.avail \
		.setup.optc.info.meat.inf.d.l -side left
	pack .setup.optc.info.meat.inf.d.oa .setup.optc.info.meat.inf.d.ob \
		.setup.optc.info.meat.inf.d.oc -side left -fill x -expand y
	pack .setup.optc.info.meat.txt.t -fill both -expand y

	pack .setup.optc.list -side right
	pack .setup.optc.list.txt -fill x -expand y -side top
	pack .setup.optc.list.scrlx -fill x -expand y
	pack .setup.optc.list.l -side left -fill y -expand y
	pack .setup.optc.list.scrly -side right -fill y -expand y
	pack .setup.cmds -fill both -expand y

	pack .setup.cmds.cancel .setup.cmds.save .setup.cmds.apply .setup.cmds.saveo .setup.cmds.server -side left -fill both \
		-expand y
	pack .setup.na.r.bspeed .setup.na.r.mspeed -side left -fill both \
		-expand y

	.setup.na.l.t.nick.entry insert end $SET(nick)
	.setup.na.l.b.avatars.entry insert end $SET(anim)
	.setup.optb.http_e insert end $SET(browser_cmd)
	.setup.optba.serv.e insert end $SET(default_host)
	.setup.optba.port.e insert end $SET(default_port)
	.setup.optc.info.meat.inf.a.e insert end $SET(personal.realname)
	.setup.optc.info.meat.inf.b.e insert end $SET(personal.email)
	.setup.optc.info.meat.inf.c.e insert end $SET(personal.homepage)
	.setup.optc.info.meat.txt.t insert end $SET(personal.info)

	bind .setup.na.l.t.nick.entry <KeyRelease> {CheckNick}
	bind .setup.na.l.t.nick.entry <ButtonPress> {CheckNick}
	bind .setup.optc.list.l <ButtonRelease> {
		set SET(panel) [selection get]
		set SET(refresh_menu) 1
	}
	bind .setup <Destroy> {Unset_Setup}
	FillPanels

}

proc SET_SetAvatar {which} {
	global SET

	set SET(anim) "$SET(avatar_setup.$which)"
	.setup.na.l.b.avatars.entry delete 0 end
	.setup.na.l.b.avatars.entry insert end $SET(anim)
}

proc FillPanels {} {
	global SET

	foreach panel [List_Panels] {
		.setup.optc.list.l insert end "[file tail $panel]"
		if {[file tail $panel] == $SET(panel)} {
			.setup.optc.list.l selection set end
			.setup.optc.list.l see end
		}
	}
}


proc SaveSetup {how} {
	global MV
	switch $how {
		1 {
			# Save And Apply.
			SaveSetSettings
			ApplySetSettings
		}
		2 {
			# Apply Only.
			ApplySetSettings
		}
		3 {
			# Save Only.
			SaveSetSettings
		}
	}
	AnimateMe "[.setup.na.l.b.avatars.entry get]" 3
	destroy .setup
}

proc SaveSetSettings {} {
	global SET MV

	set outfile [open "$MV(configfile)" w]
	#------------------------
	# Bool
	#------------------------
	puts $outfile "set MV(honor_effects) $SET(honor_effects)"
	puts $outfile "set MV(honor_exits) $SET(honor_exits)"
	puts $outfile "set MV(honor_call) $SET(honor_call)"
        puts $outfile "set MV(sort_bookmarks) $SET(sort_bookmarks)"
	puts $outfile "set MV(bell) $SET(bell)"
	puts $outfile "set MV(use_windowmanager_colors) $SET(use_windowmanager_colors)"
	puts $outfile "set MV(names) $SET(names)"
	puts $outfile "set MV(tooltips) $SET(tooltips)"
	puts $outfile "set MV(timestamp) $SET(timestamp)"
	puts $outfile "set MV(download_avatars) $SET(download_avatars)"
	#------------------------
	# Numeric
	#------------------------
	puts $outfile "set MV(staytime) $SET(staytime)"
	puts $outfile "set MV(movespeed) $SET(movespeed)"
	puts $outfile "set MV(urltimeout) $SET(urltimeout)"
	puts $outfile "set MV(font.balloon) $SET(font.balloon)"
	puts $outfile "set MV(font.balloon.size) $SET(font.balloon.size)"
	#------------------------
	# Strings
	#------------------------
	puts $outfile "set MV(panel) \"$SET(panel)\""
	puts $outfile "set MV(font.balloon.style) $SET(font.balloon.style)"
	puts $outfile "set MV(nick) \"[.setup.na.l.t.nick.entry get]\""
	puts $outfile "set MV(anim) \"[.setup.na.l.b.avatars.entry get]\""
	puts $outfile "set MV(browser_cmd) \"[.setup.optb.http_e get]\""
	puts $outfile "set MV(roomhost) \"[.setup.optba.serv.e get]\""
	puts $outfile "set MV(roomport) \"[.setup.optba.port.e get]\""
	puts $outfile "set MV(personal.sex) \"$SET(personal.sex)\""
	puts $outfile "set MV(personal.info) \"[.setup.optc.info.meat.txt.t get 0.0 end]\""
	puts $outfile "set MV(personal.realname) \"[.setup.optc.info.meat.inf.a.e get]\""
	puts $outfile "set MV(personal.email) \"[.setup.optc.info.meat.inf.b.e get]\""
	puts $outfile "set MV(personal.homepage) \"[.setup.optc.info.meat.inf.c.e get]\""
	puts $outfile "set MV(personal.image) \"$SET(personal.image)\""
	puts $outfile "set MV(personal.availability) \"$SET(personal.availability)\""
	close $outfile
}

proc ApplySetSettings {} {
	global MV SET

	#------------------------
	# Bool
	#------------------------
	set MV(honor_exits) $SET(honor_exits)
	set MV(honor_call) $SET(honor_call)
        set MV(sort_bookmarks) $SET(sort_bookmarks)
	set MV(bell) $SET(bell)
	set MV(use_windowmanager_colors) $MV(use_windowmanager_colors)
	set MV(names) $SET(names)
	set MV(tooltips) $SET(tooltips)
	set MV(timestamp) $SET(timestamp)
	set MV(download_avatars) $SET(download_avatars)
	set MV(honor_effects) $SET(honor_effects)
	#------------------------
	# Numeric
	#------------------------
	set MV(staytime) $SET(staytime)
	set MV(movespeed) $SET(movespeed)
	set MV(urltimeout) $SET(urltimeout)
	set MV(font.balloon) $SET(font.balloon)
	set MV(font.balloon.size) $SET(font.balloon.size)
	#------------------------
	# Strings
	#------------------------
	set MV(font.balloon.style) $SET(font.balloon.style)
	if $SET(refresh_menu) {
		set MV(panel) "$SET(panel)"
		source "$MV(paneldir)/$MV(panel)"
	}
	set SET(nick) "[.setup.na.l.t.nick.entry get]"
	#Perfoormance Enhancement
	if {[string compare $MV(nick) $SET(nick)]} {
		if $MV(names) {
			KillName $MV(nick)
		}
		set MV($SET(nick).haschat) 0
		set MV($SET(nick).chatque) {}
		ChangeNick "$SET(nick)"
		SendToServer "NICK $MV(nick)"
	}
	set MV(anim) "[.setup.na.l.b.avatars.entry get]"
	set MV(browser_cmd) [split [.setup.optb.http_e get] " "]
	# Room Host not applied !
	# Room Port not applied !
	set MV(personal.sex) "$SET(personal.sex)"
	set MV(personal.image) "$SET(personal.image)"
	set MV(personal.realname) [.setup.optc.info.meat.inf.a.e get]
	set MV(personal.email) [.setup.optc.info.meat.inf.b.e get]
	set MV(personal.homepage) [.setup.optc.info.meat.inf.c.e get]
	set MV(personal.info) [.setup.optc.info.meat.txt.t get 0.0 end]
	set MV(personal.availability) $SET(personal.availability)
}

proc Unset_Setup {} {
	global SET
	catch {unset SET}
}
