#!/bin/sh -f 
#
#  $Header: /Master/Common/Tools/Scripts/in.sh,v 3.0.3.1 1998/05/30 11:25:53 phillf Exp $
#
#	Copyright(c) 95-96 Fridu a Free software company (Philippe Le Foll)
#
# File      :   in.sh checkin a file in the Master
# Projet    : 	vxNT
# SubModule :   encapculated RCS call
# Auteur    :   Philippe Le Foll (phillf@iu-vannes.fr)
#
# Last
#      Modification: add ; in sed command for metahtml
#      Author      : $Author: phillf $
#      Date        : $Date: 1998/05/30 11:25:53 $
#      Revision    : $Revision: 3.0.3.1 $
#      Source      : $Source: /Master/Common/Tools/Scripts/in.sh,v $
#      State       : $State: Exp $
#
# $Log: in.sh,v $
# Revision 3.0.3.1  1998/05/30 11:25:53  phillf
# First W95 version
#
# Revision 1.1.1.1  1998/01/28 13:20:57  phillf
# Moved to rubicon
#
# Revision 1.1.1.1  1998/01/14 17:12:58  phillf
# Newx arch for 3.01
#
# Revision 1.1.1.1  1997/10/19 15:05:56  phillf
# New project/module tree
#
# Revision 1.1.1.1  1996/12/20 09:05:28  phillf
# First Splited Master version
#
# Revision 1.1.1.1  1996/12/08 13:47:09  phillf
# Initiale cvs Version
#
# Revision 1.5  1996/11/27 20:38:25  phillf
#  add ; in sed command for metahtml
#
# Revision 1.4  1996/11/24 16:48:30  phillf
#  Echo selected modhist when checkin
#
# Revision 1.3  1996/11/24 16:46:27  phillf
#  Echo selected modhist when checkin
#
# Revision 1.2  1996/11/24 15:04:19  phillf
#  add auto history facility
#
#
# Revision 1.1  1996/11/18 14:04:13  phillf
#  Writen
#

# tell bash under Linux to follow link
set -P

for FILE in $*
do
	if test -f $FILE
        then
                MOD_HIST=`sed -n '/^[\#, ,/,*,;]*Modification./s///p' <$FILE`
		echo modhist=[$MOD_HIST]
		ci -m"$MOD_HIST" $FILE || break
		ln -s RCS/../$FILE $FILE
		cd RCS/..
		co -q -u $FILE
		
	else
		echo "WARNING: $FILE not a plain file ignored"
        fi
done
