#
# costinit.tcl
# Initialization file for Cost 2
# $Revision: 1.13 $
#

global COST COSTLIB env

if {![info exists COST] || $COST(MAJOR) != 2 || $COST(MINOR) != 2} {
    set errmsg "Warning: Cost version mismatch: expected Cost 2.2"
    if {[info exists COST]} { append errmsg ", got $COST(VERSION)" }
    puts stderr $errmsg
}

#
# Try to figure out library path:
#
if {[info exists env(COSTLIB)]} {
    set COSTLIB $env(COSTLIB)
} elseif {![info exists COSTLIB]} {
    if {[catch {
	set COSTLIB [file join [file dirname [info library]] cost2.2] 
    }]} {
	set COSTLIB /usr/local/lib/cost2.2
    }
}

global COST(searchPath);	# Search path for 'require' command

if {[info exists env(COSTPATH)]} {
    set COST(searchPath) [split $env(COSTPATH) ":"]
}
lappend COST(searchPath) $COSTLIB
#
# Load core utilities:
#
source $COSTLIB/Core.tcl

### costsh-specific commandline processing:
#
# costsh [-S specfile]
#

proc cost_commandline {} {
    global argv
    set filter 0
    while {[string match "-*" $argv]} {
	switch -- [set option [shift argv]] {
	    -S {
		set specfile [shift argv]
		set filter 1
		break;
	    }
	    -f {
		set filter 1
	    }
	    default {
	       error "unrecognized option $arg"
	   }
	}
    }
    if {$filter} {loadsgmls stdin}
    if {[info exists specfile]} {
	require $specfile
	if { [lsearch [info procs] main] != -1 } { main }
    }
}
#*EOF*
