/*
 * File: tclAppInit.c
 * Tcl_AppInit() and main() routines for costsh and costwish
 * If -DUSE_TK is defined, calls Tk_Main (for costwish);
 * otherwise calls Tcl_Main (for costsh).
 *
 * Compile with -DUSE_XXX to include other extensions (see below)
 * NOTE: most combinations of extensions have NOT been tested.
 *
 * Joe English <joe@flightlab.com>
 */

#ifndef USE_ITCL
#define USE_ITCL 0
#endif
#ifndef USE_TCLX
#define USE_TCLX 0
#endif
#ifndef USE_TK
#define USE_TK 0
#endif
#ifndef USE_BLT
#define USE_BLT 0
#endif
#ifndef USE_TIX
#define USE_TIX 0
#endif

#if USE_ITCL
#	define ITCL_NAMESPACES 1
#endif

#include <stdlib.h>
#include <stdio.h>
#include "tcl.h"
#include "project.h"

/* Extension headers: */
#if USE_ITCL
#	include "itcl.h"
#endif
#if USE_TK
#	include "tk.h"
#endif
#if USE_TCLX
#	include "tclExtend.h"
#endif

/* Declarations for extensions w/no headers:  */

extern int Cost_Init(Tcl_Interp *);

extern int Blt_Init(Tcl_Interp *);	/* #if USE_BLT */
extern int Tix_Init(Tcl_Interp *);	/* #if USE_TIX */

static char init_script[] = "cost_commandline";

/* If we're in batch mode (sgmls ... | costsh ...)
 * and 'cost_commandline' (or any other initialization) fails,
 * there's a good chance that stdin has not yet been consumed.
 * Since we _definitely_ don't want to feed sgmls' output to
 * Tcl, we exit immediately if an initialization error occurs
 * and this is not an interactive shell.
 */
static char error_script[] =
    "puts stdout $errorInfo; if {$tcl_interactive == 0} { exit 1 }\n";

int Tcl_AppInit(Tcl_Interp *interp)
{
    int status = TCL_OK;

    if ((status = Tcl_Init(interp)) != TCL_OK)
	return TCL_ERROR;

#if USE_TCLX
    if ((status = TclX_Init(interp)) != TCL_OK) goto error;
#endif
#if USE_ITCL
    if ((status = Itcl_Init(interp)) != TCL_OK) goto error;
#endif
#if USE_TK
    if ((status = Tk_Init(interp)) != TCL_OK) goto error;
#	if USE_BLT
		if ((status = Blt_Init(interp)) != TCL_OK) goto error;
#	endif
#	if USE_TIX
		if ((status = Tix_Init(interp)) != TCL_OK) goto error;
#	endif
#endif	/* USE_TK */

    /*
     * Initialize Cost:
     */
#if defined(PKGDIR)
    /* Set default value for COSTLIB, so user doesn't have
     * to specify it in the environment:
     */
    Tcl_SetVar(interp, "COSTLIB", PKGDIR, TCL_GLOBAL_ONLY);
#endif
    if ((status = Cost_Init(interp)) != TCL_OK)
	goto error;

    if ((status = Tcl_Eval(interp, init_script)) != TCL_OK)
	goto error;

    return status;

error:
#if HAVE_TCL_CHANNEL_IO
    {
	Tcl_Channel errChannel = Tcl_GetStdChannel(TCL_STDERR);
	errChannel = Tcl_GetStdChannel(TCL_STDERR);
	if (errChannel) {
	    Tcl_Write(errChannel, "COST initialization failure: ", -1);
	    Tcl_Write(errChannel, interp->result, -1);
	    Tcl_Write(errChannel, "\n", 1);
	}
    }
#else
    fprintf(stderr, "COST initialization failure: %s\n", interp->result);
#endif
    Tcl_Eval(interp, error_script);
    return status;
}

int main(int argc, char *argv[])
{
#if USE_TK
    Tk_Main(argc, argv, Tcl_AppInit);
#else
    Tcl_Main(argc, argv, Tcl_AppInit);
#endif
    return 0;
}
/*EOF*/
