/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * tokmatch.c,v 1.3 1998/11/10 00:07:01 jenglish Exp
 *
 * Author: 	Joe English
 * Created: 	6 May 1995
 * Description:	function tokmatch(token, toklist);
 * 		'token' is an alphanumeric string; 'toklist' is
 *		a space-separated sequence of same.  Check if
 *		'token' is a member of 'toklist'.
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int tokmatch(const char *token, const char *toklist)
{
    const char *tp, *lp;

    lp = toklist;
    while (*lp)
    {
	/* scan to next token in list: */
	while (isspace(*lp))
		++lp;

	/* check if 'token' matches: */
	tp = token;
	while (*lp && !isspace(*lp))
	{
	    if (tp && *tp == *lp)
		++tp;
	    else
		tp = 0;
	    ++lp;
	}

	/* lp at end of current token; if tp at end of token, it matched*/
	if (tp && !*tp)
		return 1;
    }
    /* end of list; no match */
    return 0;
}

/* tokmatchic: same as above, but case-insensitive compare */
int tokmatchic(const char *token, const char *toklist)
{
    const char *tp, *lp;
    lp = toklist;
    while (*lp)
    {
	while (isspace(*lp)) ++lp;
	tp = token;
	while (*lp && !isspace(*lp))
	{
	    if (tp && toupper(*tp) == toupper(*lp)) ++tp;
	    else tp = 0;
	    ++lp;
	}
	if (tp && !*tp) return 1;
    }
    return 0;
}

/*
 * tokcmpic: compare two strings for equality, case-insensitive:
 */
int tokcmpic(const char *p, const char *q)
{
	while (*p && toupper(*p) == toupper(*q)) { ++p, ++q; }
	return !(*p|*q);
}
